/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.aggregator.cache.meta;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.vjet.dsf.resource.permutation.Permutation;
import org.eclipse.vjet.dsf.resource.permutation.PermutationSpec;
import org.eclipse.vjet.vsf.aggregator.cache.meta.IExternalizationInfo;
import org.eclipse.vjet.vsf.aggregator.cache.meta.ViewJsExternalizationInfo;

public class AppJsExternalizationInfo
implements IExternalizationInfo {
    private String m_appId;
    private String m_buildId;
    private Map<String, ViewJsExternalizationInfo> m_viewJsInfos = new LinkedHashMap<String, ViewJsExternalizationInfo>();
    private long m_changeSetId;

    public AppJsExternalizationInfo(String appId, String buildId) {
        this.m_appId = appId;
        this.m_buildId = buildId;
    }

    public String getAppId() {
        return this.m_appId;
    }

    public String getBuildId() {
        return this.m_buildId;
    }

    public Collection<ViewJsExternalizationInfo> getAllViewJsInfos() {
        return this.m_viewJsInfos.values();
    }

    public Collection<String> getAllViewIds() {
        return this.m_viewJsInfos.keySet();
    }

    public ViewJsExternalizationInfo getViewJsInfo(String viewId) {
        return this.m_viewJsInfos.get(viewId);
    }

    public void addViewJsInfo(ViewJsExternalizationInfo viewJsInfo) {
        this.m_viewJsInfos.put(viewJsInfo.getViewId(), viewJsInfo);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("appId=").append(this.m_appId).append("\n");
        sb.append("buildId=").append(this.m_buildId).append("\n");
        for (ViewJsExternalizationInfo info : this.getAllViewJsInfos()) {
            sb.append(info.toString()).append("\n");
        }
        return sb.toString();
    }

    @Override
    public void updateAggregationId(String viewId, String slotIndex, Permutation permutation, boolean isSecure, String resAggId, String aggChecksum) {
        String locale = permutation.getLocale().toString();
        Collection<ViewJsExternalizationInfo> allJsInfo = this.getAllViewJsInfos();
        for (ViewJsExternalizationInfo jsInfo : allJsInfo) {
            if (!jsInfo.getViewId().equals(viewId)) continue;
            Map<String, ViewJsExternalizationInfo.GrouppedJsInfo> localeGrouppedJsInfo = jsInfo.getLocaleGrouppedJsInfo().get(locale);
            if (localeGrouppedJsInfo != null && localeGrouppedJsInfo.get(slotIndex) != null) {
                ViewJsExternalizationInfo.GrouppedJsInfo info = localeGrouppedJsInfo.get(slotIndex);
                info.addAggChecksum(resAggId, aggChecksum);
                info.addAggChecksum(resAggId, aggChecksum);
                if (isSecure) {
                    info.setSecureAggResId(resAggId);
                    continue;
                }
                info.setNonSecureAggResId(resAggId);
                continue;
            }
            Collection<ViewJsExternalizationInfo.GrouppedJsInfo> defaultGroupJsInfo = jsInfo.getAllGrouppedJsInfo();
            for (ViewJsExternalizationInfo.GrouppedJsInfo info : defaultGroupJsInfo) {
                info.addAggChecksum(resAggId, aggChecksum);
                info.registerPermutation(permutation);
                if (!info.getIndex().equals(slotIndex)) continue;
                if (isSecure) {
                    if (info.getSecureAggResId() == null) {
                        info.setSecureAggResId(resAggId);
                        continue;
                    }
                    if (resAggId.equals(info.getSecureAggResId())) continue;
                    info.addSecureAggResid(permutation, resAggId);
                    continue;
                }
                if (info.getNonSecureAggResId() == null) {
                    info.setNonSecureAggResId(resAggId);
                    continue;
                }
                if (resAggId.equals(info.getNonSecureAggResId())) continue;
                info.addNonSecureAggResid(permutation, resAggId);
            }
        }
    }

    @Override
    public boolean validate() {
        return true;
    }

    @Override
    public Collection<IExternalizationInfo.AggregationInfo> getAggregationInfo(String viewId) {
        ArrayList<IExternalizationInfo.AggregationInfo> result = new ArrayList<IExternalizationInfo.AggregationInfo>();
        String defaultLocale = this.getDefaultLocale();
        ViewJsExternalizationInfo jsInfo = this.getViewJsInfo(viewId);
        if (jsInfo == null) {
            return result;
        }
        Collection<ViewJsExternalizationInfo.GrouppedJsInfo> defaultGroupJsInfo = jsInfo.getAllGrouppedJsInfo();
        for (ViewJsExternalizationInfo.GrouppedJsInfo info : defaultGroupJsInfo) {
            IExternalizationInfo.AggregationInfo aggInfo = this.createAggregationInfo(info, defaultLocale);
            result.add(aggInfo);
        }
        Set<String> locales = jsInfo.getLocales();
        for (String locale : locales) {
            Collection<ViewJsExternalizationInfo.GrouppedJsInfo> localeGroupJsInfo = jsInfo.getAllGrouppedJsInfo(locale);
            if (localeGroupJsInfo == null) continue;
            for (ViewJsExternalizationInfo.GrouppedJsInfo info : localeGroupJsInfo) {
                IExternalizationInfo.AggregationInfo localeAggInfo = this.createAggregationInfo(info, locale);
                result.add(localeAggInfo);
            }
        }
        return result;
    }

    private String getDefaultLocale() {
        String defaultLocale = Locale.US.toString();
        PermutationSpec spec = Permutation.getPermutationSpec();
        if (spec != null && spec.getDefaultPermutation() != null) {
            defaultLocale = spec.getDefaultPermutation().getLocale().toString();
        }
        return defaultLocale;
    }

    private IExternalizationInfo.AggregationInfo createAggregationInfo(ViewJsExternalizationInfo.GrouppedJsInfo group, String locale) {
        List<String> urns = group.getResolvedUrns();
        IExternalizationInfo.AggregationInfo result = new IExternalizationInfo.AggregationInfo();
        result.addAllUrns(urns);
        result.setLocale(locale);
        return result;
    }

    public void setChangeSetId(long changeSetId) {
        this.m_changeSetId = changeSetId;
    }

    public long getChangeSetId() {
        return this.m_changeSetId;
    }
}

