/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.aggregator.event.export;

import java.util.List;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.dom.DElement;
import org.eclipse.vjet.dsf.html.ctx.HtmlCtx;
import org.eclipse.vjet.dsf.html.dom.BaseHtmlElement;
import org.eclipse.vjet.dsf.html.dom.DBody;
import org.eclipse.vjet.dsf.html.dom.HtmlTypeEnum;
import org.eclipse.vjet.dsf.html.events.DsfEventTarget;
import org.eclipse.vjet.dsf.html.events.EventHandlerAttacher;
import org.eclipse.vjet.dsf.html.events.EventHandlerContainer;
import org.eclipse.vjet.dsf.html.events.IDomEventType;
import org.eclipse.vjet.dsf.html.events.InlineEventHandlerConverter;
import org.eclipse.vjet.dsf.resource.slot.JsResourceSlotter;
import org.eclipse.vjet.dsf.spec.collector.ResourceSpecCollector;
import org.eclipse.vjet.dsf.spec.component.IComponentSpec;
import org.eclipse.vjet.dsf.spec.resource.IResourceSpec;
import org.eclipse.vjet.vsf.EventDispatcherJsr;
import org.eclipse.vjet.vsf.aggregator.event.export.EventDispatcherEnabler;
import org.eclipse.vjet.vsf.aggregator.event.export.IEventDispatcherAssembler;
import org.eclipse.vjet.vsf.jsruntime.context.JsRuntimeCtx;
import org.eclipse.vjet.vsf.resource.pattern.js.IJsResourceRef;
import org.eclipse.vjet.vsf.resource.pattern.js.JsResource;
import org.eclipse.vjet.vsf.resource.pattern.js.JsType;
import org.eclipse.vjet.vsf.resource.pattern.js.OnFlyJsResourceDispenser;
import vjo.RegistryJsr;

public class EventDispatcherAssembler
extends OnFlyJsResourceDispenser
implements IEventDispatcherAssembler {
    private static final String NEW_LINE = System.getProperty("line.separator");
    public static final String BODY_ID = "body";
    public boolean m_optimizeJs = true;
    private static EventDispatcherAssembler s_instance = new EventDispatcherAssembler();

    protected EventDispatcherAssembler() {
    }

    public static EventDispatcherAssembler getInstance() {
        return s_instance;
    }

    @Override
    public void processEventHandling(DBody body, JsResourceSlotter slotter) {
        EventHandlerContainer eventHdlContainer;
        String id = body.getHtmlId();
        if (id == "" || id == null) {
            body.setHtmlId(BODY_ID);
        }
        if (HtmlCtx.ctx().isDisableInlineHandler()) {
            InlineEventHandlerConverter.convert();
        }
        if ((eventHdlContainer = HtmlCtx.ctx().getEventHandlerContainer()).size() == 0) {
            return;
        }
        EventDispatcherEnabler enabler = new EventDispatcherEnabler();
        EventDispatcherAssembler.addToJsSlot(slotter, EventDispatcherJsr.ResourceSpec.getInstance());
        EventDispatcherAssembler.addToJsSlot(slotter, RegistryJsr.ResourceSpec.getInstance());
        String data = EventDispatcherEnabler.extractEventHandlerData(eventHdlContainer, this.m_optimizeJs);
        if (data != null && !"".equals(data)) {
            slotter.addToSlot(EventDispatcherAssembler.jsRef(JsResource.viaText((String)data, null), JsType.ExecutionOnly));
        }
        if (JsRuntimeCtx.ctx().useInlineEventBinding()) {
            this.attachEventHandlingTrigger(body, eventHdlContainer, enabler);
        }
    }

    private static void addToJsSlot(JsResourceSlotter slotter, IComponentSpec rootSpec) {
        ResourceSpecCollector specCollector = new ResourceSpecCollector();
        specCollector.aggregate((IResourceSpec)rootSpec);
        for (IResourceSpec spec : specCollector) {
            for (IJsResourceRef resource : spec.getClassDefinitions()) {
                slotter.addToSlot(resource);
            }
            for (IJsResourceRef resource : spec.getExecutingScript()) {
                slotter.addToSlot(resource);
            }
        }
    }

    protected void attachEventHandlingTrigger(DBody body, EventHandlerContainer container, EventDispatcherEnabler enabler) {
        for (DsfEventTarget element : container.getElements().keySet()) {
            DElement elem = element.getElem();
            if (!(elem instanceof BaseHtmlElement) || elem instanceof DBody) continue;
            this.attachEventHandlingTrigger(body, element, container, enabler);
        }
    }

    protected void attachEventHandlingTrigger(DBody body, DsfEventTarget element, EventHandlerContainer container, EventDispatcherEnabler enabler) {
        if (!EventHandlerAttacher.hasEventHandlers((DElement)element.getElem())) {
            return;
        }
        Object elementToWorkOn = element.getType() == HtmlTypeEnum.BODY || element.getElem() instanceof DBody ? body : element.getElem();
        for (EventHandlerContainer.EventsToHandlerPair pair : (List)container.getElements().get(element)) {
            IDomEventType type = pair.getEventType();
            if (type == null) continue;
            this.setUpEventTriggers((DElement)elementToWorkOn, enabler, type);
        }
    }

    private void setUpEventTriggers(DElement element, EventDispatcherEnabler enabler, IDomEventType eventType) {
        enabler.addEventTrigger(element, eventType);
        enabler.enableEvent(eventType);
    }

    private static void chuck(String message) {
        throw new DsfRuntimeException(message);
    }

    private static IJsResourceRef jsRef(JsResource resource, JsType type) {
        return EventDispatcherAssembler.jsRef((JsResource)resource, EventDispatcherAssembler.class, (JsType)type);
    }

    public boolean isOptimizeJs() {
        return this.m_optimizeJs;
    }

    public void setOptimizeJs(boolean js) {
        this.m_optimizeJs = js;
    }
}

