/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.dervlet;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.vjet.dsf.common.cmdexec.CommandExecutor;

public class BrowserManager {
    private static final String WIN_ID = "Windows";
    private static final String WIN2K3_ID = "Windows Server 2003";
    private static final String WIN_PATH = "rundll32";
    private static final String WIN_FLAG = "url.dll,FileProtocolHandler";
    private static final String UNIX_PATH = "chrome";
    private static final String UNIX_FLAG = "-remote openURL";
    private static final boolean IS_WINDOWS = BrowserManager.isWindowsPlatform();

    public static void displayUrlInIE(String url) {
        CommandExecutor.executeCommand((String)("explorer " + url));
    }

    public static void displayContentInIE(String content, String extension) {
        BrowserManager.displayUrlInIE(BrowserManager.createTempFile(content, extension));
    }

    public static boolean isInternetExplorerAvailable() {
        File file = null;
        if (BrowserManager.isWindows2K3Platform()) {
            file = new File("c:\\program files (x86)\\Internet Explorer\\iexplore.exe");
            return file.exists();
        }
        file = new File("c:\\program files\\Internet Explorer\\iexplore.exe");
        return file.exists();
    }

    public static Process displayUrlInInternetExplorer(String url) {
        String[] cmd = new String[]{BrowserManager.isWindows2K3Platform() ? "c:\\program files (x86)\\Internet Explorer\\iexplore.exe" : "c:\\program files\\Internet Explorer\\iexplore.exe", url};
        try {
            return Runtime.getRuntime().exec(cmd);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void displayContentInInternetExplorer(String content, String extension) {
        BrowserManager.displayUrlInInternetExplorer(BrowserManager.createTempFile(content, extension));
    }

    public static boolean isFirefoxAvailable() {
        File file = null;
        if (BrowserManager.isWindows2K3Platform()) {
            file = new File("c:\\program files (x86)\\mozilla firefox\\firefox.exe");
            return file.exists();
        }
        file = new File("c:\\program files\\mozilla firefox\\firefox.exe");
        return file.exists();
    }

    public static void displayUrlInFirefox(String url) {
        if (BrowserManager.isWindows2K3Platform()) {
            BrowserManager.displayUrlIn("c:\\program files (x86)\\mozilla firefox\\firefox.exe", url);
        } else {
            BrowserManager.displayUrlIn("c:\\program files\\mozilla firefox\\firefox.exe", url);
        }
    }

    public static void displayUrlInSafari(String url) {
        if (BrowserManager.isWindows2K3Platform()) {
            BrowserManager.displayUrlIn("C:\\Program Files (x86)\\Safari\\Safari.exe", url);
        } else {
            BrowserManager.displayUrlIn("c:\\program files\\Safari\\Safari.exe", url);
        }
    }

    public static void displayUrlInChrome(String url) {
        BrowserManager.displayUrlIn("C:\\Documents and Settings\\mpalaima\\Local Settings\\Application Data\\Google\\Chrome\\Application\\chrome.exe", url);
    }

    public static void main(String[] args) {
        BrowserManager.displayUrlIn("C:\\Documents and Settings\\zyin\\Local Settings\\Application Data\\Google\\Chrome\\Application\\chrome.exe", "http://www.ebay.com");
    }

    public static void displayContentInFirefox(String content, String extension) {
        BrowserManager.displayUrlInFirefox(BrowserManager.createTempFile(content, extension));
    }

    private static String createTempFile(String content, String extension) {
        try {
            File temp = File.createTempFile("data", "." + extension);
            FileOutputStream fos = new FileOutputStream(temp);
            fos.write(content.getBytes());
            fos.close();
            String p = "file:///" + temp.getAbsolutePath();
            return p;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isOperaAvailable() {
        File file = null;
        if (BrowserManager.isWindows2K3Platform()) {
            file = new File("c:\\program files (x86)\\opera\\opera.exe");
            return file.exists();
        }
        file = new File("c:\\program files\\opera\\opera.exe");
        return file.exists();
    }

    public static void displayContentInOpera(String content, String extension) {
        BrowserManager.displayUrlInOpera(BrowserManager.createTempFile(content, extension));
    }

    public static void displayUrlInOpera(String url) {
        if (BrowserManager.isWindows2K3Platform()) {
            BrowserManager.displayUrlIn("c:\\program files (x86)\\opera\\opera.exe", url);
        } else {
            BrowserManager.displayUrlIn("c:\\program files\\opera\\opera.exe", url);
        }
    }

    public static void displayUrlIn(String displayersExePath, String url) {
        String[] cmd = new String[]{displayersExePath, url};
        CommandExecutor.executeCommand((String[])cmd);
    }

    public static void displayContentInDefault(String content, String extension) {
        BrowserManager.displayUrlInDefault(BrowserManager.createTempFile(content, extension));
    }

    public static void displayUrlInDefault(String url) {
        block6: {
            String cmd = null;
            try {
                if (IS_WINDOWS) {
                    cmd = "rundll32 url.dll,FileProtocolHandler " + url;
                    Runtime.getRuntime().exec(cmd);
                    break block6;
                }
                cmd = "chrome -remote openURL(" + url + ")";
                Process p = Runtime.getRuntime().exec(cmd);
                try {
                    int exitCode = p.waitFor();
                    if (exitCode != 0) {
                        cmd = "chrome " + url;
                        p = Runtime.getRuntime().exec(cmd);
                    }
                }
                catch (InterruptedException x) {
                    BrowserManager.err("Error launching browser, cmd='" + cmd + "'");
                    BrowserManager.err("Encountered exception: " + x);
                }
            }
            catch (IOException x) {
                BrowserManager.err("Could not launch browser, command=" + cmd);
                BrowserManager.err("Encountered exception: " + x);
            }
        }
    }

    private static boolean isWindowsPlatform() {
        String os = System.getProperty("os.name");
        return os != null && os.startsWith(WIN_ID);
    }

    private static boolean isWindows2K3Platform() {
        String os = System.getProperty("os.name");
        return os != null && os.startsWith(WIN2K3_ID);
    }

    private static void err(String message) {
        System.err.println(message);
    }
}

