/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.dervlet.embedded.proxy;

import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.ssl.SslSocketConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.vjet.vsf.dervlet.embedded.proxy.ProxyServer;
import org.eclipse.vjet.vsf.dervlet.embedded.server.EmbeddedServer;
import org.eclipse.vjet.vsf.dervlet.embedded.server.EmbeddedServerConfig;

public class EmbeddedProxyServer
extends EmbeddedServer {
    public static EmbeddedProxyServer createProxyServer(int port, String contextPath, String resourceBase) {
        EmbeddedServerConfig config = new EmbeddedServerConfig(port, contextPath, resourceBase);
        return EmbeddedProxyServer.createProxyServer(config);
    }

    public static EmbeddedProxyServer createProxyServer(EmbeddedServerConfig config) {
        if (config == null) {
            throw new RuntimeException("Config must not be null");
        }
        EmbeddedProxyServer server = (EmbeddedProxyServer)EmbeddedProxyServer.getServer(config.getPort());
        if (server != null) {
            return server;
        }
        server = new EmbeddedProxyServer();
        server.initProxyServer(config);
        return server;
    }

    private void initProxyServer(EmbeddedServerConfig config) {
        config.setPort(this.getNextAvailablePort(config.getPort(), 100));
        this.m_config = config;
        this.m_server = new ProxyServer(config.getPort());
        if (config.getSslEnabled()) {
            SslSocketConnector sslConnector = new SslSocketConnector();
            sslConnector.setPort(config.getSslPort());
            if (config.getSslKeystore() != null) {
                sslConnector.setKeystore(config.getSslKeystore());
            }
            if (config.getSslPassword() != null) {
                sslConnector.setPassword(config.getSslPassword());
            }
            this.m_server.addConnector((Connector)sslConnector);
        }
        this.m_server.setStopAtShutdown(true);
        this.m_server.setSendServerVersion(true);
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        this.m_server.setHandler((Handler)contexts);
        this.m_appContext = new ServletContextHandler((HandlerContainer)contexts, this.m_config.getContextPath(), 1);
        this.m_appContext.setResourceBase(this.m_config.getResourceBase());
        this.m_appContext.setClassLoader(Thread.currentThread().getContextClassLoader());
        this.m_adminContext = new ServletContextHandler((HandlerContainer)contexts, "/dervlet-admin", 1);
        this.m_adminContext.setClassLoader(Thread.currentThread().getContextClassLoader());
    }

    protected EmbeddedProxyServer() {
    }
}

