/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.resource.slot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.resource.pattern.IResourceRef;

public class ResourceSlot<T extends IResourceRef> {
    private final String m_name;
    private final List<T> m_resourceRefs = new ArrayList<T>();
    private final List<T> m_unmodifiableResourceRefs = Collections.unmodifiableList(this.m_resourceRefs);
    private final Set<String> m_urns = new HashSet<String>();

    public ResourceSlot(String name) {
        this.assertNotNull(name, "Resource slot name must not be null");
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    public List<T> getResourceRefs() {
        return this.m_unmodifiableResourceRefs;
    }

    public boolean add(T resourceRef) {
        this.assertNotNull(resourceRef, "Added resource ref must not be null");
        String urn = resourceRef.getUrn();
        if (this.m_urns.contains(urn)) {
            return false;
        }
        this.m_urns.add(urn);
        return this.m_resourceRefs.add(resourceRef);
    }

    public boolean remove(T resourceRef) {
        this.assertNotNull(resourceRef, "Resource ref to remove must not be null");
        if (this.m_resourceRefs.remove(resourceRef)) {
            this.m_urns.remove(resourceRef.getUrn());
            return true;
        }
        return false;
    }

    public boolean has(String urn) {
        return this.m_urns.contains(urn);
    }

    private void assertNotNull(Object o, String msg) {
        if (o == null) {
            throw new DsfRuntimeException(msg);
        }
    }
}

