/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.resource.slot;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.resource.slot.ResourceSlot;

public abstract class ResourceSlotter<T extends ResourceSlot> {
    private final Map<String, T> m_slots = new LinkedHashMap<String, T>();
    private LinkedHashSet<String> m_slotsOrder = null;
    protected boolean m_allowDynamicSlots = true;

    protected abstract T createSlot(String var1);

    public void setSlotsOrder(String[] slotsOrder, boolean allowDynamicSlots) {
        this.m_slotsOrder = new LinkedHashSet(slotsOrder.length);
        String[] stringArray = slotsOrder;
        int n = slotsOrder.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            this.m_slotsOrder.add(name);
            ++n2;
        }
        this.m_allowDynamicSlots = allowDynamicSlots;
    }

    public String[] getSlotsOrder() {
        return this.m_slotsOrder.toArray(new String[this.m_slotsOrder.size()]);
    }

    public T getSlot(String name) {
        return this.getSlot(name, true);
    }

    public T getSlot(String name, boolean create) {
        if (!this.m_allowDynamicSlots && !this.m_slotsOrder.contains(name)) {
            throw new DsfRuntimeException(String.valueOf(name) + " is not in the sealed list: " + this.m_slotsOrder.toArray().toString());
        }
        ResourceSlot slot = (ResourceSlot)this.m_slots.get(name);
        if (slot == null && create) {
            slot = this.createSlot(name);
            this.m_slots.put(name, slot);
        }
        return (T)slot;
    }

    public boolean removeSlot(String name) {
        return this.m_slots.remove(name) != null;
    }

    public Iterable<T> getAllSlots() {
        if (this.m_slotsOrder == null || this.m_slots.size() <= 1) {
            return this.m_slots.values();
        }
        ArrayList<ResourceSlot> orderedList = new ArrayList<ResourceSlot>(this.m_slots.size());
        for (String name : this.m_slotsOrder) {
            ResourceSlot slot = (ResourceSlot)this.m_slots.get(name);
            if (slot == null) continue;
            orderedList.add(slot);
        }
        for (ResourceSlot slot : this.m_slots.values()) {
            if (orderedList.contains(slot)) continue;
            orderedList.add(slot);
        }
        return orderedList;
    }

    public String isInAnySlot(String urn) {
        for (ResourceSlot slot : this.m_slots.values()) {
            if (!slot.has(urn)) continue;
            return slot.getName();
        }
        return null;
    }
}

