/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.resource.permutation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.vjet.dsf.resource.permutation.Permutation;

public abstract class PermutationSpec
implements Serializable {
    static final String TARGET_DELIMETER = "__";
    static final String VARIATION_SEPARATOR = "___";
    protected Permutation[] m_allPermutations = new Permutation[0];

    public abstract Permutation getDefaultPermutation();

    public abstract String getDefaultTarget();

    public Permutation[] getAllPermutations() {
        return this.m_allPermutations;
    }

    public Permutation lookup(Locale language, String target) {
        return this.lookupInternal(language, null, target);
    }

    public Permutation lookup(Locale language, String country, String target) {
        return this.lookupInternal(language, country, target);
    }

    private Permutation lookupInternal(Locale language, String country, String target) {
        if (this.m_allPermutations == null) {
            return null;
        }
        Permutation[] permutationArray = this.m_allPermutations;
        int n = this.m_allPermutations.length;
        int n2 = 0;
        while (n2 < n) {
            Permutation perm = permutationArray[n2];
            if (this.safeEquals(language, perm.getLanguage()) && this.safeEquals(target, perm.getTarget()) && this.safeEquals(country, perm.getCountry())) {
                return perm;
            }
            ++n2;
        }
        return null;
    }

    public boolean safeEquals(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public boolean isDefaultPermutation(Permutation permutation) {
        Permutation defaultPermutation = this.getDefaultPermutation();
        if (defaultPermutation == null) {
            return permutation == null;
        }
        return defaultPermutation.equals(permutation);
    }

    public boolean isDefaultTarget(String target) {
        String defaultTarget = this.getDefaultTarget();
        if (defaultTarget == null) {
            return target == null;
        }
        return defaultTarget.equals(target);
    }

    public static boolean isLanguagePermutation(String external) {
        return external != null && external.contains(VARIATION_SEPARATOR) && external.charAt(0) >= 'a' && external.charAt(0) <= 'z';
    }

    public String toExternal(Permutation permutation) {
        if (permutation == null) {
            return null;
        }
        if (permutation.isLanguageSpecific()) {
            return this.toExternal(permutation.getParent(), permutation.getLocale());
        }
        if (permutation.isCountrySpecific()) {
            return this.toExternal(permutation.getParent(), permutation.getCountry());
        }
        Locale locale = permutation.getLocale();
        String target = permutation.getTarget();
        return this.toExternal(locale, target);
    }

    public String toExternal(Locale locale, String target) {
        StringBuffer buf = new StringBuffer();
        if (locale != null) {
            buf.append(locale);
        }
        if (locale != null && target != null && !this.isDefaultTarget(target)) {
            buf.append(TARGET_DELIMETER);
        }
        if (target != null && !this.isDefaultTarget(target)) {
            buf.append(target);
        }
        return buf.toString();
    }

    public String toExternal(Permutation parent, Locale language) {
        StringBuffer buf = new StringBuffer();
        buf.append(language).append(VARIATION_SEPARATOR).append(parent.toExternal());
        return buf.toString();
    }

    public String toExternal(Permutation parent, String country) {
        StringBuffer buf = new StringBuffer();
        buf.append(country).append(VARIATION_SEPARATOR).append(parent.toExternal());
        return buf.toString();
    }

    public Permutation fromExternal(String external) {
        return this.fromExternalWithDefault(external, false);
    }

    public Permutation fromExternalWithDefault(String external, boolean useDefaultTarget) {
        if (external == null || external.length() == 0) {
            return this.getDefaultPermutation();
        }
        if (external.contains(VARIATION_SEPARATOR)) {
            String[] tokens = external.split(VARIATION_SEPARATOR, 2);
            Permutation parent = this.fromExternalWithDefault(tokens[1], useDefaultTarget);
            if (tokens[0].length() == 2 && tokens[0].toUpperCase().equals(tokens[0])) {
                return this.extendByCountry(parent, tokens[0]);
            }
            Locale language = this.fromExternalLocale(tokens[0]);
            return this.extendByLanguage(parent, language);
        }
        String localeStr = external;
        String target = null;
        int targetIdx = external.lastIndexOf(TARGET_DELIMETER);
        if (targetIdx != -1) {
            target = external.substring(targetIdx + TARGET_DELIMETER.length());
            localeStr = external.substring(0, targetIdx);
        } else if (useDefaultTarget) {
            target = this.getDefaultTarget();
        }
        Locale locale = this.fromExternalLocale(localeStr);
        if (locale == null) {
            return null;
        }
        Permutation perm = this.lookupInternal(locale, null, target);
        if (perm == null) {
            perm = Permutation.create(locale, target);
        }
        return perm;
    }

    public Locale fromExternalLocale(String localeStr) {
        if (localeStr == null) {
            return null;
        }
        String lang = localeStr;
        String country = "";
        String var = "";
        int contryIdx = localeStr.indexOf("_");
        if (contryIdx != -1) {
            lang = localeStr.substring(0, contryIdx);
            country = localeStr.substring(contryIdx + 1);
            int varIdx = country.indexOf("_");
            if (varIdx != -1) {
                var = country.substring(varIdx + 1);
                country = country.substring(0, varIdx);
            }
        }
        boolean isLangValid = this.isValidLanguage(lang);
        boolean isCountryValid = false;
        if (country.length() == 0) {
            isCountryValid = true;
        } else {
            String[] stringArray = Locale.getISOCountries();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String validCn = stringArray[n2];
                if (validCn.equals(country)) {
                    isCountryValid = true;
                    break;
                }
                ++n2;
            }
        }
        if (!isLangValid || !isCountryValid) {
            return null;
        }
        Locale locale = new Locale(lang, country, var);
        return locale;
    }

    protected boolean isValidLanguage(String lang) {
        boolean isLangValid = false;
        String[] stringArray = Locale.getISOLanguages();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String validLang = stringArray[n2];
            if (validLang.equals(lang)) {
                isLangValid = true;
                break;
            }
            ++n2;
        }
        return isLangValid;
    }

    public List<String> getExternalsWithResolutionOrder(Permutation permutation) {
        if (permutation == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>(4);
        result.add(permutation.toExternal());
        Locale locale = permutation.getLocale();
        if (locale != null) {
            Locale localeWithCountry;
            Locale localeWithVar;
            String localeStr = locale.toString();
            if (!result.contains(localeStr)) {
                result.add(localeStr);
            }
            if (locale.getVariant() != null && locale.getVariant().length() != 0 && !result.contains(localeStr = (localeWithVar = new Locale(locale.getLanguage(), locale.getCountry())).toString())) {
                result.add(localeStr);
            }
            if (locale.getCountry() != null && locale.getCountry().length() != 0 && !result.contains(localeStr = (localeWithCountry = new Locale(locale.getLanguage())).toString())) {
                result.add(localeStr);
            }
        }
        result.add("");
        return result;
    }

    protected static Permutation[] listToArray(List<Permutation> list) {
        Permutation[] result = new Permutation[list.size()];
        list.toArray(result);
        return result;
    }

    public Locale[] getSupportedLanguages(Permutation permutation) {
        if (permutation.isCountrySpecific()) {
            permutation = permutation.getParent();
        }
        return new Locale[]{permutation.getLocale()};
    }

    public Permutation extendByLanguage(Permutation permutation, Locale language) {
        return this.extendByLanguage(permutation, language, permutation.getTarget());
    }

    protected Permutation extendByLanguage(Permutation permutation, Locale language, String target) {
        if (permutation.getLanguage().equals(language)) {
            return permutation;
        }
        if (permutation.isLanguageSpecific()) {
            throw new RuntimeException("Parent permutation cannot be of language Permutation type, permutation: " + permutation.toExternal());
        }
        return new Permutation(permutation, language, target);
    }

    public Permutation extendByCountry(Permutation parent, String country) {
        return this.extendByCountry(parent, country, parent.getTarget());
    }

    protected Permutation extendByCountry(Permutation parent, String country, String target) {
        if (parent.getCountry().equals(country)) {
            return parent;
        }
        if (parent.isExtended()) {
            throw new RuntimeException("Parent permutation is already extended permutation, parent: " + parent.toExternal() + ", country: " + country);
        }
        Permutation perm = this.lookupInternal(parent.getLanguage(), country, target);
        if (perm == null) {
            perm = Permutation.createCountryPermutation(parent, country, target);
        }
        return perm;
    }
}

