/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.resource.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.resource.permutation.Permutation;

public class ResourceHelper {
    public static String getStringContent(URL url) {
        InputStream inputStream;
        try {
            inputStream = url.openStream();
        }
        catch (IOException e) {
            throw new DsfRuntimeException(url.toExternalForm(), (Throwable)e);
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream(4096);
        byte[] buffer = new byte[4096];
        try {
            try {
                int numBytesXferred;
                while ((numBytesXferred = inputStream.read(buffer)) != -1) {
                    assert (numBytesXferred >= 0);
                    os.write(buffer, 0, numBytesXferred);
                }
            }
            finally {
                inputStream.close();
            }
            String scriptText = os.toString("utf-8");
            return scriptText;
        }
        catch (IOException e) {
            throw new DsfRuntimeException("can not load '" + url.toExternalForm() + "'", (Throwable)e);
        }
    }

    public static String getKeyUrn(Class anchorClass, String resourceName, Permutation permutation, String fileExtention) {
        String urn = String.valueOf(ResourceHelper.getPackagePart(anchorClass)) + "/" + ResourceHelper.getResourceName(resourceName, permutation, permutation.toExternal(), fileExtention);
        return urn;
    }

    public static String getResourceRefUrn(Class anchorClass, String resourceName) {
        String urn = String.valueOf(ResourceHelper.getPackagePart(anchorClass)) + "/" + resourceName;
        return urn;
    }

    public static String getResourceName(String resourceName, Permutation permutation, String permutationStr, String fileExtension) {
        if (permutationStr != null && permutationStr.length() != 0) {
            return String.valueOf(resourceName) + '_' + permutationStr + fileExtension;
        }
        return String.valueOf(resourceName) + fileExtension;
    }

    public static String getPackagePart(Class anchorClass) {
        String packagePart = anchorClass.getPackage().getName().replace('.', '/');
        return packagePart;
    }
}

