/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.serializer;

import org.eclipse.vjet.dsf.json.serializer.SerializationException;
import org.eclipse.vjet.dsf.logger.LogLevel;
import org.eclipse.vjet.dsf.logger.Logger;
import org.eclipse.vjet.dsf.serializer.VjoAbstractSerializer;
import org.eclipse.vjet.dsf.serializer.VjoArraySerializedResult;

public class VjoArraySerializer
extends VjoAbstractSerializer {
    private static Logger s_logger = Logger.getInstance(VjoArraySerializer.class);

    @Override
    public boolean canSerialize(Object obj) {
        Class<?> type = obj.getClass();
        return type.isArray();
    }

    @Override
    public Object doSerialize(Object obj) throws SerializationException {
        VjoArraySerializedResult vjoArray = new VjoArraySerializedResult();
        Class<?> componentType = obj.getClass().getComponentType();
        if (!componentType.isPrimitive()) {
            Object[] objectArray = (Object[])obj;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object elem = objectArray[n2];
                vjoArray.addVjoObject(this.getOwner().serialize(elem));
                ++n2;
            }
        } else if (Byte.TYPE.equals(componentType)) {
            byte[] byArray = (byte[])obj;
            int n = byArray.length;
            int n3 = 0;
            while (n3 < n) {
                Byte elem = byArray[n3];
                vjoArray.addVjoObject(this.getOwner().serialize((Object)elem));
                ++n3;
            }
        } else if (Character.TYPE.equals(componentType)) {
            char[] cArray = (char[])obj;
            int n = cArray.length;
            int n4 = 0;
            while (n4 < n) {
                Character elem = Character.valueOf(cArray[n4]);
                vjoArray.addVjoObject(this.getOwner().serialize((Object)elem));
                ++n4;
            }
        } else if (Boolean.TYPE.equals(componentType)) {
            boolean[] blArray = (boolean[])obj;
            int n = blArray.length;
            int n5 = 0;
            while (n5 < n) {
                Boolean elem = blArray[n5];
                vjoArray.addVjoObject(this.getOwner().serialize((Object)elem));
                ++n5;
            }
        } else if (Short.TYPE.equals(componentType)) {
            short[] sArray = (short[])obj;
            int n = sArray.length;
            int n6 = 0;
            while (n6 < n) {
                Short elem = sArray[n6];
                vjoArray.addVjoObject(this.getOwner().serialize((Object)elem));
                ++n6;
            }
        } else if (Integer.TYPE.equals(componentType)) {
            int[] nArray = (int[])obj;
            int n = nArray.length;
            int n7 = 0;
            while (n7 < n) {
                Integer elem = nArray[n7];
                vjoArray.addVjoObject(this.getOwner().serialize((Object)elem));
                ++n7;
            }
        } else if (Long.TYPE.equals(componentType)) {
            long[] lArray = (long[])obj;
            int n = lArray.length;
            int n8 = 0;
            while (n8 < n) {
                Long elem = lArray[n8];
                vjoArray.addVjoObject(this.getOwner().serialize((Object)elem));
                ++n8;
            }
        } else if (Float.TYPE.equals(componentType)) {
            float[] fArray = (float[])obj;
            int n = fArray.length;
            int n9 = 0;
            while (n9 < n) {
                Float elem = Float.valueOf(fArray[n9]);
                vjoArray.addVjoObject(this.getOwner().serialize((Object)elem));
                ++n9;
            }
        } else if (Double.TYPE.equals(componentType)) {
            double[] dArray = (double[])obj;
            int n = dArray.length;
            int n10 = 0;
            while (n10 < n) {
                Double elem = dArray[n10];
                vjoArray.addVjoObject(this.getOwner().serialize((Object)elem));
                ++n10;
            }
        } else {
            s_logger.log(LogLevel.ERROR, "unknown primitive array component type?");
        }
        return vjoArray;
    }

    @Override
    protected Object toCache(Object toSerialize, Object result) {
        return result;
    }

    @Override
    protected boolean canCache(Object toSerialize) {
        return false;
    }

    @Override
    protected Object restoreBrokenReference(Object toSerialize, Object result) {
        return result;
    }
}

