/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.window.utils;

import java.net.URL;
import org.eclipse.vjet.dsf.common.context.DsfCtx;
import org.eclipse.vjet.dsf.html.dom.BaseAttrsHtmlElement;
import org.eclipse.vjet.dsf.html.dom.DA;
import org.eclipse.vjet.dsf.html.events.EventType;
import org.eclipse.vjet.dsf.html.js.IJsFunc;
import org.eclipse.vjet.vsf.jsref.JsFunc;
import org.eclipse.vjet.vsf.window.utils.JsWindowFeatures;
import org.eclipse.vjet.vsf.window.utils.VjWindowJsr;

public class JsWindowHelper {
    private static final String RETURN_FALSE = "return false";
    private static final String _NEW = "_new";
    static final JsWindowFeatures DEFAULT_FEATURES = new JsWindowFeatures(600, 800);

    public static IJsFunc openWindow(URL url, String windowName, JsWindowFeatures features, boolean replace) {
        return VjWindowJsr.open(url.toString(), windowName, features.createJsWindowFeatures(), replace, features.getCenter(), features.getWidth(), features.getHeight());
    }

    public static IJsFunc openWindow(URL url, String windowName, JsWindowFeatures features) {
        return JsWindowHelper.openWindow(url, windowName, features, false);
    }

    public static IJsFunc openWindow(URL url) {
        return JsWindowHelper.openWindow(url, DsfCtx.ctx().ids().nextJsWindowId(), DEFAULT_FEATURES, false);
    }

    public static DA openWindowWithUrlReturnWindow(URL url, String windowName, JsWindowFeatures features, boolean replace, String linkText) {
        DA a = new DA();
        a.setHtmlHref(url.toString());
        a.setHtmlTarget(_NEW);
        a.add(EventType.CLICK, JsWindowHelper.openWindow(url, windowName, features, replace));
        a.setHtmlExtTextValue(linkText);
        return a;
    }

    public static DA openWindowWithUrl(URL url, String windowName, JsWindowFeatures features, boolean replace, String linkText) {
        DA a = new DA();
        a.setHtmlHref(url.toString());
        a.setHtmlTarget(_NEW);
        a.add(EventType.CLICK, JsWindowHelper.openWindow(url, windowName, features, replace));
        a.add(EventType.CLICK, RETURN_FALSE);
        a.setHtmlExtTextValue(linkText);
        return a;
    }

    public static DA openWindowWithUrl(URL url, JsWindowFeatures features, String linkText) {
        return JsWindowHelper.openWindowInternal(url, null, features, false, linkText);
    }

    private static DA openWindowInternal(URL url, String windowName, JsWindowFeatures features, boolean replace, String linkText) {
        String winName = windowName != null ? windowName : DsfCtx.ctx().ids().nextJsWindowId();
        DA a = new DA();
        a.setHtmlHref(url.toString());
        a.setHtmlTarget(_NEW);
        a.add(EventType.CLICK, JsWindowHelper.openWindow(url, winName, features, replace));
        a.add(EventType.CLICK, RETURN_FALSE);
        if (linkText != null) {
            a.setHtmlExtTextValue(linkText);
        }
        return a;
    }

    private static String getHandlerId() {
        return DsfCtx.ctx().ids().nextJsHandlerId();
    }

    public static DA openWindowWithUrl(URL url, JsWindowFeatures features) {
        return JsWindowHelper.openWindowInternal(url, null, features, false, null);
    }

    public static DA openWindowWithUrl(URL url, String linkText) {
        DA a = new DA();
        a.setHtmlHref(url.toString());
        a.add(EventType.CLICK, JsWindowHelper.openWindow(url));
        a.add(EventType.CLICK, RETURN_FALSE);
        a.setHtmlExtTextValue(linkText);
        return a;
    }

    public static void openWindowWithUrl(BaseAttrsHtmlElement elem, URL url, JsWindowFeatures features) {
        elem.add(EventType.CLICK, JsWindowHelper.openWindow(url, DsfCtx.ctx().ids().nextJsWindowId(), features));
        elem.add(EventType.CLICK, RETURN_FALSE);
    }

    public static void openWindowWithUrl(BaseAttrsHtmlElement elem, URL url) {
        elem.add(EventType.CLICK, JsWindowHelper.openWindow(url, DsfCtx.ctx().ids().nextJsWindowId(), DEFAULT_FEATURES));
        elem.add(EventType.CLICK, RETURN_FALSE);
    }

    public static JsFunc<Boolean> confirmDialog(String message) {
        return VjWindowJsr.confirm(message);
    }
}

