/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.css.dom.impl;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import org.eclipse.vjet.dsf.css.dom.impl.DCssException;
import org.eclipse.vjet.dsf.css.dom.impl.DCssRule;
import org.eclipse.vjet.dsf.css.parser.DCssBuilder;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSImportRule;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.stylesheets.MediaList;

public class DCssImportRule
extends DCssRule
implements CSSImportRule,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private String m_href = null;
    private MediaList m_media = null;

    public DCssImportRule(CSSStyleSheet parentStyleSheet, CSSRule parentRule, String href, MediaList media) {
        super(parentStyleSheet, parentRule);
        this.m_href = href;
        this.m_media = media;
    }

    @Override
    public short getType() {
        return 3;
    }

    @Override
    public String getCssText() {
        StringBuffer sb = new StringBuffer();
        sb.append("@import url(").append(this.getHref()).append(")");
        if (this.getMedia().getLength() > 0) {
            sb.append(" ").append(this.getMedia().toString());
        }
        sb.append(";");
        return sb.toString();
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        if (this.m_parentStyleSheet != null) {
            throw new DCssException(7, 2);
        }
        try {
            InputSource is = new InputSource((Reader)new StringReader(cssText));
            DCssBuilder parser = new DCssBuilder();
            CSSRule r = parser.parseRule(is);
            if (r.getType() != 3) {
                throw new DCssException(13, 6);
            }
            this.m_href = ((DCssImportRule)r).m_href;
            this.m_media = ((DCssImportRule)r).m_media;
        }
        catch (DCssException e) {
            throw new DCssException(12, 0, e.getMessage());
        }
        catch (IOException e) {
            throw new DCssException(12, 0, e.getMessage());
        }
    }

    @Override
    public CSSStyleSheet getParentStyleSheet() {
        return this.m_parentStyleSheet;
    }

    @Override
    public CSSRule getParentRule() {
        return this.m_parentRule;
    }

    @Override
    public String getHref() {
        return this.m_href;
    }

    @Override
    public MediaList getMedia() {
        return this.m_media;
    }

    @Override
    public CSSStyleSheet getStyleSheet() {
        return null;
    }

    public String toString() {
        return this.getCssText();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

