/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dom;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.vjet.dsf.common.FileUtils;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.dom.DDOMBuilder;
import org.eclipse.vjet.dsf.dom.DDOMImplementationRegistry;
import org.eclipse.vjet.dsf.dom.DDocument;
import org.eclipse.vjet.dsf.dom.DDomBuilder_DefaultHandler;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DDocumentBuilder
extends DocumentBuilder {
    public static DDocument getDocument(String xml) {
        return DDocumentBuilder.getDocument(new StringBufferInputStream(xml));
    }

    public static DDocument getDocument(Class<?> anchor, String resourceXml) {
        return DDocumentBuilder.getDocument(FileUtils.getResourceString(anchor, (String)resourceXml));
    }

    public static DDocument getDocument(InputStream inputStream) {
        DDocumentBuilder builder = new DDocumentBuilder();
        try {
            return (DDocument)builder.parse(inputStream);
        }
        catch (Exception e) {
            throw new DsfRuntimeException((Throwable)e);
        }
    }

    @Override
    public DOMImplementation getDOMImplementation() {
        DDOMImplementationRegistry reg = DDOMImplementationRegistry.newInstance();
        DOMImplementation impl = reg.getDOMImplementation("xml");
        return impl;
    }

    @Override
    public Document newDocument() {
        return new DDocument();
    }

    @Override
    public Document parse(InputSource is) throws SAXException, IOException {
        try {
            DDOMBuilder ddomBuilder = new DDOMBuilder();
            DDomBuilder_DefaultHandler builder = new DDomBuilder_DefaultHandler(ddomBuilder);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            parser.parse(is, (DefaultHandler)builder);
            return ddomBuilder.getDDocument();
        }
        catch (Exception e) {
            throw new DsfRuntimeException((Throwable)e);
        }
    }

    @Override
    public boolean isNamespaceAware() {
        return true;
    }

    @Override
    public boolean isValidating() {
        return false;
    }

    @Override
    public void setEntityResolver(EntityResolver er) {
    }

    @Override
    public void setErrorHandler(ErrorHandler eh) {
    }
}

