/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.core.impl;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dali.core.DaliPackage;
import org.eclipse.dali.core.PersistenceContainer;
import org.eclipse.dali.core.PersistenceFile;
import org.eclipse.dali.core.PersistenceProject;
import org.eclipse.dali.core.impl.PersistenceBuilder;
import org.eclipse.dali.core.impl.PersistenceContainerImpl;
import org.eclipse.dali.core.impl.PersistenceModelManager;
import org.eclipse.dali.db.PersistenceDbPlugin;
import org.eclipse.dali.db.wrappers.ConnectionInfoWrapper;
import org.eclipse.dali.db.wrappers.SchemaWrapper;
import org.eclipse.dali.internal.utility.iterators.FilteringIterator;
import org.eclipse.dali.internal.utility.iterators.NullIterator;
import org.eclipse.dali.internal.utility.iterators.TreeIterator;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class PersistenceProjectImpl
extends PersistenceContainerImpl
implements PersistenceProject {
    public static String CONNECTION_INFO_PROPERTY = "connectionInfoProperty";
    public static String SCHEMA_PROPERTY = "schemaProperty";
    private IJavaProject javaProject;
    boolean constructed = false;

    public static void addNatureToProject(IJavaProject javaProject) throws CoreException {
        if (!javaProject.getProject().isOpen()) {
            return;
        }
        if (PersistenceProjectImpl.containsNature(javaProject)) {
            return;
        }
        IProject project = javaProject.getProject();
        IProjectDescription description = project.getDescription();
        String[] oldNatureIds = description.getNatureIds();
        String[] newNatureIds = new String[oldNatureIds.length + 1];
        System.arraycopy(oldNatureIds, 0, newNatureIds, 0, oldNatureIds.length);
        newNatureIds[oldNatureIds.length] = "org.eclipse.dali.core.persistenceNature";
        description.setNatureIds(newNatureIds);
        project.setDescription(description, null);
    }

    public static void addNatureToProject(IJavaProject javaProject, String connectionInfoName, String schemaName) throws CoreException {
        PersistenceProjectImpl.addNatureToProject(javaProject);
        PersistenceProjectImpl.setConnectionInfoAndSchemaNameForWizard(javaProject.getProject(), connectionInfoName, schemaName);
    }

    public static boolean containsNature(IJavaProject javaProject) {
        IProjectNature nature;
        try {
            nature = javaProject.getProject().getNature("org.eclipse.dali.core.persistenceNature");
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        return nature != null;
    }

    public static PersistenceProjectImpl getPersistenceProject(IProject project) {
        try {
            PersistenceProjectImpl nature = (PersistenceProjectImpl)project.getNature("org.eclipse.dali.core.persistenceNature");
            return nature;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public PersistenceProjectImpl() {
        super(null);
    }

    protected EClass eStaticClass() {
        return DaliPackage.eINSTANCE.getPersistenceProject();
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 0: {
                    return ((InternalEList)this.getPersistenceResources()).basicRemove((Object)otherEnd, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getPersistenceResources();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.getPersistenceResources().clear();
                this.getPersistenceResources().addAll((Collection)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.getPersistenceResources().clear();
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.persistenceResources != null && !this.persistenceResources.isEmpty();
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public void configure() throws CoreException {
        PersistenceBuilder.addBuilderToProject(this.getProject());
    }

    public void deconfigure() throws CoreException {
        PersistenceBuilder.removeBuilderFromProject(this.getProject());
        PersistenceBuilder.deleteAuditMarkers(this.getProject());
    }

    public IProject getProject() {
        return (IProject)this.resource;
    }

    public void setProject(IProject project) {
        this.resource = project;
        this.javaProject = JavaCore.create((IProject)project);
        PersistenceModelManager.getPersistenceModelManager().getPersistenceModel().getProjects().add((Object)this);
        Job buildInternalResourcesJob = new Job("reLoadActiveProject"){

            protected IStatus run(IProgressMonitor monitor) {
                PersistenceProjectImpl.this.buildInternalResources();
                PersistenceProjectImpl.this.setConstructed(true);
                return new Status(0, "org.eclipse.dali.core", 0, "", null);
            }
        };
        buildInternalResourcesJob.schedule();
    }

    synchronized void setConstructed(boolean constructed) {
        this.constructed = constructed;
    }

    public synchronized boolean isConstructed() {
        return this.constructed;
    }

    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    public Iterator persistenceFiles() {
        return new FilteringIterator((Iterator)new TreeIterator((Object)this, new TreeIterator.Midwife(){

            public Iterator children(Object next) {
                if (next instanceof PersistenceContainer) {
                    return ((PersistenceContainer)next).getPersistenceResources().iterator();
                }
                return NullIterator.instance();
            }
        })){

            protected boolean accept(Object o) {
                return o instanceof PersistenceFile;
            }
        };
    }

    public ConnectionInfoWrapper getConnectionInfo() {
        try {
            String connectionInfoName = this.getProject().getPersistentProperty(new QualifiedName("org.eclipse.dali.core", CONNECTION_INFO_PROPERTY));
            return PersistenceDbPlugin.getDefault().getConnectionRepository().getConnectionInfoNamed(connectionInfoName);
        }
        catch (CoreException e) {
            System.out.println("No data for project: " + this.getProject().toString());
            throw new RuntimeException(e.getMessage());
        }
    }

    public SchemaWrapper getSchema() {
        try {
            String schemaName = this.getProject().getPersistentProperty(new QualifiedName("org.eclipse.dali.core", SCHEMA_PROPERTY));
            return this.getConnectionInfo().getSchemaNamed(schemaName);
        }
        catch (CoreException e) {
            System.out.println("No data for project: " + this.getProject().toString());
            throw new RuntimeException(e.getMessage());
        }
    }

    public String getSchemaName() {
        SchemaWrapper schema = this.getSchema();
        return schema == null ? null : schema.getName();
    }

    public static void setConnectionInfoAndSchemaNameForWizard(IProject project, String connectionInfoName, String schemaName) {
        try {
            project.setPersistentProperty(new QualifiedName("org.eclipse.dali.core", CONNECTION_INFO_PROPERTY), connectionInfoName);
            project.setPersistentProperty(new QualifiedName("org.eclipse.dali.core", SCHEMA_PROPERTY), schemaName);
        }
        catch (CoreException e) {
            System.out.println("No such Project");
            throw new RuntimeException(e.getMessage());
        }
    }

    public void setConnectionInfoName(String connectionInfoName) {
        try {
            this.getProject().setPersistentProperty(new QualifiedName("org.eclipse.dali.core", CONNECTION_INFO_PROPERTY), connectionInfoName);
        }
        catch (CoreException e) {
            System.out.println("No such Project");
            throw new RuntimeException(e.getMessage());
        }
    }

    public void setSchemaName(String schemaName) {
        try {
            this.getProject().setPersistentProperty(new QualifiedName("org.eclipse.dali.core", SCHEMA_PROPERTY), schemaName);
        }
        catch (CoreException e) {
            System.out.println("No such Project");
            throw new RuntimeException(e.getMessage());
        }
    }
}

