/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.internal.utility;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.dali.internal.utility.Bag;
import org.eclipse.dali.internal.utility.HashBag;
import org.eclipse.dali.internal.utility.iterators.ArrayIterator;
import org.eclipse.dali.internal.utility.iterators.SingleElementIterator;

public final class CollectionTools {
    private static final Random RANDOM = new Random();

    public static Object[] add(Object[] array, Object o) {
        int len = array.length;
        Object[] result = new Object[len + 1];
        System.arraycopy(array, 0, result, 0, len);
        result[len] = o;
        return result;
    }

    public static Object[] add(Object[] array, int index, Object o) {
        int len = array.length;
        Object[] result = new Object[len + 1];
        System.arraycopy(array, 0, result, 0, index);
        result[index] = o;
        System.arraycopy(array, index, result, index + 1, len - index);
        return result;
    }

    public static char[] add(char[] array, char value) {
        int len = array.length;
        char[] result = new char[len + 1];
        System.arraycopy(array, 0, result, 0, len);
        result[len] = value;
        return result;
    }

    public static char[] add(char[] array, int index, char value) {
        int len = array.length;
        char[] result = new char[len + 1];
        System.arraycopy(array, 0, result, 0, index);
        result[index] = value;
        System.arraycopy(array, index, result, index + 1, len - index);
        return result;
    }

    public static int[] add(int[] array, int value) {
        int len = array.length;
        int[] result = new int[len + 1];
        System.arraycopy(array, 0, result, 0, len);
        result[len] = value;
        return result;
    }

    public static int[] add(int[] array, int index, int value) {
        int len = array.length;
        int[] result = new int[len + 1];
        System.arraycopy(array, 0, result, 0, index);
        result[index] = value;
        System.arraycopy(array, index, result, index + 1, len - index);
        return result;
    }

    public static boolean addAll(Collection collection, Iterator iterator) {
        boolean modified = false;
        while (iterator.hasNext()) {
            modified |= collection.add(iterator.next());
        }
        return modified;
    }

    public static boolean addAll(Collection collection, Object[] array) {
        boolean modified = false;
        int len = array.length;
        int i = 0;
        while (i < len) {
            modified |= collection.add(array[i]);
            ++i;
        }
        return modified;
    }

    public static Object[] addAll(Object[] array, Collection c) {
        int len = array.length;
        Object[] result = new Object[array.length + c.size()];
        System.arraycopy(array, 0, result, 0, len);
        int i = len;
        Iterator stream = c.iterator();
        while (stream.hasNext()) {
            result[i] = stream.next();
            ++i;
        }
        return result;
    }

    public static Object[] addAll(Object[] array, Iterator iterator) {
        return CollectionTools.addAll(array, CollectionTools.list(iterator));
    }

    public static Object[] addAll(Object[] array1, Object[] array2) {
        int len1 = array1.length;
        int len2 = array2.length;
        Object[] result = new Object[len1 + len2];
        System.arraycopy(array1, 0, result, 0, len1);
        System.arraycopy(array2, 0, result, len1, len2);
        return result;
    }

    public static Object[] addAll(Object[] array1, int index, Object[] array2) {
        int len1 = array1.length;
        int len2 = array2.length;
        Object[] result = new Object[len1 + len2];
        System.arraycopy(array1, 0, result, 0, index);
        System.arraycopy(array2, 0, result, index, len2);
        System.arraycopy(array1, index, result, index + len2, len1 - index);
        return result;
    }

    public static char[] addAll(char[] array1, char[] array2) {
        int len1 = array1.length;
        int len2 = array2.length;
        char[] result = new char[len1 + len2];
        System.arraycopy(array1, 0, result, 0, len1);
        System.arraycopy(array2, 0, result, len1, len2);
        return result;
    }

    public static char[] addAll(char[] array1, int index, char[] array2) {
        int len1 = array1.length;
        int len2 = array2.length;
        char[] result = new char[len1 + len2];
        System.arraycopy(array1, 0, result, 0, index);
        System.arraycopy(array2, 0, result, index, len2);
        System.arraycopy(array1, index, result, index + len2, len1 - index);
        return result;
    }

    public static int[] addAll(int[] array1, int[] array2) {
        int len1 = array1.length;
        int len2 = array2.length;
        int[] result = new int[len1 + len2];
        System.arraycopy(array1, 0, result, 0, len1);
        System.arraycopy(array2, 0, result, len1, len2);
        return result;
    }

    public static int[] addAll(int[] array1, int index, int[] array2) {
        int len1 = array1.length;
        int len2 = array2.length;
        int[] result = new int[len1 + len2];
        System.arraycopy(array1, 0, result, 0, index);
        System.arraycopy(array2, 0, result, index, len2);
        System.arraycopy(array1, index, result, index + len2, len1 - index);
        return result;
    }

    public static Object[] array(Iterator iterator) {
        return CollectionTools.list(iterator).toArray();
    }

    public static Object[] array(Iterator iterator, Object[] array) {
        return CollectionTools.list(iterator).toArray(array);
    }

    public static Bag bag(Enumeration enumeration) {
        HashBag bag = new HashBag();
        while (enumeration.hasMoreElements()) {
            bag.add(enumeration.nextElement());
        }
        return bag;
    }

    public static Bag bag(Iterator iterator) {
        HashBag bag = new HashBag();
        while (iterator.hasNext()) {
            bag.add(iterator.next());
        }
        return bag;
    }

    public static Bag bag(Object[] array) {
        int len = array.length;
        HashBag bag = new HashBag(len);
        int i = 0;
        while (i < len) {
            bag.add(array[i]);
            ++i;
        }
        return bag;
    }

    public static Collection collection(Enumeration enumeration) {
        return CollectionTools.bag(enumeration);
    }

    public static Collection collection(Iterator iterator) {
        return CollectionTools.bag(iterator);
    }

    public static Collection collection(Object[] array) {
        return CollectionTools.bag(array);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean contains(Enumeration enumeration, Object o) {
        block2: {
            if (o != null) ** GOTO lbl8
            while (enumeration.hasMoreElements()) {
                if (enumeration.nextElement() != null) continue;
                return true;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                if (!o.equals(enumeration.nextElement())) continue;
                return true;
lbl8:
                // 2 sources

                ** while (enumeration.hasMoreElements())
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean contains(Iterator iterator, Object o) {
        block2: {
            if (o != null) ** GOTO lbl8
            while (iterator.hasNext()) {
                if (iterator.next() != null) continue;
                return true;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                if (!o.equals(iterator.next())) continue;
                return true;
lbl8:
                // 2 sources

                ** while (iterator.hasNext())
            }
        }
        return false;
    }

    public static boolean contains(Object[] array, Object o) {
        int len = array.length;
        if (o == null) {
            int i = 0;
            while (i < len) {
                if (array[i] == null) {
                    return true;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < len) {
                if (o.equals(array[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static boolean contains(char[] array, char value) {
        int len = array.length;
        int i = 0;
        while (i < len) {
            if (array[i] == value) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean contains(int[] array, int value) {
        int len = array.length;
        int i = 0;
        while (i < len) {
            if (array[i] == value) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean containsAll(Collection collection, Iterator iterator) {
        while (iterator.hasNext()) {
            if (collection.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(Collection collection, Object[] array) {
        int len = array.length;
        int i = 0;
        while (i < len) {
            if (!collection.contains(array[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean containsAll(Iterator iterator, Collection collection) {
        return CollectionTools.collection(iterator).containsAll(collection);
    }

    public static boolean containsAll(Iterator iterator1, Iterator iterator2) {
        return CollectionTools.containsAll(CollectionTools.collection(iterator1), iterator2);
    }

    public static boolean containsAll(Iterator iterator, Object[] array) {
        return CollectionTools.containsAll(CollectionTools.collection(iterator), array);
    }

    public static boolean containsAll(Object[] array, Collection collection) {
        return CollectionTools.containsAll(array, collection.iterator());
    }

    public static boolean containsAll(Object[] array, Iterator iterator) {
        while (iterator.hasNext()) {
            if (CollectionTools.contains(array, iterator.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(Object[] array1, Object[] array2) {
        int len2 = array2.length;
        int i = 0;
        while (i < len2) {
            if (!CollectionTools.contains(array1, array2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean containsAll(char[] array1, char[] array2) {
        int len2 = array2.length;
        int i = 0;
        while (i < len2) {
            if (!CollectionTools.contains(array1, array2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean containsAll(int[] array1, int[] array2) {
        int len2 = array2.length;
        int i = 0;
        while (i < len2) {
            if (!CollectionTools.contains(array1, array2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equals(ListIterator iterator1, ListIterator iterator2) {
        while (iterator1.hasNext() && iterator2.hasNext()) {
            Object o1 = iterator1.next();
            Object o2 = iterator2.next();
            if (!(o1 == null ? o2 != null : !o1.equals(o2))) continue;
            return false;
        }
        return !iterator1.hasNext() && !iterator2.hasNext();
    }

    public static Object get(ListIterator iterator, int index) {
        while (iterator.hasNext()) {
            Object next = iterator.next();
            if (iterator.previousIndex() != index) continue;
            return next;
        }
        throw new IndexOutOfBoundsException(String.valueOf(String.valueOf(index)) + ':' + String.valueOf(iterator.previousIndex()));
    }

    public static boolean identical(Object[] array1, Object[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null) {
            return false;
        }
        int length = array1.length;
        if (array2.length != length) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (array1[i] != array2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean identical(ListIterator iterator1, ListIterator iterator2) {
        while (iterator1.hasNext() && iterator2.hasNext()) {
            if (iterator1.next() == iterator2.next()) continue;
            return false;
        }
        return !iterator1.hasNext() && !iterator2.hasNext();
    }

    public static int indexOf(ListIterator iterator, Object o) {
        if (o == null) {
            int i = 0;
            while (iterator.hasNext()) {
                if (iterator.next() == null) {
                    return i;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (iterator.hasNext()) {
                if (o.equals(iterator.next())) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public static int indexOf(Object[] array, Object o) {
        int len = array.length;
        if (o == null) {
            int i = 0;
            while (i < len) {
                if (array[i] == null) {
                    return i;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < len) {
                if (o.equals(array[i])) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public static int indexOf(char[] array, char value) {
        int len = array.length;
        int i = 0;
        while (i < len) {
            if (array[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(int[] array, int value) {
        int len = array.length;
        int i = 0;
        while (i < len) {
            if (array[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int insertionIndexOf(List sortedList, Comparable o) {
        int len = sortedList.size();
        int i = 0;
        while (i < len) {
            if (o.compareTo(sortedList.get(i)) < 0) {
                return i;
            }
            ++i;
        }
        return len;
    }

    public static int insertionIndexOf(Object[] sortedArray, Comparable o) {
        int len = sortedArray.length;
        int i = 0;
        while (i < len) {
            if (o.compareTo(sortedArray[i]) < 0) {
                return i;
            }
            ++i;
        }
        return len;
    }

    public static int insertionIndexOf(Object[] sortedArray, Object o, Comparator c) {
        int len = sortedArray.length;
        int i = 0;
        while (i < len) {
            if (c.compare(o, sortedArray[i]) < 0) {
                return i;
            }
            ++i;
        }
        return len;
    }

    public static Iterator iterator(Object[] array) {
        return new ArrayIterator(array);
    }

    public static int lastIndexOf(ListIterator iterator, Object o) {
        return CollectionTools.list(iterator).lastIndexOf(o);
    }

    public static int lastIndexOf(Object[] array, Object o) {
        int len = array.length;
        if (o == null) {
            int i = len;
            while (i-- > 0) {
                if (array[i] != null) continue;
                return i;
            }
        } else {
            int i = len;
            while (i-- > 0) {
                if (!o.equals(array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(char[] array, char value) {
        int i = array.length;
        while (i-- > 0) {
            if (array[i] != value) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(int[] array, int value) {
        int i = array.length;
        while (i-- > 0) {
            if (array[i] != value) continue;
            return i;
        }
        return -1;
    }

    public static List list(Iterator iterator) {
        ArrayList list = new ArrayList();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    public static List list(Object[] array) {
        int len = array.length;
        ArrayList<Object> list = new ArrayList<Object>(len);
        int i = 0;
        while (i < len) {
            list.add(array[i]);
            ++i;
        }
        return list;
    }

    public static ListIterator listIterator(Object[] array) {
        return CollectionTools.listIterator(array, 0);
    }

    public static ListIterator listIterator(Object[] array, int index) {
        return Arrays.asList(array).listIterator(index);
    }

    public static char max(char[] array) {
        int len = array.length;
        if (len == 0) {
            throw new IndexOutOfBoundsException();
        }
        char candidate = array[0];
        int i = 1;
        while (i < len) {
            char next = array[i];
            if (next > candidate) {
                candidate = next;
            }
            ++i;
        }
        return candidate;
    }

    public static int max(int[] array) {
        int len = array.length;
        if (len == 0) {
            throw new IndexOutOfBoundsException();
        }
        int candidate = array[0];
        int i = 1;
        while (i < len) {
            int next = array[i];
            if (next > candidate) {
                candidate = next;
            }
            ++i;
        }
        return candidate;
    }

    public static char min(char[] array) {
        int len = array.length;
        if (len == 0) {
            throw new IndexOutOfBoundsException();
        }
        char candidate = array[0];
        int i = 1;
        while (i < len) {
            char next = array[i];
            if (next < candidate) {
                candidate = next;
            }
            ++i;
        }
        return candidate;
    }

    public static int min(int[] array) {
        int len = array.length;
        if (len == 0) {
            throw new IndexOutOfBoundsException();
        }
        int candidate = array[0];
        int i = 1;
        while (i < len) {
            int next = array[i];
            if (next < candidate) {
                candidate = next;
            }
            ++i;
        }
        return candidate;
    }

    public static Object[] replaceAll(Object[] array, Object oldValue, Object newValue) {
        int len = array.length;
        if (oldValue == null) {
            int i = 0;
            while (i < len) {
                if (array[i] == null) {
                    array[i] = newValue;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < len) {
                if (oldValue.equals(array[i])) {
                    array[i] = newValue;
                }
                ++i;
            }
        }
        return array;
    }

    public static int[] replaceAll(int[] array, int oldValue, int newValue) {
        int len = array.length;
        int i = 0;
        while (i < len) {
            if (array[i] == oldValue) {
                array[i] = newValue;
            }
            ++i;
        }
        return array;
    }

    public static char[] replaceAll(char[] array, char oldValue, char newValue) {
        int len = array.length;
        int i = 0;
        while (i < len) {
            if (array[i] == oldValue) {
                array[i] = newValue;
            }
            ++i;
        }
        return array;
    }

    public static Object[] remove(Object[] array, Object value) {
        int index = CollectionTools.indexOf(array, value);
        int len = array.length;
        Object[] result = new Object[len - 1];
        System.arraycopy(array, 0, result, 0, index);
        System.arraycopy(array, index + 1, result, index, len - index - 1);
        return result;
    }

    public static char[] remove(char[] array, char value) {
        int index = CollectionTools.indexOf(array, value);
        int len = array.length;
        char[] result = new char[len - 1];
        System.arraycopy(array, 0, result, 0, index);
        System.arraycopy(array, index + 1, result, index, len - index - 1);
        return result;
    }

    public static int[] remove(int[] array, int value) {
        int index = CollectionTools.indexOf(array, value);
        int len = array.length;
        int[] result = new int[len - 1];
        System.arraycopy(array, 0, result, 0, index);
        System.arraycopy(array, index + 1, result, index, len - index - 1);
        return result;
    }

    public static boolean removeAll(Collection collection, Iterator iterator) {
        boolean modified = false;
        while (iterator.hasNext()) {
            modified |= collection.remove(iterator.next());
        }
        return modified;
    }

    public static boolean removeAll(Collection collection, Object[] array) {
        boolean modified = false;
        int len = array.length;
        int i = 0;
        while (i < len) {
            modified |= collection.remove(array[i]);
            ++i;
        }
        return modified;
    }

    public static Object[] removeAll(Object[] array, Collection collection) {
        Object[] result = array;
        int len = array.length;
        int i = 0;
        while (i < len) {
            Object item = array[i];
            if (collection.contains(item)) {
                result = CollectionTools.remove(result, item);
            }
            ++i;
        }
        return result;
    }

    public static Object[] removeAll(Object[] array1, Object[] array2) {
        return CollectionTools.removeAll(array1, CollectionTools.bag(array2));
    }

    public static char[] removeAll(char[] array1, char[] array2) {
        char[] result = array1;
        int len = array1.length;
        int i = 0;
        while (i < len) {
            char item = array1[i];
            if (CollectionTools.contains(array2, item)) {
                result = CollectionTools.remove(result, item);
            }
            ++i;
        }
        return result;
    }

    public static int[] removeAll(int[] array1, int[] array2) {
        int[] result = array1;
        int len = array1.length;
        int i = 0;
        while (i < len) {
            int item = array1[i];
            if (CollectionTools.contains(array2, item)) {
                result = CollectionTools.remove(result, item);
            }
            ++i;
        }
        return result;
    }

    public static Set set(Iterator iterator) {
        HashSet set = new HashSet();
        while (iterator.hasNext()) {
            set.add(iterator.next());
        }
        return set;
    }

    public static Set set(Object[] array) {
        int len = array.length;
        HashSet<Object> set = new HashSet<Object>(2 * len);
        int i = 0;
        while (i < len) {
            set.add(array[i]);
            ++i;
        }
        return set;
    }

    public static Iterator singletonIterator(Object o) {
        return new SingleElementIterator(o);
    }

    public static int size(Iterator iterator) {
        int size = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++size;
        }
        return size;
    }

    public static SortedSet sortedSet(Iterator iterator) {
        return CollectionTools.sortedSet(iterator, null);
    }

    public static SortedSet sortedSet(Iterator iterator, Comparator c) {
        TreeSet sortedSet = new TreeSet(c);
        sortedSet.addAll(CollectionTools.list(iterator));
        return sortedSet;
    }

    public static SortedSet sortedSet(Object[] array) {
        return CollectionTools.sortedSet(array, null);
    }

    public static SortedSet sortedSet(Object[] array, Comparator c) {
        TreeSet sortedSet = new TreeSet(c);
        sortedSet.addAll(Arrays.asList(array));
        return sortedSet;
    }

    public static Vector vector(Iterator iterator) {
        Vector v = new Vector();
        while (iterator.hasNext()) {
            v.addElement(iterator.next());
        }
        return v;
    }

    public static Vector vector(Object[] array) {
        int len = array.length;
        Vector<Object> v = new Vector<Object>(len);
        int i = 0;
        while (i < len) {
            v.addElement(array[i]);
            ++i;
        }
        return v;
    }

    public static List copy(List dest, List src) {
        Collections.copy(dest, src);
        return dest;
    }

    public static List fill(List list, Object o) {
        Collections.fill(list, o);
        return list;
    }

    public static List sort(List list) {
        Collections.sort(list);
        return list;
    }

    public static List sort(List list, Comparator c) {
        Collections.sort(list, c);
        return list;
    }

    public static byte[] sort(byte[] a) {
        Arrays.sort(a);
        return a;
    }

    public static byte[] sort(byte[] a, int fromIndex, int toIndex) {
        Arrays.sort(a, fromIndex, toIndex);
        return a;
    }

    public static char[] sort(char[] a) {
        Arrays.sort(a);
        return a;
    }

    public static char[] sort(char[] a, int fromIndex, int toIndex) {
        Arrays.sort(a, fromIndex, toIndex);
        return a;
    }

    public static double[] sort(double[] a) {
        Arrays.sort(a);
        return a;
    }

    public static double[] sort(double[] a, int fromIndex, int toIndex) {
        Arrays.sort(a, fromIndex, toIndex);
        return a;
    }

    public static float[] sort(float[] a) {
        Arrays.sort(a);
        return a;
    }

    public static float[] sort(float[] a, int fromIndex, int toIndex) {
        Arrays.sort(a, fromIndex, toIndex);
        return a;
    }

    public static int[] sort(int[] a) {
        Arrays.sort(a);
        return a;
    }

    public static int[] sort(int[] a, int fromIndex, int toIndex) {
        Arrays.sort(a, fromIndex, toIndex);
        return a;
    }

    public static Object[] sort(Object[] a) {
        Arrays.sort(a);
        return a;
    }

    public static Object[] sort(Object[] a, Comparator c) {
        Arrays.sort(a, c);
        return a;
    }

    public static Object[] sort(Object[] a, int fromIndex, int toIndex) {
        Arrays.sort(a, fromIndex, toIndex);
        return a;
    }

    public static Object[] sort(Object[] a, int fromIndex, int toIndex, Comparator c) {
        Arrays.sort(a, fromIndex, toIndex, c);
        return a;
    }

    public static long[] sort(long[] a) {
        Arrays.sort(a);
        return a;
    }

    public static long[] sort(long[] a, int fromIndex, int toIndex) {
        Arrays.sort(a, fromIndex, toIndex);
        return a;
    }

    public static short[] sort(short[] a) {
        Arrays.sort(a);
        return a;
    }

    public static short[] sort(short[] a, int fromIndex, int toIndex) {
        Arrays.sort(a, fromIndex, toIndex);
        return a;
    }

    private CollectionTools() {
        throw new UnsupportedOperationException();
    }
}

