/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.db.ddl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dali.db.Connection;
import org.eclipse.dali.db.ddl.RdbUtils;
import org.eclipse.dali.db.ddl.TableComparator;
import org.eclipse.dali.internal.utility.JDBCTools;
import org.eclipse.dali.orm.AttributeMapping;
import org.eclipse.dali.orm.ColumnHolder;
import org.eclipse.dali.orm.IdMapping;
import org.eclipse.dali.orm.JoinColumn;
import org.eclipse.dali.orm.JoinTable;
import org.eclipse.dali.orm.ManyToManyMapping;
import org.eclipse.dali.orm.MultiRelationshipMapping;
import org.eclipse.dali.orm.OneToManyMapping;
import org.eclipse.dali.orm.PersistenceContainer;
import org.eclipse.dali.orm.PersistenceFile;
import org.eclipse.dali.orm.PersistenceProject;
import org.eclipse.dali.orm.PersistenceResource;
import org.eclipse.dali.orm.PersistentAttribute;
import org.eclipse.dali.orm.PersistentType;
import org.eclipse.dali.orm.RelationshipMapping;
import org.eclipse.dali.orm.SingleRelationshipMapping;
import org.eclipse.dali.orm.Table;
import org.eclipse.dali.orm.TypeMapping;
import org.eclipse.dali.orm.adapters.IPersistenceModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaPersistentAttributeModelAdapter;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.rdb.fe.internal.ui.wizards.FEWizard;
import org.eclipse.wst.rdb.internal.core.definition.DataModelElementFactory;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinition;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinitionRegistry;
import org.eclipse.wst.rdb.internal.models.dbdefinition.PredefinedDataTypeDefinition;
import org.eclipse.wst.rdb.internal.models.sql.constraints.PrimaryKey;
import org.eclipse.wst.rdb.internal.models.sql.constraints.SQLConstraintsPackage;
import org.eclipse.wst.rdb.internal.models.sql.datatypes.DataType;
import org.eclipse.wst.rdb.internal.models.sql.datatypes.PredefinedDataType;
import org.eclipse.wst.rdb.internal.models.sql.datatypes.SQLDataType;
import org.eclipse.wst.rdb.internal.models.sql.expressions.ValueExpression;
import org.eclipse.wst.rdb.internal.models.sql.expressions.ValueExpressionDefault;
import org.eclipse.wst.rdb.internal.models.sql.expressions.impl.SQLExpressionsFactoryImpl;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLSchemaFactory;
import org.eclipse.wst.rdb.internal.models.sql.schema.Schema;
import org.eclipse.wst.rdb.internal.models.sql.tables.BaseTable;
import org.eclipse.wst.rdb.internal.models.sql.tables.Column;
import org.eclipse.wst.rdb.internal.models.sql.tables.PersistentTable;
import org.eclipse.wst.rdb.internal.models.sql.tables.SQLTablesFactory;

public class OrmDdlGenerator {
    private Database database;
    private TableComparator tableComparator = new TableComparator();
    private DatabaseDefinition dbDef;

    private OrmDdlGenerator(String product, String version) {
        product = RdbUtils.getDatabaseName(product);
        version = RdbUtils.getDatabaseVersion(product, version);
        DatabaseDefinitionRegistry ddr = RdbUtils.getDatabaseDefinitionRegistry();
        this.dbDef = ddr.getDefinition(product, version);
        this.database = SQLSchemaFactory.eINSTANCE.createDatabase();
        this.database.setVendor(this.dbDef.getProduct());
        this.database.setVersion(this.dbDef.getVersion());
        Schema defaultSchema = SQLSchemaFactory.eINSTANCE.createSchema();
        this.database.getSchemas().add((Object)defaultSchema);
    }

    private void createDDL() {
        ArrayList tables = new ArrayList(100);
        Iterator it = this.database.getSchemas().iterator();
        while (it.hasNext()) {
            Schema schema = (Schema)it.next();
            tables.addAll(schema.getTables());
        }
        Collections.sort(tables, this.tableComparator);
        FEWizard wizard = new FEWizard(tables);
        WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
        dialog.create();
        dialog.open();
    }

    private BaseTable getTable(String catalogName, String schemaName, String tableName) {
        if (tableName == null) {
            return null;
        }
        return this.getTable(schemaName, tableName);
    }

    private Schema getSchema(String schemaName) {
        if (schemaName == null) {
            schemaName = "";
        }
        schemaName = schemaName.trim();
        Iterator it = this.database.getSchemas().iterator();
        while (it.hasNext()) {
            Schema schema = (Schema)it.next();
            String name = schema.getName();
            if (name == null || !name.equalsIgnoreCase(schemaName)) continue;
            return schema;
        }
        Schema schema = SQLSchemaFactory.eINSTANCE.createSchema();
        schema.setName(schemaName);
        this.database.getSchemas().add((Object)schema);
        return schema;
    }

    private BaseTable getTable(String schemaName, String tableName) {
        if (tableName == null) {
            return null;
        }
        tableName = tableName.trim();
        Schema schema = this.getSchema(schemaName);
        Iterator it = schema.getTables().iterator();
        while (it.hasNext()) {
            BaseTable table = (BaseTable)it.next();
            if (!table.getName().equalsIgnoreCase(tableName)) continue;
            return table;
        }
        PersistentTable table = SQLTablesFactory.eINSTANCE.createPersistentTable();
        table.setName(tableName);
        schema.getTables().add((Object)table);
        return table;
    }

    private Column getColumn(String schemaName, String tableName, String columnName) {
        BaseTable table = this.getTable(schemaName, tableName);
        if (columnName == null) {
            return null;
        }
        columnName = columnName.trim();
        Iterator it = table.getColumns().iterator();
        while (it.hasNext()) {
            Column column = (Column)it.next();
            if (!column.getName().equalsIgnoreCase(columnName)) continue;
            return column;
        }
        Column column = SQLTablesFactory.eINSTANCE.createColumn();
        column.setName(columnName);
        table.getColumns().add((Object)column);
        return column;
    }

    private static int getJdbcType(PersistentAttribute pattribute) {
        IPersistenceModelAdapter modelAdapter = pattribute.getModelAdapter();
        if (modelAdapter instanceof JavaPersistentAttributeModelAdapter) {
            String[][] resolvedType;
            JavaPersistentAttributeModelAdapter jma = (JavaPersistentAttributeModelAdapter)modelAdapter;
            String typeName = Signature.getSignatureSimpleName((String)jma.getAttribute().getTypeSignature());
            try {
                resolvedType = jma.getAttribute().getJDTMember().getDeclaringType().resolveType(typeName);
            }
            catch (JavaModelException e) {
                throw new RuntimeException(e);
            }
            String fullyQualifiedTypeName = resolvedType == null ? typeName : String.valueOf(resolvedType[0][0]) + "." + typeName;
            return JDBCTools.jdbcTypeForClassNamed((String)fullyQualifiedTypeName).getCode();
        }
        return 12;
    }

    public static void createDdl(PersistenceProject persistenceProject, IProgressMonitor monitor) throws CoreException {
        PersistenceFile pFile;
        monitor.subTask("Creating database definition ...");
        Connection conInfo = persistenceProject.getConnectionInfo();
        OrmDdlGenerator ddlGen = conInfo != null ? new OrmDdlGenerator(conInfo.getDatabaseName(), conInfo.getDatabaseProductVersion()) : new OrmDdlGenerator(null, null);
        monitor.subTask("Analyzing resources ...");
        ArrayList pFiles = ddlGen.computePersistenceFiles(persistenceProject);
        float workdone = 20.0f;
        monitor.worked(Math.round(workdone));
        monitor.subTask("Building persistence resources ...");
        Iterator it = pFiles.iterator();
        while (it.hasNext()) {
            pFile = (PersistenceFile)it.next();
            ddlGen.addBasicColumns(persistenceProject, pFile);
            monitor.worked(Math.round(workdone += (float)(40 / pFiles.size())));
        }
        it = pFiles.iterator();
        while (it.hasNext()) {
            pFile = (PersistenceFile)it.next();
            ddlGen.addRefColumns(persistenceProject, pFile);
            monitor.worked(Math.round(workdone += (float)(40 / pFiles.size())));
        }
        ddlGen.createDDL();
    }

    private ArrayList computePersistenceFiles(PersistenceProject persistenceProject) throws CoreException {
        ArrayList presources = new ArrayList(100);
        this.computePersistenceFiles(presources, (List)persistenceProject.getPersistenceResources());
        return presources;
    }

    private void computePersistenceFiles(List pfiles, List presources) throws CoreException {
        Iterator it = presources.iterator();
        while (it.hasNext()) {
            PersistenceResource resource = (PersistenceResource)it.next();
            if (resource instanceof PersistenceContainer) {
                PersistenceContainer container = (PersistenceContainer)resource;
                this.computePersistenceFiles(pfiles, (List)container.getPersistenceResources());
                continue;
            }
            if (!(resource instanceof PersistenceFile)) continue;
            pfiles.add(resource);
        }
    }

    private void addBasicColumns(PersistenceProject persistenceProject, PersistenceFile resource) {
        Iterator types = resource.getPersistentTypes().iterator();
        while (types.hasNext()) {
            PersistentType type = (PersistentType)types.next();
            TypeMapping typeMapping = type.getTypeMapping();
            Table ormTable = typeMapping.getTable();
            if (ormTable == null) break;
            BaseTable dbTable = this.getTable(ormTable.getCatalog(), ormTable.getSchema(), ormTable.getName());
            ArrayList<Column> pkList = new ArrayList<Column>(3);
            Iterator atts = type.getPersistentAttributes().iterator();
            while (atts.hasNext()) {
                PersistentAttribute attribute = (PersistentAttribute)atts.next();
                AttributeMapping attributeMapping = attribute.getAttributeMapping();
                if (attributeMapping instanceof ColumnHolder) {
                    ColumnHolder columnHolder = (ColumnHolder)attributeMapping;
                    org.eclipse.dali.orm.Column ormColumn = columnHolder.getColumn();
                    Column dbColumn = this.getColumn(ormTable.getSchema(), ormColumn.getTableName(), ormColumn.getName());
                    int jdbcType = OrmDdlGenerator.getJdbcType(attribute);
                    this.copyToDb(ormColumn, dbColumn, jdbcType);
                    if (!(columnHolder instanceof IdMapping)) continue;
                    pkList.add(dbColumn);
                    continue;
                }
                if (!(attributeMapping instanceof SingleRelationshipMapping)) continue;
                SingleRelationshipMapping cfr_ignored_0 = (SingleRelationshipMapping)attributeMapping;
            }
            this.addPkToTable(ormTable, dbTable, pkList);
        }
    }

    private void addRefColumns(PersistenceProject persistenceProject, PersistenceFile pFile) {
        Iterator types = pFile.getPersistentTypes().iterator();
        block0: while (types.hasNext()) {
            PersistentType type = (PersistentType)types.next();
            TypeMapping typeMapping = type.getTypeMapping();
            Table ormTable = typeMapping.getTable();
            if (ormTable == null) break;
            BaseTable dbTable = this.getTable(ormTable.getCatalog(), ormTable.getSchema(), ormTable.getName());
            Iterator atts = type.getPersistentAttributes().iterator();
            while (atts.hasNext()) {
                SingleRelationshipMapping sMapping;
                String mappedBy;
                PersistentAttribute attribute = (PersistentAttribute)atts.next();
                AttributeMapping attributeMapping = attribute.getAttributeMapping();
                EStructuralFeature sfMappedBy = attributeMapping.eClass().getEStructuralFeature("mappedBy");
                if (sfMappedBy != null && (mappedBy = (String)attributeMapping.eGet(sfMappedBy)) != null && mappedBy.trim().length() > 0) continue block0;
                if (!(attributeMapping instanceof RelationshipMapping)) continue;
                RelationshipMapping relMapping = (RelationshipMapping)attributeMapping;
                String targetEntityName = relMapping.getTargetEntity();
                PersistentType targetType = pFile.resolvePersistentType(targetEntityName);
                Table targetOrmTable = targetType.getTypeMapping().getTable();
                if (relMapping instanceof SingleRelationshipMapping) {
                    sMapping = (SingleRelationshipMapping)attributeMapping;
                    Iterator cols = sMapping.getJoinColumns().iterator();
                    while (cols.hasNext()) {
                        JoinColumn joinCol = (JoinColumn)cols.next();
                        this.addJoinColumn(targetOrmTable, ormTable, joinCol);
                    }
                    continue;
                }
                if (!(relMapping instanceof MultiRelationshipMapping)) continue;
                sMapping = (MultiRelationshipMapping)attributeMapping;
                if (sMapping instanceof ManyToManyMapping) {
                    JoinColumn joinCol;
                    ManyToManyMapping m2m = (ManyToManyMapping)sMapping;
                    JoinTable ormJoinTable = m2m.getJoinTable();
                    if (ormJoinTable == null) continue;
                    Iterator cols = ormJoinTable.getJoinColumns().iterator();
                    while (cols.hasNext()) {
                        joinCol = (JoinColumn)cols.next();
                        this.addJoinColumn(ormTable, (Table)ormJoinTable, joinCol);
                    }
                    cols = ormJoinTable.getInverseJoinColumns().iterator();
                    while (cols.hasNext()) {
                        joinCol = (JoinColumn)cols.next();
                        this.addJoinColumn(targetOrmTable, (Table)ormJoinTable, joinCol);
                    }
                    continue;
                }
                if (!(relMapping instanceof OneToManyMapping)) continue;
                BaseTable targetDbTable = this.getTable(targetOrmTable.getCatalog(), targetOrmTable.getSchema(), targetOrmTable.getName());
                this.copyPkColumns(targetDbTable, dbTable);
            }
        }
    }

    private void addJoinColumn(Table srcTable, Table targetTable, JoinColumn joinCol) {
        Column dbRefColumn = this.getColumn(srcTable.getSchema(), srcTable.getName(), joinCol.getReferencedColumnName());
        Column dbJoinColumn = this.getColumn(targetTable.getSchema(), targetTable.getName(), joinCol.getName());
        this.copyDataType(dbRefColumn, dbJoinColumn);
    }

    private void copyPkColumns(BaseTable srcTable, BaseTable destTable) {
        Iterator it = srcTable.getConstraints().iterator();
        while (it.hasNext()) {
            Object constraint = it.next();
            if (!(constraint instanceof PrimaryKey)) continue;
            PrimaryKey pk = (PrimaryKey)constraint;
            Iterator pks = pk.getMembers().iterator();
            while (pks.hasNext()) {
                Column pkCol = (Column)pks.next();
                this.copyColumn((org.eclipse.wst.rdb.internal.models.sql.tables.Table)destTable, pkCol);
            }
        }
    }

    private Column copyColumn(org.eclipse.wst.rdb.internal.models.sql.tables.Table srcTable, org.eclipse.wst.rdb.internal.models.sql.tables.Table destTable, String colName) {
        Column srcColumn = this.getColumn(srcTable.getSchema().getName(), srcTable.getName(), colName);
        return this.copyColumn(destTable, srcColumn);
    }

    private Column copyColumn(org.eclipse.wst.rdb.internal.models.sql.tables.Table destTable, Column srcColumn) {
        Column destColumn = this.getColumn(destTable.getSchema().getName(), destTable.getName(), srcColumn.getName());
        destColumn.setName(srcColumn.getName());
        this.copyDataType(srcColumn, destColumn);
        return destColumn;
    }

    private void copyDataType(Column srcColumn, Column destColumn) {
        DataType joinType = srcColumn.getDataType();
        if (joinType == null) {
            return;
        }
        PredefinedDataTypeDefinition typeDef = this.dbDef.getPredefinedDataTypeDefinition(joinType.getName());
        if (typeDef != null) {
            EStructuralFeature feature;
            PredefinedDataType dataType = this.dbDef.getPredefinedDataType(typeDef);
            if (typeDef.isLengthSupported()) {
                feature = dataType.eClass().getEStructuralFeature("length");
                dataType.eSet(feature, srcColumn.eGet(feature));
            } else if (typeDef.isPrecisionSupported()) {
                feature = dataType.eClass().getEStructuralFeature("precision");
                dataType.eSet(feature, srcColumn.eGet(feature));
            }
            if (typeDef.isScaleSupported()) {
                feature = dataType.eClass().getEStructuralFeature("scale");
                dataType.eSet(feature, srcColumn.eGet(feature));
            }
            destColumn.setContainedType((SQLDataType)dataType);
        }
    }

    private void copyToDb(org.eclipse.dali.orm.Column ormColumn, Column dbColumn, int jdbcType) {
        PredefinedDataTypeDefinition typeDef;
        dbColumn.setName(ormColumn.getName());
        String columnDefinition = ormColumn.getColumnDefinition();
        if (columnDefinition != null && columnDefinition.trim().length() > 0) {
            ValueExpressionDefault expression = SQLExpressionsFactoryImpl.eINSTANCE.createValueExpressionDefault();
            expression.setSQL(columnDefinition);
            dbColumn.setGenerateExpression((ValueExpression)expression);
        }
        dbColumn.setNullable(ormColumn.isNullable());
        List predefinedDataTypeDefinitions = this.dbDef.getPredefinedDataTypeDefinitionsByJDBCEnumType(jdbcType);
        if (predefinedDataTypeDefinitions == null) {
            predefinedDataTypeDefinitions = this.dbDef.getPredefinedDataTypeDefinitionsByJDBCEnumType(12);
        }
        int size = predefinedDataTypeDefinitions.size();
        if (predefinedDataTypeDefinitions != null && size > 0 && (typeDef = (PredefinedDataTypeDefinition)predefinedDataTypeDefinitions.get(0)) != null && this.dbDef != null) {
            EStructuralFeature feature;
            PredefinedDataType type = this.dbDef.getPredefinedDataType(typeDef);
            if (typeDef.isLengthSupported()) {
                feature = type.eClass().getEStructuralFeature("length");
                type.eSet(feature, (Object)new Integer(ormColumn.getLength()));
            } else if (typeDef.isPrecisionSupported()) {
                feature = type.eClass().getEStructuralFeature("precision");
                type.eSet(feature, (Object)new Integer(ormColumn.getLength()));
            }
            if (typeDef.isScaleSupported()) {
                feature = type.eClass().getEStructuralFeature("scale");
                type.eSet(feature, (Object)new Integer(ormColumn.getScale()));
            }
            dbColumn.setContainedType((SQLDataType)type);
        }
    }

    private void addPkToTable(Table ormTable, BaseTable table, List pkList) {
        if (!pkList.isEmpty()) {
            DataModelElementFactory factory = this.dbDef.getDataModelElementFactory();
            EClass primaryKeyClass = SQLConstraintsPackage.eINSTANCE.getPrimaryKey();
            PrimaryKey pk = (PrimaryKey)factory.create(primaryKeyClass);
            pk.setName(String.valueOf(ormTable.getName()) + "_pk");
            Iterator atts = pkList.iterator();
            while (atts.hasNext()) {
                Column dbColumn = (Column)atts.next();
                pk.getMembers().add((Object)dbColumn);
            }
            table.getConstraints().add((Object)pk);
        }
    }
}

