/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.db;

import java.text.Collator;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.dali.db.Column;
import org.eclipse.dali.db.ForeignKey;
import org.eclipse.dali.db.Schema;
import org.eclipse.dali.internal.utility.CollectionTools;
import org.eclipse.dali.internal.utility.StringTools;
import org.eclipse.dali.internal.utility.iterators.TransformationIterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.rdb.internal.models.sql.constraints.PrimaryKey;
import org.eclipse.wst.rdb.internal.models.sql.tables.BaseTable;

public final class Table
implements Comparable {
    private final Schema schema;
    private final org.eclipse.wst.rdb.internal.models.sql.tables.Table rdbTable;
    private Set columns;
    private Set primaryKeyColumns;
    private Set foreignKeys;
    private Set foreignKeyColumns;

    Table(Schema schema, org.eclipse.wst.rdb.internal.models.sql.tables.Table rdbTable) {
        this.schema = schema;
        this.rdbTable = rdbTable;
    }

    public String getName() {
        return this.rdbTable.getName();
    }

    boolean isCaseSensitive() {
        return this.schema.isCaseSensitive();
    }

    public String shortJavaClassName() {
        return this.isCaseSensitive() ? this.getName() : StringTools.capitalize((String)this.getName().toLowerCase());
    }

    public boolean matchesShortJavaClassName(String shortJavaClassName) {
        return this.isCaseSensitive() ? this.getName().equals(shortJavaClassName) : this.getName().equalsIgnoreCase(shortJavaClassName);
    }

    public String javaFieldName() {
        return this.isCaseSensitive() ? this.getName() : this.getName().toLowerCase();
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.getName());
    }

    boolean wraps(org.eclipse.wst.rdb.internal.models.sql.tables.Table table) {
        return this.rdbTable == table;
    }

    Table table(org.eclipse.wst.rdb.internal.models.sql.tables.Table table) {
        return this.schema.table(table);
    }

    public int compareTo(Object o) {
        return Collator.getInstance().compare(this.getName(), ((Table)o).getName());
    }

    private synchronized Set getColumns() {
        if (this.columns == null) {
            this.columns = this.buildColumns();
        }
        return this.columns;
    }

    private Set buildColumns() {
        EList rdbColumns = this.rdbTable.getColumns();
        HashSet<Column> result = new HashSet<Column>(rdbColumns.size());
        Iterator stream = rdbColumns.iterator();
        while (stream.hasNext()) {
            result.add(new Column(this, (org.eclipse.wst.rdb.internal.models.sql.tables.Column)stream.next()));
        }
        return result;
    }

    public Iterator columns() {
        return this.getColumns().iterator();
    }

    public int columnsSize() {
        return this.getColumns().size();
    }

    public boolean columnsContains(Column column) {
        return this.getColumns().contains(column);
    }

    public Iterator columnNames() {
        return new TransformationIterator(this.columns()){

            protected Object transform(Object next) {
                return ((Column)next).getName();
            }
        };
    }

    public boolean containsColumnNamed(String name) {
        return this.columnNamed(name) != null;
    }

    public Column columnNamed(String name) {
        return this.isCaseSensitive() ? this.columnNamedInternal(name) : this.columnNamedIgnoreCase(name);
    }

    private Column columnNamedInternal(String name) {
        Iterator stream = this.columns();
        while (stream.hasNext()) {
            Column column = (Column)stream.next();
            if (!column.getName().equals(name)) continue;
            return column;
        }
        return null;
    }

    private Column columnNamedIgnoreCase(String name) {
        Iterator stream = this.columns();
        while (stream.hasNext()) {
            Column column = (Column)stream.next();
            if (!StringTools.stringsAreEqualIgnoreCase((String)column.getName(), (String)name)) continue;
            return column;
        }
        return null;
    }

    Column column(org.eclipse.wst.rdb.internal.models.sql.tables.Column rdbColumn) {
        if (rdbColumn.getTable() != this.rdbTable) {
            return this.schema.column(rdbColumn);
        }
        Iterator stream = this.columns();
        while (stream.hasNext()) {
            Column column = (Column)stream.next();
            if (!column.wraps(rdbColumn)) continue;
            return column;
        }
        throw new IllegalArgumentException("invalid rdb column: " + rdbColumn);
    }

    private synchronized Set getPrimaryKeyColumns() {
        if (this.primaryKeyColumns == null) {
            this.primaryKeyColumns = this.buildPrimaryKeyColumns();
        }
        return this.primaryKeyColumns;
    }

    private Set buildPrimaryKeyColumns() {
        if (!(this.rdbTable instanceof BaseTable)) {
            return Collections.EMPTY_SET;
        }
        PrimaryKey pk = ((BaseTable)this.rdbTable).getPrimaryKey();
        if (pk == null) {
            return Collections.EMPTY_SET;
        }
        EList pkColumns = pk.getMembers();
        HashSet<Column> result = new HashSet<Column>(pkColumns.size());
        Iterator stream = pkColumns.iterator();
        while (stream.hasNext()) {
            result.add(this.column((org.eclipse.wst.rdb.internal.models.sql.tables.Column)stream.next()));
        }
        return result;
    }

    public Iterator primaryKeyColumns() {
        return this.getPrimaryKeyColumns().iterator();
    }

    public int primaryKeyColumnsSize() {
        return this.getPrimaryKeyColumns().size();
    }

    public boolean primaryKeyColumnsContains(Column column) {
        return this.getPrimaryKeyColumns().contains(column);
    }

    private synchronized Set getForeignKeys() {
        if (this.foreignKeys == null) {
            this.foreignKeys = this.buildForeignKeys();
        }
        return this.foreignKeys;
    }

    private Set buildForeignKeys() {
        if (!(this.rdbTable instanceof BaseTable)) {
            return Collections.EMPTY_SET;
        }
        List rdbForeignKeys = ((BaseTable)this.rdbTable).getForeignKeys();
        HashSet<ForeignKey> result = new HashSet<ForeignKey>(rdbForeignKeys.size());
        Iterator stream = rdbForeignKeys.iterator();
        while (stream.hasNext()) {
            result.add(new ForeignKey(this, (org.eclipse.wst.rdb.internal.models.sql.constraints.ForeignKey)stream.next()));
        }
        return result;
    }

    public Iterator foreignKeys() {
        return this.getForeignKeys().iterator();
    }

    public int foreignKeysSize() {
        return this.getForeignKeys().size();
    }

    private synchronized Set getForeignKeyColumns() {
        if (this.foreignKeyColumns == null) {
            this.foreignKeyColumns = this.buildForeignKeyColumns();
        }
        return this.foreignKeyColumns;
    }

    private Set buildForeignKeyColumns() {
        if (!(this.rdbTable instanceof BaseTable)) {
            return Collections.EMPTY_SET;
        }
        HashSet result = new HashSet(this.columnsSize());
        Iterator stream = this.foreignKeys();
        while (stream.hasNext()) {
            CollectionTools.addAll(result, (Iterator)((ForeignKey)stream.next()).baseColumns());
        }
        return result;
    }

    public Iterator foreignKeyColumns() {
        return this.getForeignKeyColumns().iterator();
    }

    public int foreignKeyColumnsSize() {
        return this.getForeignKeyColumns().size();
    }

    public boolean foreignKeyColumnsContains(Column column) {
        return this.getForeignKeyColumns().contains(column);
    }
}

