/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.selection.tracker;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dali.orm.PersistenceFile;
import org.eclipse.dali.orm.PersistenceSourceRefElement;
import org.eclipse.dali.ui.PersistenceUiPlugin;
import org.eclipse.dali.ui.selection.tracker.PartSelectionTracker;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class CompilationUnitSelectionTracker
extends PartSelectionTracker {
    private PersistenceFile file;

    public CompilationUnitSelectionTracker(ITextEditor part) {
        super((IWorkbenchPart)part);
        this.file = PersistenceUiPlugin.getPlugin().getPersistenceManager().persistenceFileForInput(part.getEditorInput());
    }

    protected EObject getEObjectAt(ISelection aSelection) {
        ITextSelection aTextSelection = (ITextSelection)aSelection;
        PersistenceSourceRefElement eObj = this.file.persistenceObjectAt(aTextSelection.getOffset());
        Assert.isNotNull((Object)eObj);
        return eObj;
    }

    protected Collection getEObjectsAt(EObject anEObj) {
        LinkedHashSet<EObject> set = new LinkedHashSet<EObject>();
        EObject eObj = anEObj;
        while (eObj != null && eObj.eContainer() != null) {
            set.add(eObj.eContainer());
            eObj = eObj.eContainer();
        }
        return set;
    }

    protected void addListener() {
        ITextEditor anEditor = (ITextEditor)this.part;
        IPostSelectionProvider provider = (IPostSelectionProvider)anEditor.getSelectionProvider();
        provider.addPostSelectionChangedListener((ISelectionChangedListener)this);
    }

    protected void removeListener() {
        ITextEditor anEditor = (ITextEditor)this.part;
        IPostSelectionProvider provider = (IPostSelectionProvider)anEditor.getSelectionProvider();
        provider.removePostSelectionChangedListener((ISelectionChangedListener)this);
    }
}

