/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import org.eclipse.dali.orm.DiscriminatorValue;
import org.eclipse.dali.orm.Inheritance;
import org.eclipse.dali.orm.InheritanceType;
import org.eclipse.dali.orm.OrmPackage;
import org.eclipse.dali.orm.provider.DiscriminatorValueItemProvider;
import org.eclipse.dali.orm.provider.InheritanceItemProvider;
import org.eclipse.dali.orm.provider.OrmItemProviderAdapterFactory;
import org.eclipse.dali.ui.DaliUiMessages;
import org.eclipse.dali.ui.views.DiscriminatorColumnComposite;
import org.eclipse.dali.ui.views.IPersistenceComposite;
import org.eclipse.dali.ui.views.PrimaryKeyJoinColumnsComposite;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class InheritanceComposite
extends Composite
implements IPersistenceComposite {
    private boolean populating;
    private Inheritance inheritance;
    private EditingDomain editingDomain;
    private OrmItemProviderAdapterFactory adapterFactory;
    private InheritanceItemProvider inheritanceItemProvider;
    private DiscriminatorValueItemProvider discriminatorValueItemProvider;
    private ComboViewer strategyViewer;
    private DiscriminatorColumnComposite discriminatorColumnComposite;
    private Combo discriminatorValueCombo;
    private PrimaryKeyJoinColumnsComposite pkJoinColumnsComposite;
    private INotifyChangedListener inheritanceListener;
    private INotifyChangedListener discriminatorValueListener;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected InheritanceComposite(Composite parent, EditingDomain editingDomain, OrmItemProviderAdapterFactory adapterFactory) {
        super(parent, 0);
        this.editingDomain = editingDomain;
        this.adapterFactory = adapterFactory;
        this.initialize();
        this.initializeLayout();
    }

    private void initialize() {
        this.inheritanceItemProvider = (InheritanceItemProvider)this.adapterFactory.createInheritanceAdapter();
        this.discriminatorValueItemProvider = (DiscriminatorValueItemProvider)this.adapterFactory.createDiscriminatorValueAdapter();
    }

    private void initializeLayout() {
        this.setLayout((Layout)new GridLayout(2, false));
        Label strategyLabel = new Label((Composite)this, 16384);
        strategyLabel.setText(DaliUiMessages.InheritanceComposite_strategy);
        this.strategyViewer = this.buildStrategyCombo(this);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.strategyViewer.getCombo().setLayoutData((Object)gridData);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.strategyViewer.getCombo(), "org.eclipse.dali.ui.entity_inheritanceStrategy");
        this.discriminatorColumnComposite = new DiscriminatorColumnComposite(this, this.editingDomain, this.adapterFactory);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.discriminatorColumnComposite.setLayoutData(gridData);
        Label discriminatorValueLabel = new Label((Composite)this, 16384);
        discriminatorValueLabel.setText(DaliUiMessages.InheritanceComposite_discriminatorValue);
        this.discriminatorValueCombo = this.buildDiscriminatorValueCombo(this);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.discriminatorValueCombo.setLayoutData((Object)gridData);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.discriminatorValueCombo, "org.eclipse.dali.ui.entity_inheritanceDiscriminatorValue");
        this.pkJoinColumnsComposite = new PrimaryKeyJoinColumnsComposite(this, this.editingDomain, this.adapterFactory);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        this.pkJoinColumnsComposite.setLayoutData(gridData);
    }

    private ComboViewer buildStrategyCombo(Composite parent) {
        ComboViewer viewer = new ComboViewer(parent, 8);
        viewer.add(InheritanceType.VALUES.toArray());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (InheritanceComposite.this.populating) {
                    return;
                }
                if (event.getSelection() instanceof StructuredSelection) {
                    StructuredSelection selection = (StructuredSelection)event.getSelection();
                    InheritanceType strategy = (InheritanceType)selection.getFirstElement();
                    if (!InheritanceComposite.this.inheritance.getStrategy().equals(strategy)) {
                        InheritanceComposite.this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)InheritanceComposite.this.editingDomain, (Object)InheritanceComposite.this.inheritance, (Object)OrmPackage.eINSTANCE.getInheritance_Strategy(), (Object)strategy));
                    }
                }
            }
        });
        return viewer;
    }

    private Combo buildDiscriminatorValueCombo(Composite parent) {
        final Combo combo = new Combo(parent, 2052);
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (InheritanceComposite.this.populating) {
                    return;
                }
                DiscriminatorValue discriminatorValue = InheritanceComposite.this.inheritance.getDiscriminatorValue();
                String columnText = ((Combo)e.getSource()).getText();
                if (columnText.equals("")) {
                    columnText = null;
                    if (discriminatorValue.getSpecifiedValue() == null || discriminatorValue.getSpecifiedValue().equals("")) {
                        return;
                    }
                }
                if (columnText != null && combo.getItemCount() > 0 && columnText.equals(combo.getItem(0))) {
                    columnText = null;
                }
                if (discriminatorValue.getSpecifiedValue() == null || !discriminatorValue.getSpecifiedValue().equals(columnText)) {
                    InheritanceComposite.this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)InheritanceComposite.this.editingDomain, (Object)discriminatorValue, (Object)OrmPackage.eINSTANCE.getDiscriminatorValue_SpecifiedValue(), (Object)columnText));
                }
            }
        });
        return combo;
    }

    public void populate(EObject model) {
        this.populating = true;
        this.disengageListeners();
        this.inheritance = (Inheritance)model;
        if (this.inheritance == null) {
            this.populating = false;
            this.discriminatorColumnComposite.populate(null);
            return;
        }
        this.engageListeners();
        this.popuplateStrategyComboViewer();
        this.discriminatorColumnComposite.populate((EObject)this.inheritance.getDiscriminatorColumn());
        this.popuplateDiscriminatorValueCombo();
        this.pkJoinColumnsComposite.populate((EObject)this.inheritance);
        this.populating = false;
    }

    private void engageListeners() {
        this.inheritanceItemProvider.addListener(this.getInheritanceListener());
        this.inheritance.eAdapters().add((Object)this.inheritanceItemProvider);
        this.discriminatorValueItemProvider.addListener(this.getDiscriminatorValueListener());
        this.inheritance.getDiscriminatorValue().eAdapters().add((Object)this.discriminatorValueItemProvider);
    }

    private void disengageListeners() {
        if (this.inheritance != null) {
            this.inheritance.getDiscriminatorValue().eAdapters().remove((Object)this.discriminatorValueItemProvider);
            this.discriminatorValueItemProvider.removeListener(this.getDiscriminatorValueListener());
            this.inheritance.eAdapters().remove((Object)this.inheritanceItemProvider);
            this.inheritanceItemProvider.removeListener(this.getInheritanceListener());
        }
    }

    private void popuplateStrategyComboViewer() {
        if (this.inheritance.getStrategy() == InheritanceType.DEFAULT_LITERAL) {
            if (((StructuredSelection)this.strategyViewer.getSelection()).getFirstElement() != InheritanceType.DEFAULT_LITERAL) {
                this.strategyViewer.setSelection((ISelection)new StructuredSelection((Object)InheritanceType.DEFAULT_LITERAL));
            }
        } else if (this.inheritance.getStrategy() == InheritanceType.JOINED_LITERAL) {
            if (((StructuredSelection)this.strategyViewer.getSelection()).getFirstElement() != InheritanceType.JOINED_LITERAL) {
                this.strategyViewer.setSelection((ISelection)new StructuredSelection((Object)InheritanceType.JOINED_LITERAL));
            }
        } else if (this.inheritance.getStrategy() == InheritanceType.SINGLE_TABLE_LITERAL) {
            if (((StructuredSelection)this.strategyViewer.getSelection()).getFirstElement() != InheritanceType.SINGLE_TABLE_LITERAL) {
                this.strategyViewer.setSelection((ISelection)new StructuredSelection((Object)InheritanceType.SINGLE_TABLE_LITERAL));
            }
        } else if (((StructuredSelection)this.strategyViewer.getSelection()).getFirstElement() != InheritanceType.TABLE_PER_CLASS_LITERAL) {
            this.strategyViewer.setSelection((ISelection)new StructuredSelection((Object)InheritanceType.TABLE_PER_CLASS_LITERAL));
        }
    }

    private void popuplateDiscriminatorValueCombo() {
        String specifiedValue = this.inheritance.getDiscriminatorValue().getSpecifiedValue();
        String defaultValue = this.inheritance.getDiscriminatorValue().getDefaultValue();
        if (this.inheritance.specifyDiscriminatorValue()) {
            this.discriminatorValueCombo.setEnabled(true);
            if (this.discriminatorValueCombo.getItemCount() == 0) {
                this.discriminatorValueCombo.add(DaliUiMessages.DiscriminatorColumnComposite_defaultEmpty);
            }
            if (defaultValue != null) {
                this.discriminatorValueCombo.setItem(0, NLS.bind((String)DaliUiMessages.ColumnComposite_defaultWithOneParam, (Object)defaultValue));
            } else {
                this.discriminatorValueCombo.setItem(0, DaliUiMessages.DiscriminatorColumnComposite_defaultEmpty);
            }
        } else {
            this.discriminatorValueCombo.setEnabled(false);
            if (this.discriminatorValueCombo.getItemCount() == 1) {
                this.discriminatorValueCombo.setText("");
                this.discriminatorValueCombo.removeAll();
            }
        }
        if (specifiedValue != null) {
            if (!this.discriminatorValueCombo.getText().equals(specifiedValue)) {
                this.discriminatorValueCombo.setText(specifiedValue);
            }
        } else if (this.discriminatorValueCombo.getSelectionIndex() != 0) {
            this.discriminatorValueCombo.select(0);
        }
    }

    private INotifyChangedListener getInheritanceListener() {
        if (this.inheritanceListener == null) {
            this.inheritanceListener = new INotifyChangedListener(){

                public void notifyChanged(Notification notification) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.dali.orm.Inheritance");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (notification.getFeatureID((Class)clazz) == 0) {
                        InheritanceType inheritanceType = (InheritanceType)notification.getNewValue();
                        Display.getDefault().syncExec(new Runnable(this, inheritanceType){
                            final /* synthetic */ 3 this$1;
                            private final /* synthetic */ InheritanceType val$inheritanceType;
                            {
                                this.this$1 = var1_1;
                                this.val$inheritanceType = inheritanceType;
                            }

                            public void run() {
                                if (((StructuredSelection)InheritanceComposite.access$3(3.access$0(this.this$1)).getSelection()).getFirstElement() != this.val$inheritanceType) {
                                    InheritanceComposite.access$3(3.access$0(this.this$1)).setSelection((ISelection)new StructuredSelection((Object)this.val$inheritanceType));
                                }
                            }
                        });
                    }
                }

                static /* synthetic */ InheritanceComposite access$0(3 var0) {
                    return var0.InheritanceComposite.this;
                }
            };
        }
        return this.inheritanceListener;
    }

    private INotifyChangedListener getDiscriminatorValueListener() {
        if (this.discriminatorValueListener == null) {
            this.discriminatorValueListener = new INotifyChangedListener(){

                public void notifyChanged(Notification notification) {
                    InheritanceComposite.this.discriminatorValueChanged(notification);
                }
            };
        }
        return this.discriminatorValueListener;
    }

    private void discriminatorValueChanged(Notification notification) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.dali.orm.DiscriminatorValue");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (notification.getFeatureID((Class)clazz) == 1) {
            final String columnName = (String)notification.getNewValue();
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    if (InheritanceComposite.this.discriminatorValueCombo.getText() == null || !InheritanceComposite.this.discriminatorValueCombo.getText().equals(columnName)) {
                        if (columnName == null) {
                            InheritanceComposite.this.discriminatorValueCombo.select(0);
                        } else {
                            InheritanceComposite.this.discriminatorValueCombo.setText(columnName);
                        }
                    }
                }
            });
        } else {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.dali.orm.DiscriminatorValue");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (notification.getFeatureID((Class)clazz2) == 0) {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        InheritanceComposite.this.populating = true;
                        InheritanceComposite.this.popuplateDiscriminatorValueCombo();
                        InheritanceComposite.this.populating = false;
                    }
                });
            }
        }
    }

    public boolean setFocus() {
        super.setFocus();
        return this.strategyViewer.getCombo().setFocus();
    }

    public void dispose() {
        this.disengageListeners();
        this.discriminatorColumnComposite.dispose();
        this.pkJoinColumnsComposite.dispose();
        super.dispose();
    }

    static /* synthetic */ ComboViewer access$3(InheritanceComposite inheritanceComposite) {
        return inheritanceComposite.strategyViewer;
    }
}

