/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.utility.tests.iterators;

import java.util.Iterator;
import java.util.NoSuchElementException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.swingui.TestRunner;
import org.eclipse.dali.internal.utility.iterators.ChainIterator;

public class ChainIteratorTests
extends TestCase {
    private static final Class[] VECTOR_HIERARCHY;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    static {
        Class[] classArray = new Class[4];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.util.Vector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.util.AbstractList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("java.util.AbstractCollection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[2] = clazz3;
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[3] = clazz4;
        VECTOR_HIERARCHY = classArray;
    }

    public static void main(String[] args) {
        String[] stringArray = new String[2];
        stringArray[0] = "-c";
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("org.eclipse.dali.utility.tests.iterators.ChainIteratorTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[1] = clazz.getName();
        TestRunner.main((String[])stringArray);
    }

    public static Test suite() {
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("org.eclipse.dali.utility.tests.iterators.ChainIteratorTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public ChainIteratorTests(String name) {
        super(name);
    }

    public void testHasNext() {
        int i = 0;
        Iterator stream = this.buildIterator();
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        ChainIteratorTests.assertEquals((int)VECTOR_HIERARCHY.length, (int)i);
    }

    public void testInnerHasNext() {
        int i = 0;
        Iterator stream = this.buildInnerIterator();
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        ChainIteratorTests.assertEquals((int)VECTOR_HIERARCHY.length, (int)i);
    }

    public void testNext() {
        int i = 0;
        Iterator stream = this.buildIterator();
        while (stream.hasNext()) {
            ChainIteratorTests.assertEquals((String)"bogus link", (Object)VECTOR_HIERARCHY[i], stream.next());
            ++i;
        }
    }

    public void testInnerNext() {
        int i = 0;
        Iterator stream = this.buildInnerIterator();
        while (stream.hasNext()) {
            ChainIteratorTests.assertEquals((String)"bogus link", (Object)VECTOR_HIERARCHY[i], stream.next());
            ++i;
        }
    }

    public void testNoSuchElementException() {
        boolean exCaught = false;
        Iterator stream = this.buildIterator();
        Class javaClass = null;
        while (stream.hasNext()) {
            javaClass = (Class)stream.next();
        }
        try {
            javaClass = (Class)stream.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        ChainIteratorTests.assertTrue((String)("NoSuchElementException not thrown: " + javaClass), (boolean)exCaught);
    }

    public void testUnsupportedOperationException() {
        boolean exCaught = false;
        Iterator stream = this.buildIterator();
        while (stream.hasNext()) {
            Object e = stream.next();
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = Class.forName("java.util.AbstractCollection");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (e != clazz) continue;
            try {
                stream.remove();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                exCaught = true;
            }
        }
        ChainIteratorTests.assertTrue((String)"UnsupportedOperationException not thrown", (boolean)exCaught);
    }

    private Iterator buildIterator() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.util.Vector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return this.buildChainIterator(clazz, this.buildLinker());
    }

    private Iterator buildInnerIterator() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.util.Vector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return this.buildInnerChainIterator(clazz);
    }

    private Iterator buildChainIterator(Class startLink, ChainIterator.Linker linker) {
        return new ChainIterator((Object)startLink, linker);
    }

    private ChainIterator.Linker buildLinker() {
        return new ChainIterator.Linker(){

            public Object nextLink(Object currentLink) {
                return ((Class)currentLink).getSuperclass();
            }
        };
    }

    private Iterator buildInnerChainIterator(Class startLink) {
        return new ChainIterator(startLink){

            protected Object nextLink(Object currentLink) {
                return ((Class)currentLink).getSuperclass();
            }
        };
    }
}

