/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.utility.tests.iterators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.swingui.TestRunner;
import org.eclipse.dali.internal.utility.iterators.CloneListIterator;
import org.eclipse.dali.utility.tests.TestTools;
import org.eclipse.dali.utility.tests.iterators.CloneIteratorTests;

public class CloneListIteratorTests
extends TestCase {
    List originalList;
    private boolean concurrentProblem;
    private List concurrentList;
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        String[] stringArray = new String[2];
        stringArray[0] = "-c";
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.utility.tests.iterators.CloneListIteratorTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[1] = clazz.getName();
        TestRunner.main((String[])stringArray);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.utility.tests.iterators.CloneListIteratorTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public CloneListIteratorTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.originalList = this.buildList();
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testHasNext() {
        int originalSize = this.originalList.size();
        int i = 0;
        ListIterator stream = this.buildCloneListIterator();
        while (stream.hasNext()) {
            stream.next();
            this.originalList.add("foo");
            ++i;
        }
        CloneListIteratorTests.assertTrue((originalSize != this.originalList.size() ? 1 : 0) != 0);
        CloneListIteratorTests.assertEquals((int)originalSize, (int)i);
    }

    public void testNext() {
        ListIterator nestedListIterator = this.buildNestedListIterator();
        ListIterator stream = this.buildCloneListIterator();
        while (stream.hasNext()) {
            CloneListIteratorTests.assertEquals((String)"bogus element", nestedListIterator.next(), stream.next());
        }
    }

    public void testIndex() {
        ListIterator cloneListIterator = this.buildCloneListIterator();
        ListIterator nestedListIterator = this.buildNestedListIterator();
        int i = 0;
        while (i < 7) {
            nestedListIterator.next();
            cloneListIterator.next();
            CloneListIteratorTests.assertEquals((String)"bogus index", (int)nestedListIterator.nextIndex(), (int)cloneListIterator.nextIndex());
            CloneListIteratorTests.assertEquals((String)"bogus index", (int)nestedListIterator.previousIndex(), (int)cloneListIterator.previousIndex());
            ++i;
        }
        i = 0;
        while (i < 3) {
            nestedListIterator.previous();
            cloneListIterator.previous();
            CloneListIteratorTests.assertEquals((String)"bogus index", (int)nestedListIterator.nextIndex(), (int)cloneListIterator.nextIndex());
            CloneListIteratorTests.assertEquals((String)"bogus index", (int)nestedListIterator.previousIndex(), (int)cloneListIterator.previousIndex());
            ++i;
        }
        while (nestedListIterator.hasNext()) {
            nestedListIterator.next();
            cloneListIterator.next();
            CloneListIteratorTests.assertEquals((String)"bogus index", (int)nestedListIterator.nextIndex(), (int)cloneListIterator.nextIndex());
            CloneListIteratorTests.assertEquals((String)"bogus index", (int)nestedListIterator.previousIndex(), (int)cloneListIterator.previousIndex());
        }
    }

    public void testHasPrevious() {
        int originalSize = this.originalList.size();
        int i = 0;
        ListIterator stream = this.buildCloneListIterator();
        while (stream.hasNext()) {
            stream.next();
            this.originalList.add("foo");
            ++i;
        }
        CloneListIteratorTests.assertTrue((originalSize != this.originalList.size() ? 1 : 0) != 0);
        originalSize = this.originalList.size();
        while (stream.hasPrevious()) {
            stream.previous();
            this.originalList.add("bar");
            --i;
        }
        CloneListIteratorTests.assertTrue((originalSize != this.originalList.size() ? 1 : 0) != 0);
        CloneListIteratorTests.assertEquals((int)0, (int)i);
    }

    public void testPrevious() {
        ListIterator nestedListIterator = this.buildNestedListIterator();
        ListIterator stream = this.buildCloneListIterator();
        while (stream.hasNext()) {
            nestedListIterator.next();
            stream.next();
        }
        while (stream.hasPrevious()) {
            CloneListIteratorTests.assertEquals((String)"bogus element", nestedListIterator.previous(), stream.previous());
        }
    }

    public void testNoSuchElementException() {
        boolean exCaught = false;
        ListIterator stream = this.buildCloneListIterator();
        String string = null;
        while (stream.hasNext()) {
            string = (String)stream.next();
        }
        try {
            string = (String)stream.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        CloneListIteratorTests.assertTrue((String)("NoSuchElementException not thrown: " + string), (boolean)exCaught);
        exCaught = false;
        while (stream.hasPrevious()) {
            string = (String)stream.previous();
        }
        try {
            string = (String)stream.previous();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        CloneListIteratorTests.assertTrue((String)("NoSuchElementException not thrown: " + string), (boolean)exCaught);
    }

    public void testModifyDefault() {
        boolean exCaught = false;
        ListIterator stream = this.buildCloneListIterator();
        while (stream.hasNext()) {
            if (!stream.next().equals("three")) continue;
            try {
                stream.remove();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                exCaught = true;
            }
        }
        CloneListIteratorTests.assertTrue((String)"UnsupportedOperationException not thrown", (boolean)exCaught);
        exCaught = false;
        stream = this.buildCloneListIterator();
        while (stream.hasNext()) {
            if (!stream.next().equals("three")) continue;
            try {
                stream.add("three and a half");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                exCaught = true;
            }
        }
        CloneListIteratorTests.assertTrue((String)"UnsupportedOperationException not thrown", (boolean)exCaught);
        exCaught = false;
        stream = this.buildCloneListIterator();
        while (stream.hasNext()) {
            if (!stream.next().equals("three")) continue;
            try {
                stream.set("another three");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                exCaught = true;
            }
        }
        CloneListIteratorTests.assertTrue((String)"UnsupportedOperationException not thrown", (boolean)exCaught);
    }

    public void testModifyMutatorNext() {
        this.verifyModifyNext((ListIterator)new CloneListIterator(this.originalList, this.buildMutator()));
    }

    public void testModifyMutatorPrevious() {
        this.verifyModifyPrevious((ListIterator)new CloneListIterator(this.originalList, this.buildMutator()));
    }

    private CloneListIterator.Mutator buildMutator() {
        return new CloneListIterator.Mutator(){

            public void add(int index, Object o) {
                CloneListIteratorTests.this.originalList.add(index, o);
            }

            public void remove(int index) {
                CloneListIteratorTests.this.originalList.remove(index);
            }

            public void set(int index, Object o) {
                CloneListIteratorTests.this.originalList.set(index, o);
            }
        };
    }

    public void testModifySubclassNext() {
        this.verifyModifyNext(this.buildSubclass());
    }

    public void testModifySubclassPrevious() {
        this.verifyModifyPrevious(this.buildSubclass());
    }

    private ListIterator buildSubclass() {
        return new CloneListIterator(this.originalList){

            protected void add(int currentIndex, Object o) {
                CloneListIteratorTests.this.originalList.add(currentIndex, o);
            }

            protected void remove(int currentIndex) {
                CloneListIteratorTests.this.originalList.remove(currentIndex);
            }

            protected void set(int currentIndex, Object o) {
                CloneListIteratorTests.this.originalList.set(currentIndex, o);
            }
        };
    }

    private void verifyModifyNext(ListIterator iterator) {
        String removed = "three";
        String addedAfter = "five";
        String added = "five and a half";
        String replaced = "seven";
        String replacement = "another seven";
        CloneListIteratorTests.assertTrue((boolean)this.originalList.contains(removed));
        CloneListIteratorTests.assertTrue((boolean)this.originalList.contains(addedAfter));
        CloneListIteratorTests.assertTrue((boolean)this.originalList.contains(replaced));
        boolean exCaught = false;
        try {
            iterator.remove();
        }
        catch (IllegalStateException illegalStateException) {
            exCaught = true;
        }
        CloneListIteratorTests.assertTrue((String)"IllegalStateException not thrown", (boolean)exCaught);
        while (iterator.hasNext()) {
            Object next = iterator.next();
            if (next.equals(addedAfter)) {
                iterator.add(added);
            }
            if (next.equals(removed)) {
                iterator.remove();
                exCaught = false;
                try {
                    iterator.remove();
                }
                catch (IllegalStateException illegalStateException) {
                    exCaught = true;
                }
                CloneListIteratorTests.assertTrue((String)"IllegalStateException not thrown", (boolean)exCaught);
            }
            if (!next.equals(replaced)) continue;
            iterator.set(replacement);
        }
        CloneListIteratorTests.assertTrue((boolean)this.originalList.contains(added));
        CloneListIteratorTests.assertFalse((boolean)this.originalList.contains(removed));
        CloneListIteratorTests.assertFalse((boolean)this.originalList.contains(replaced));
        CloneListIteratorTests.assertTrue((boolean)this.originalList.contains(replacement));
    }

    private void verifyModifyPrevious(ListIterator iterator) {
        String removed = "three";
        String addedBefore = "five";
        String added = "four and a half";
        String replaced = "seven";
        String replacement = "another seven";
        CloneListIteratorTests.assertTrue((boolean)this.originalList.contains(removed));
        CloneListIteratorTests.assertTrue((boolean)this.originalList.contains(addedBefore));
        CloneListIteratorTests.assertTrue((boolean)this.originalList.contains(replaced));
        while (iterator.hasNext()) {
            iterator.next();
        }
        while (iterator.hasPrevious()) {
            Object previous = iterator.previous();
            if (previous.equals(addedBefore)) {
                iterator.add(added);
            }
            if (previous.equals(removed)) {
                iterator.remove();
                boolean exCaught = false;
                try {
                    iterator.remove();
                }
                catch (IllegalStateException illegalStateException) {
                    exCaught = true;
                }
                CloneListIteratorTests.assertTrue((String)"IllegalStateException not thrown", (boolean)exCaught);
            }
            if (!previous.equals(replaced)) continue;
            iterator.set(replacement);
        }
        CloneListIteratorTests.assertTrue((boolean)this.originalList.contains(added));
        CloneListIteratorTests.assertFalse((boolean)this.originalList.contains(removed));
        CloneListIteratorTests.assertFalse((boolean)this.originalList.contains(replaced));
        CloneListIteratorTests.assertTrue((boolean)this.originalList.contains(replacement));
    }

    private ListIterator buildCloneListIterator() {
        return this.buildCloneListIterator(this.originalList);
    }

    private ListIterator buildCloneListIterator(List list) {
        return new CloneListIterator(list);
    }

    private ListIterator buildNestedListIterator() {
        return this.originalList.listIterator();
    }

    private List buildList() {
        List list = this.buildEmptyList();
        this.populateList(list);
        return list;
    }

    private void populateList(List list) {
        list.add("zero");
        list.add("one");
        list.add("two");
        list.add("three");
        list.add("four");
        list.add("five");
        list.add("six");
        list.add("seven");
        list.add("eight");
        list.add("nine");
    }

    protected List buildEmptyList() {
        return new ArrayList();
    }

    public void testConcurrentAccess() throws Exception {
        CloneIteratorTests.SlowCollection slow = new CloneIteratorTests.SlowCollection();
        this.populateList(slow);
        this.originalList = Collections.synchronizedList(slow);
        this.concurrentProblem = false;
        this.concurrentList = new ArrayList();
        Thread thread = new Thread(this.buildRunnable());
        thread.start();
        while (!slow.hasStartedClone()) {
            Thread.yield();
        }
        this.originalList.add("seventeen");
        while (thread.isAlive()) {
            Thread.yield();
        }
        CloneListIteratorTests.assertFalse((boolean)this.concurrentProblem);
        ArrayList expected = new ArrayList();
        this.populateList(expected);
        CloneListIteratorTests.assertEquals(expected, (Object)this.concurrentList);
    }

    private Runnable buildRunnable() {
        return new Runnable(){

            public void run() {
                CloneListIteratorTests.this.loopWithCloneListIterator();
            }
        };
    }

    void loopWithCloneListIterator() {
        try {
            ListIterator stream = this.buildCloneListIterator();
            while (stream.hasNext()) {
                this.concurrentList.add(stream.next());
            }
        }
        catch (Throwable throwable) {
            this.concurrentProblem = true;
        }
    }
}

