/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.utility.tests.iterators;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.swingui.TestRunner;
import org.eclipse.dali.internal.utility.iterators.PeekableIterator;

public class PeekableIteratorTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        String[] stringArray = new String[2];
        stringArray[0] = "-c";
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.utility.tests.iterators.PeekableIteratorTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[1] = clazz.getName();
        TestRunner.main((String[])stringArray);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.utility.tests.iterators.PeekableIteratorTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public PeekableIteratorTests(String name) {
        super(name);
    }

    public void testUnsupportedOperationException() {
        boolean exCaught = false;
        PeekableIterator stream = this.buildPeekableIterator();
        while (stream.hasNext()) {
            String string = (String)stream.next();
            if (!string.equals("three")) continue;
            try {
                stream.remove();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                exCaught = true;
            }
        }
        PeekableIteratorTests.assertTrue((String)"UnsupportedOperationException not thrown", (boolean)exCaught);
    }

    public void testNoSuchElementException() {
        boolean exCaught = false;
        PeekableIterator stream = this.buildPeekableIterator();
        String string = null;
        while (stream.hasNext()) {
            string = (String)stream.next();
        }
        try {
            string = (String)stream.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        PeekableIteratorTests.assertTrue((String)("NoSuchElementException not thrown: " + string), (boolean)exCaught);
    }

    public void testHasNext() {
        int i = 0;
        PeekableIterator stream = this.buildPeekableIterator();
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        PeekableIteratorTests.assertEquals((int)6, (int)i);
    }

    public void testNext() {
        PeekableIterator stream = this.buildPeekableIterator();
        PeekableIteratorTests.assertEquals((Object)"zero", stream.next());
        PeekableIteratorTests.assertEquals((Object)"one", stream.next());
        PeekableIteratorTests.assertEquals((Object)"two", stream.next());
        PeekableIteratorTests.assertEquals((Object)"three", stream.next());
        PeekableIteratorTests.assertEquals((Object)"four", stream.next());
        PeekableIteratorTests.assertEquals((Object)"five", stream.next());
    }

    public void testPeek() {
        Object next = null;
        PeekableIterator stream = this.buildPeekableIterator();
        while (stream.hasNext()) {
            Object peek = stream.peek();
            PeekableIteratorTests.assertTrue((String)"peek and next are prematurely identical", (peek != next ? 1 : 0) != 0);
            next = stream.next();
            PeekableIteratorTests.assertTrue((String)"peek and next are not identical", (peek == next ? 1 : 0) != 0);
        }
    }

    private PeekableIterator buildPeekableIterator() {
        return this.buildPeekableIterator(this.buildNestedIterator());
    }

    private PeekableIterator buildPeekableIterator(Iterator nestedIterator) {
        return new PeekableIterator(nestedIterator);
    }

    private Iterator buildNestedIterator() {
        ArrayList<String> c = new ArrayList<String>();
        c.add("zero");
        c.add("one");
        c.add("two");
        c.add("three");
        c.add("four");
        c.add("five");
        return c.iterator();
    }
}

