/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.sdk;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.engine.phases.CertificateChecker;
import org.eclipse.equinox.internal.p2.ui.sdk.ProvSDKMessages;
import org.eclipse.equinox.internal.p2.ui.sdk.ProvSDKUIActivator;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class TrustPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public TrustPreferencePage() {
        super(ProvSDKMessages.TrustPreferencePage_title);
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite res = new Composite(parent, 0);
        Label pgpLabel = new Label(res, 64);
        pgpLabel.setLayoutData((Object)new GridData(4, -1, true, false, 2, 1));
        pgpLabel.setText(ProvSDKMessages.TrustPreferencePage_pgpIntro);
        res.setLayout((Layout)new GridLayout(2, false));
        TableViewer viewer = new TableViewer(res);
        viewer.getTable().setHeaderVisible(true);
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        TableViewerColumn idColumn = new TableViewerColumn(viewer, 0);
        idColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return Long.toHexString(((PGPPublicKey)element).getKeyID()).toUpperCase();
            }
        });
        idColumn.getColumn().setWidth(160);
        idColumn.getColumn().setText(ProvSDKMessages.TrustPreferencePage_idColumn);
        TableViewerColumn userColumn = new TableViewerColumn(viewer, 0);
        userColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ArrayList userIds = new ArrayList();
                ((PGPPublicKey)element).getUserIDs().forEachRemaining(userIds::add);
                return String.join((CharSequence)",", userIds);
            }
        });
        userColumn.getColumn().setWidth(400);
        userColumn.getColumn().setText(ProvSDKMessages.TrustPreferencePage_userColumn);
        viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        viewer.setInput((Object)new CertificateChecker(ProvSDKUIActivator.getDefault().getProvisioningAgent()).buildPGPTrustore());
        Composite buttonComposite = this.createVerticalButtonBar(res);
        buttonComposite.setLayoutData((Object)new GridData(-1, 1, false, false));
        Button exportButton = new Button(buttonComposite, 8);
        exportButton.setText(ProvSDKMessages.TrustPreferencePage_export);
        this.setVerticalButtonLayoutData(exportButton);
        exportButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            ISelection sel = viewer.getSelection();
            if (!(sel instanceof IStructuredSelection)) {
                return;
            }
            Object o = ((IStructuredSelection)sel).getFirstElement();
            if (!(o instanceof PGPPublicKey)) {
                return;
            }
            PGPPublicKey key = (PGPPublicKey)o;
            FileDialog dialog = new FileDialog(this.getShell(), 8192);
            dialog.setText(ProvSDKMessages.TrustPreferencePage_fileExportTitle);
            dialog.setFilterExtensions(new String[]{"*.asc"});
            dialog.setFileName(String.valueOf(Long.toHexString(key.getKeyID()).toUpperCase()) + ".asc");
            String path = dialog.open();
            if (path == null) {
                return;
            }
            File destinationFile = new File(path);
            try {
                Throwable throwable = null;
                Object var10_12 = null;
                try (ArmoredOutputStream output = new ArmoredOutputStream((OutputStream)new FileOutputStream(destinationFile));){
                    output.write(key.getEncoded());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException ex) {
                ProvSDKUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.equinox.p2.ui", ex.getMessage(), (Throwable)ex));
            }
        }));
        viewer.addPostSelectionChangedListener(e -> exportButton.setEnabled(!e.getSelection().isEmpty()));
        exportButton.setEnabled(!viewer.getSelection().isEmpty());
        return res;
    }

    private Composite createVerticalButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.initializeDialogUnits((Control)composite);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 5;
        layout.marginHeight = 0;
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        return composite;
    }

    private GridData setVerticalButtonLayoutData(Button button) {
        GridData data = new GridData(256);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        Point minSize = button.computeSize(-1, -1, true);
        data.widthHint = Math.max(widthHint, minSize.x);
        button.setLayoutData((Object)data);
        return data;
    }
}

