/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration.internal.supports;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.tm4e.languageconfiguration.internal.supports.CharacterPair;
import org.eclipse.tm4e.languageconfiguration.internal.supports.Comments;

public class CommentSupport {
    private Comments comments;

    public CommentSupport(Comments comments) {
        this.comments = comments;
    }

    public boolean isInComment(IDocument document, int offset) {
        block3: {
            try {
                if (!this.isInBlockComment(document.get(0, offset))) break block3;
                return true;
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }
        int line = document.getLineOfOffset(offset);
        int lineOffset = document.getLineOffset(line);
        return this.isInLineComment(document.get(lineOffset, offset - lineOffset));
    }

    public String getLineComment() {
        return this.comments.getLineComment();
    }

    public CharacterPair getBlockComment() {
        return this.comments.getBlockComment();
    }

    private boolean isInLineComment(String indexLinePrefix) {
        return indexLinePrefix.indexOf(this.comments.getLineComment()) != -1;
    }

    private boolean isInBlockComment(String indexPrefix) {
        String commentOpen = (String)this.comments.getBlockComment().getKey();
        String commentClose = (String)this.comments.getBlockComment().getValue();
        int index = indexPrefix.indexOf(commentOpen);
        while (index != -1 && index < indexPrefix.length()) {
            int closeIndex = indexPrefix.indexOf(commentClose, index + commentOpen.length());
            if (closeIndex == -1) {
                return true;
            }
            index = indexPrefix.indexOf(commentOpen, closeIndex + commentClose.length());
        }
        return false;
    }
}

