/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal.info;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.info.GitItemState;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCache;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCacheEntry;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffData;
import org.eclipse.egit.core.internal.info.GitItemStateImpl;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.lib.Repository;

public class GitItemStateFactory {
    @NonNull
    public static final GitItemState UNKNOWN_STATE = new GitItemStateImpl();
    @NonNull
    private static final GitItemState IGNORED = new GitItemStateImpl(){

        @Override
        public boolean isIgnored() {
            return true;
        }
    };
    @NonNull
    private static final GitItemStateFactory INSTANCE = new GitItemStateFactory();

    @NonNull
    public static GitItemStateFactory getInstance() {
        return INSTANCE;
    }

    @Nullable
    public IndexDiffData getIndexDiffDataOrNull(@Nullable IResource resource) {
        if (resource == null || resource.getType() == 8 || !ResourceUtil.isSharedWithGit(resource)) {
            return null;
        }
        Repository repository = ResourceUtil.getRepository(resource);
        return this.getIndexDiffDataOrNull(repository);
    }

    @Nullable
    public IndexDiffData getIndexDiffDataOrNull(@Nullable File file) {
        if (file == null) {
            return null;
        }
        File absoluteFile = file.getAbsoluteFile();
        Path path = new Path(absoluteFile.getPath());
        Repository repository = ResourceUtil.getRepository((IPath)path);
        return this.getIndexDiffDataOrNull(repository);
    }

    @Nullable
    private IndexDiffData getIndexDiffDataOrNull(@Nullable Repository repository) {
        if (repository == null) {
            return null;
        }
        if (repository.isBare()) {
            return new IndexDiffData();
        }
        IndexDiffCacheEntry diffCacheEntry = IndexDiffCache.INSTANCE.getIndexDiffCacheEntry(repository);
        if (diffCacheEntry == null) {
            return null;
        }
        return diffCacheEntry.getIndexDiff();
    }

    @NonNull
    public GitItemState get(@Nullable IResource resource) {
        IndexDiffData indexDiffData = this.getIndexDiffDataOrNull(resource);
        if (indexDiffData == null || resource == null) {
            return UNKNOWN_STATE;
        }
        return this.get(indexDiffData, resource);
    }

    @NonNull
    public GitItemState get(@Nullable File file) {
        IndexDiffData indexDiffData = this.getIndexDiffDataOrNull(file);
        if (indexDiffData == null || file == null) {
            return UNKNOWN_STATE;
        }
        return this.get(indexDiffData, file);
    }

    @Nullable
    public GitItemState get(@Nullable Repository repository, @Nullable String gitPath) {
        if (repository == null || gitPath == null) {
            return null;
        }
        IndexDiffCacheEntry cache = IndexDiffCache.INSTANCE.getIndexDiffCacheEntry(repository);
        if (cache == null) {
            return UNKNOWN_STATE;
        }
        IndexDiffData indexDiffData = cache.getIndexDiff();
        if (indexDiffData == null) {
            return UNKNOWN_STATE;
        }
        return this.extractFileProperties(indexDiffData, gitPath);
    }

    @NonNull
    public GitItemState get(@NonNull IndexDiffData indexDiffData, @NonNull IResource resource) {
        IPath path = resource.getLocation();
        if (path != null) {
            return this.get(indexDiffData, new ResourceItem(resource));
        }
        return UNKNOWN_STATE;
    }

    @NonNull
    public GitItemState get(@NonNull IndexDiffData indexDiffData, @NonNull File file) {
        return this.get(indexDiffData, new FileItem(file));
    }

    @NonNull
    private GitItemState get(@NonNull IndexDiffData indexDiffData, @NonNull FileSystemItem file) {
        IPath path = file.getAbsolutePath();
        if (path == null) {
            return UNKNOWN_STATE;
        }
        Repository repository = file.getRepository();
        if (repository == null || repository.isBare()) {
            return UNKNOWN_STATE;
        }
        File workTree = repository.getWorkTree();
        String repoRelativePath = path.makeRelativeTo((IPath)new Path(workTree.getAbsolutePath())).toString();
        if (repoRelativePath.equals(path.toString())) {
            return UNKNOWN_STATE;
        }
        if (file.isContainer()) {
            if (!repoRelativePath.endsWith("/")) {
                repoRelativePath = String.valueOf(repoRelativePath) + '/';
            }
            if (ResourceUtil.isSymbolicLink(repository, repoRelativePath)) {
                return this.extractFileProperties(indexDiffData, repoRelativePath);
            }
            return this.extractContainerProperties(indexDiffData, repoRelativePath, file);
        }
        return this.extractFileProperties(indexDiffData, repoRelativePath);
    }

    @NonNull
    private GitItemState extractFileProperties(@NonNull IndexDiffData indexDiffData, @NonNull String repoRelativePath) {
        boolean ignored;
        Set<String> ignoredFiles = indexDiffData.getIgnoredNotInIndex();
        boolean bl = ignored = ignoredFiles.contains(repoRelativePath) || this.containsPrefixPath(ignoredFiles, repoRelativePath);
        if (ignored) {
            return IGNORED;
        }
        GitItemStateImpl state = new GitItemStateImpl();
        Set<String> untracked = indexDiffData.getUntracked();
        state.setTracked(!untracked.contains(repoRelativePath));
        Set<String> added = indexDiffData.getAdded();
        Set<String> removed = indexDiffData.getRemoved();
        Set<String> changed = indexDiffData.getChanged();
        if (added.contains(repoRelativePath)) {
            state.setStagingState(GitItemState.StagingState.ADDED);
        } else if (removed.contains(repoRelativePath)) {
            state.setStagingState(GitItemState.StagingState.REMOVED);
        } else if (changed.contains(repoRelativePath)) {
            state.setStagingState(GitItemState.StagingState.MODIFIED);
        } else {
            state.setStagingState(GitItemState.StagingState.NOT_STAGED);
        }
        Set<String> conflicting = indexDiffData.getConflicting();
        state.setConflicts(conflicting.contains(repoRelativePath));
        if (state.hasConflicts()) {
            state.setConflictType(indexDiffData.getConflictStates().get(repoRelativePath));
        }
        Set<String> modified = indexDiffData.getModified();
        state.setDirty(modified.contains(repoRelativePath));
        Set<String> missing = indexDiffData.getMissing();
        state.setMissing(missing.contains(repoRelativePath));
        Set<String> assumeUnchanged = indexDiffData.getAssumeUnchanged();
        state.setAssumeUnchanged(assumeUnchanged.contains(repoRelativePath));
        return state;
    }

    @NonNull
    private GitItemState extractContainerProperties(@NonNull IndexDiffData indexDiffData, @NonNull String repoRelativePath, @NonNull FileSystemItem directory) {
        boolean ignored;
        Set<String> ignoredFiles = indexDiffData.getIgnoredNotInIndex();
        boolean bl = ignored = this.containsPrefixPath(ignoredFiles, repoRelativePath) || !directory.hasContainerAnyFiles();
        if (ignored) {
            return IGNORED;
        }
        GitItemStateImpl state = new GitItemStateImpl();
        Set<String> untrackedFolders = indexDiffData.getUntrackedFolders();
        state.setTracked(!this.containsPrefixPath(untrackedFolders, repoRelativePath));
        HashSet<String> changed = new HashSet<String>(indexDiffData.getChanged());
        changed.addAll(indexDiffData.getAdded());
        changed.addAll(indexDiffData.getRemoved());
        if (this.containsPrefix(changed, repoRelativePath)) {
            state.setStagingState(GitItemState.StagingState.MODIFIED);
        } else {
            state.setStagingState(GitItemState.StagingState.NOT_STAGED);
        }
        Set<String> conflicting = indexDiffData.getConflicting();
        state.setConflicts(this.containsPrefix(conflicting, repoRelativePath));
        Set<String> modified = indexDiffData.getModified();
        Set<String> untracked = indexDiffData.getUntracked();
        Set<String> missing = indexDiffData.getMissing();
        state.setDirty(this.containsPrefix(modified, repoRelativePath) || this.containsPrefix(untracked, repoRelativePath) || this.containsPrefix(missing, repoRelativePath));
        return state;
    }

    private boolean containsPrefix(Set<String> collection, String prefix) {
        if (prefix.length() == 1 && !collection.isEmpty()) {
            return true;
        }
        for (String path : collection) {
            if (!path.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    private boolean containsPrefixPath(Set<String> collection, String path) {
        for (String entry : collection) {
            if (!(entry.endsWith("/") ? path.startsWith(entry) : GitItemStateFactory.startsWith2(path, entry, "/"))) continue;
            return true;
        }
        return false;
    }

    private static boolean startsWith2(String s, String prefix1, String prefix2) {
        return s.startsWith(prefix1) && s.startsWith(prefix2, prefix1.length());
    }

    private static class FileItem
    implements FileSystemItem {
        @NonNull
        private final File file;

        public FileItem(@NonNull File file) {
            this.file = file;
        }

        @Override
        @NonNull
        public IPath getAbsolutePath() {
            return new Path(this.file.getAbsolutePath());
        }

        @Override
        public Repository getRepository() {
            return ResourceUtil.getRepository(this.getAbsolutePath());
        }

        @Override
        public boolean isContainer() {
            return this.file.isDirectory();
        }

        @Override
        public boolean hasContainerAnyFiles() {
            if (!this.isContainer()) {
                throw new IllegalArgumentException("Container expected");
            }
            try {
                final boolean[] result = new boolean[1];
                final java.nio.file.Path dotGit = Paths.get(".git", new String[0]);
                Files.walkFileTree(this.file.toPath(), (FileVisitor<? super java.nio.file.Path>)new FileVisitor<java.nio.file.Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(java.nio.file.Path dir, BasicFileAttributes attrs) throws IOException {
                        if (dotGit.equals(dir.getFileName())) {
                            return FileVisitResult.SKIP_SUBTREE;
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(java.nio.file.Path path, BasicFileAttributes attrs) throws IOException {
                        if (!attrs.isDirectory()) {
                            result[0] = true;
                            return FileVisitResult.TERMINATE;
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFileFailed(java.nio.file.Path path, IOException exc) throws IOException {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(java.nio.file.Path dir, IOException exc) throws IOException {
                        return FileVisitResult.CONTINUE;
                    }
                });
                return result[0];
            }
            catch (IOException e) {
                return true;
            }
        }
    }

    private static interface FileSystemItem {
        public boolean hasContainerAnyFiles();

        public boolean isContainer();

        @Nullable
        public IPath getAbsolutePath();

        @Nullable
        public Repository getRepository();
    }

    private static class ResourceItem
    implements FileSystemItem {
        @NonNull
        private final IResource resource;

        public ResourceItem(@NonNull IResource resource) {
            this.resource = resource;
        }

        @Override
        @Nullable
        public IPath getAbsolutePath() {
            return this.resource.getLocation();
        }

        @Override
        public Repository getRepository() {
            return ResourceUtil.getRepository(this.resource);
        }

        @Override
        public boolean isContainer() {
            return this.isContainer(this.resource);
        }

        @Override
        public boolean hasContainerAnyFiles() {
            return this.containsFiles(this.resource);
        }

        private boolean isContainer(IResource rsc) {
            int type = rsc.getType();
            return type == 2 || type == 4 || type == 8;
        }

        private boolean containsFiles(IResource rsc) {
            if (rsc instanceof IContainer) {
                IContainer container = (IContainer)rsc;
                try {
                    return this.anyFile(container.members());
                }
                catch (CoreException e) {
                    return true;
                }
            }
            throw new IllegalArgumentException("Expected a container resource.");
        }

        private boolean anyFile(IResource[] members) {
            IResource[] iResourceArray = members;
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource member = iResourceArray[n2];
                if (member.getType() == 1) {
                    return true;
                }
                if (this.isContainer(member) && this.containsFiles(member)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

