/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.propertypages;

import java.util.ResourceBundle;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SystemBooleanFieldEditor
extends BooleanFieldEditor {
    private Button button;
    private String tip;
    private Composite parent;

    protected SystemBooleanFieldEditor() {
    }

    public SystemBooleanFieldEditor(String name, String labelText, int style, Composite parent) {
        super(name, labelText, style, parent);
        this.parent = parent;
    }

    public SystemBooleanFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
        this.parent = parent;
    }

    public SystemBooleanFieldEditor(String name, ResourceBundle rb, String labelKey, Composite parent) {
        super(name, rb.getString(String.valueOf(labelKey) + "label"), parent);
        this.setToolTipText(rb.getString(String.valueOf(labelKey) + "tooltip"));
        this.parent = parent;
    }

    protected Button getChangeControl(Composite parent) {
        this.button = super.getChangeControl(parent);
        if (this.tip != null) {
            this.button.setToolTipText(this.tip);
        }
        return this.button;
    }

    public void setToolTipText(String tip) {
        if (this.button != null) {
            this.button.setToolTipText(tip);
        }
        this.tip = tip;
    }

    public String getToolTipText() {
        return this.tip;
    }

    public void setHelp(String helpID) {
        if (this.button != null) {
            SystemWidgetHelpers.setHelp((Control)this.button, helpID);
        }
    }

    public void setEnabled(boolean enablement) {
        this.getChangeControl(this.parent).setEnabled(enablement);
    }
}

