/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration.internal;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.tm4e.core.model.TMToken;
import org.eclipse.tm4e.languageconfiguration.internal.model.AutoClosingPairConditional;
import org.eclipse.tm4e.languageconfiguration.internal.model.CompleteEnterAction;
import org.eclipse.tm4e.languageconfiguration.internal.registry.LanguageConfigurationRegistryManager;
import org.eclipse.tm4e.languageconfiguration.internal.utils.TextUtils;
import org.eclipse.tm4e.languageconfiguration.internal.utils.UI;
import org.eclipse.tm4e.ui.internal.model.TMDocumentModel;
import org.eclipse.tm4e.ui.internal.model.TMModelManager;
import org.eclipse.tm4e.ui.internal.utils.ContentTypeHelper;
import org.eclipse.tm4e.ui.internal.utils.ContentTypeInfo;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.ITextEditor;

public class LanguageConfigurationAutoEditStrategy
implements IAutoEditStrategy {
    private @Nullable IDocument document;
    private IContentType @Nullable [] contentTypes;
    private @Nullable ITextViewer viewer;

    public void customizeDocumentCommand(@Nullable IDocument document, @Nullable DocumentCommand command) {
        if (document == null || command == null) {
            return;
        }
        IContentType[] contentTypes = this.findContentTypes(document);
        if (contentTypes == null || command.text.isEmpty()) {
            return;
        }
        this.installViewer();
        if (TextUtils.isEnter(document, command)) {
            this.onEnter(document, command, UI.getActiveTextEditor());
            return;
        }
        LanguageConfigurationRegistryManager registry = LanguageConfigurationRegistryManager.getInstance();
        IContentType[] iContentTypeArray = contentTypes;
        int n = contentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IContentType contentType2 = iContentTypeArray[n2];
            AutoClosingPairConditional autoClosingPair = registry.getAutoClosingPair(document.get(), command.offset, command.text, contentType2);
            if (autoClosingPair != null) {
                command.caretOffset = command.offset + command.text.length();
                command.shiftsCaret = false;
                if (command.text.equals(autoClosingPair.open) && LanguageConfigurationAutoEditStrategy.isFollowedBy(document, command.offset, autoClosingPair.open)) {
                    command.text = "";
                } else if (command.text.equals(autoClosingPair.close) && LanguageConfigurationAutoEditStrategy.isFollowedBy(document, command.offset, autoClosingPair.close)) {
                    command.text = "";
                } else if (this.isAutoClosingAllowed(document, contentType2, command.offset, autoClosingPair)) {
                    command.text = String.valueOf(command.text) + autoClosingPair.close;
                }
                return;
            }
            ++n2;
        }
        Arrays.stream(contentTypes).flatMap(contentType -> registry.getEnabledAutoClosingPairs((IContentType)contentType).stream()).map(cp -> cp.close).filter(command.text::equals).filter(closing -> LanguageConfigurationAutoEditStrategy.isFollowedBy(document, documentCommand.offset, closing)).findFirst().ifPresent(closing -> {
            documentCommand.caretOffset = documentCommand.offset + documentCommand.text.length();
            documentCommand.shiftsCaret = false;
            documentCommand.text = "";
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isAutoClosingAllowed(IDocument document, IContentType contentType, int offset, AutoClosingPairConditional pair) {
        try {
            LanguageConfigurationRegistryManager registry;
            char ch = document.getChar(offset);
            if (!Character.isWhitespace(ch) && (registry = LanguageConfigurationRegistryManager.getInstance()).getAutoCloseBefore(contentType).indexOf(ch) < 0) {
                return false;
            }
        }
        catch (Exception ch) {
            // empty catch block
        }
        if (pair.notIn.isEmpty()) return true;
        TMDocumentModel docModel = TMModelManager.INSTANCE.connect(document);
        try {
            String notIn;
            int lineIndex = document.getLineOfOffset(offset);
            List tokens = docModel.getLineTokens(lineIndex);
            if (tokens == null) return true;
            int lineCharOffset = offset - document.getLineOffset(lineIndex) - 1;
            TMToken tokenAtOffset = null;
            for (TMToken token : tokens) {
                if (token.startIndex > lineCharOffset) break;
                tokenAtOffset = token;
            }
            if (tokenAtOffset == null) return true;
            Iterator<Object> iterator = pair.notIn.iterator();
            do {
                if (iterator.hasNext()) continue;
                return true;
            } while (!tokenAtOffset.type.contains(notIn = (String)iterator.next()));
            return false;
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return true;
    }

    private static boolean isFollowedBy(IDocument document, int offset, String value) {
        int i = 0;
        while (i < value.length()) {
            if (document.getLength() <= offset) {
                return false;
            }
            try {
                if (document.getChar(offset) != value.charAt(i)) {
                    return false;
                }
            }
            catch (BadLocationException e) {
                return false;
            }
            ++offset;
            ++i;
        }
        return true;
    }

    private void onEnter(IDocument document, DocumentCommand command, @Nullable ITextEditor editor) {
        IContentType[] contentTypes = this.contentTypes;
        if (contentTypes != null) {
            LanguageConfigurationRegistryManager registry = LanguageConfigurationRegistryManager.getInstance();
            IContentType[] iContentTypeArray = contentTypes;
            int n = contentTypes.length;
            int n2 = 0;
            while (n2 < n) {
                CompleteEnterAction enterAction;
                IContentType contentType = iContentTypeArray[n2];
                if (registry.shouldEnterAction(document, command.offset, contentType) && (enterAction = registry.getEnterAction(document, command.offset, contentType)) != null) {
                    String delim = command.text;
                    switch (enterAction.indentAction) {
                        case None: {
                            String typeText;
                            String increasedIndent = this.normalizeIndentation(String.valueOf(enterAction.indentation) + enterAction.appendText, editor);
                            command.text = typeText = String.valueOf(delim) + increasedIndent;
                            command.shiftsCaret = false;
                            command.caretOffset = command.offset + (String.valueOf(delim) + increasedIndent).length();
                            break;
                        }
                        case Indent: {
                            String typeText;
                            String increasedIndent = this.normalizeIndentation(String.valueOf(enterAction.indentation) + enterAction.appendText, editor);
                            command.text = typeText = String.valueOf(delim) + increasedIndent;
                            command.shiftsCaret = false;
                            command.caretOffset = command.offset + (String.valueOf(delim) + increasedIndent).length();
                            break;
                        }
                        case IndentOutdent: {
                            String typeText;
                            String normalIndent = this.normalizeIndentation(enterAction.indentation, editor);
                            String increasedIndent = this.normalizeIndentation(String.valueOf(enterAction.indentation) + enterAction.appendText, editor);
                            command.text = typeText = String.valueOf(delim) + increasedIndent + delim + normalIndent;
                            command.shiftsCaret = false;
                            command.caretOffset = command.offset + (String.valueOf(delim) + increasedIndent).length();
                            break;
                        }
                        case Outdent: {
                            String indentation = TextUtils.getIndentationFromWhitespace(enterAction.indentation, this.getTabSize(editor), this.isInsertSpaces(editor));
                            String outdentedText = this.outdentString(this.normalizeIndentation(String.valueOf(indentation) + enterAction.appendText, editor), editor);
                            command.text = String.valueOf(delim) + outdentedText;
                            command.shiftsCaret = false;
                            command.caretOffset = command.offset + (String.valueOf(delim) + outdentedText).length();
                        }
                    }
                    return;
                }
                ++n2;
            }
        }
        new DefaultIndentLineAutoEditStrategy().customizeDocumentCommand(document, command);
    }

    private IContentType @Nullable [] findContentTypes(IDocument document) {
        if (this.document != null && this.document.equals(document)) {
            return this.contentTypes;
        }
        try {
            ContentTypeInfo info = ContentTypeHelper.findContentTypes((IDocument)document);
            this.contentTypes = info == null ? null : info.getContentTypes();
            this.document = document;
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return this.contentTypes;
    }

    private String outdentString(String str, @Nullable ITextEditor editor) {
        if (str.startsWith("\t")) {
            return str.substring(1);
        }
        if (this.isInsertSpaces(editor)) {
            char[] chars = new char[this.getTabSize(editor)];
            Arrays.fill(chars, ' ');
            String spaces = new String(chars);
            if (str.startsWith(spaces)) {
                return str.substring(spaces.length());
            }
        }
        return str;
    }

    private String normalizeIndentation(String str, @Nullable ITextEditor editor) {
        int tabSize = this.getTabSize(editor);
        boolean insertSpaces = this.isInsertSpaces(editor);
        return TextUtils.normalizeIndentation(str, tabSize, insertSpaces);
    }

    private int getTabSize(@Nullable ITextEditor editor) {
        String name = "tabWidth";
        return this.getPreferenceStoreFor("tabWidth", editor).getInt("tabWidth");
    }

    private boolean isInsertSpaces(@Nullable ITextEditor editor) {
        String name = "spacesForTabs";
        return this.getPreferenceStoreFor("spacesForTabs", editor).getBoolean("spacesForTabs");
    }

    private IPreferenceStore getPreferenceStoreFor(String name, @Nullable ITextEditor editor) {
        IPreferenceStore editorPreferenceStore;
        IPreferenceStore iPreferenceStore = editorPreferenceStore = editor != null ? (IPreferenceStore)editor.getAdapter(IPreferenceStore.class) : null;
        if (editorPreferenceStore != null && editorPreferenceStore.contains(name)) {
            return editorPreferenceStore;
        }
        return EditorsUI.getPreferenceStore();
    }

    private void installViewer() {
        if (this.viewer == null) {
            this.viewer = UI.getActiveTextViewer();
        }
    }
}

