/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.core;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.rse.core.IRSECoreRegistry;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.PasswordPersistenceManager;
import org.eclipse.rse.core.RSECorePlugin;

public class RSEPreferencesManager {
    private static final String ST_ENABLED = "systemType.enabled";
    private static final String ST_DEFAULT_USERID = "systemType.defaultUserId";
    private static final boolean DEFAULT_USE_DEFERRED_QUERIES = true;
    private static final String DEFAULT_TEAMPROFILE = "Team";
    private static final String DEFAULT_ACTIVEUSERPROFILES = "Team";

    private static Hashtable getUserIds() {
        Preferences store = RSECorePlugin.getDefault().getPluginPreferences();
        Hashtable userIds = null;
        String value = store.getString("useridperkey");
        userIds = value != null ? RSEPreferencesManager.parseString(value) : new Hashtable();
        return userIds;
    }

    private static void setUserIds(Hashtable userIds) {
        Preferences store = RSECorePlugin.getDefault().getPluginPreferences();
        String userIdsString = RSEPreferencesManager.makeString(userIds);
        store.setValue("useridperkey", userIdsString);
        RSEPreferencesManager.savePreferences();
    }

    public static String getUserId(String key) {
        String uid = null;
        Hashtable userIds = RSEPreferencesManager.getUserIds();
        uid = (String)userIds.get(key);
        return uid;
    }

    public static void clearUserId(String key) {
        Hashtable userIds = RSEPreferencesManager.getUserIds();
        if (userIds.containsKey(key)) {
            userIds.remove(key);
            RSEPreferencesManager.setUserIds(userIds);
        }
    }

    public static void setUserId(String key, String userId) {
        Hashtable userIds;
        String storedUserId;
        if (!(key == null || userId == null || (storedUserId = (String)(userIds = RSEPreferencesManager.getUserIds()).get(key)) != null && storedUserId.equals(userId))) {
            userIds.put(key, userId);
            RSEPreferencesManager.setUserIds(userIds);
        }
    }

    public static String getDefaultUserId(IRSESystemType systemType) {
        String key;
        Preferences store = RSECorePlugin.getDefault().getPluginPreferences();
        if (!store.contains(key = RSEPreferencesManager.getSystemTypePreferencesKey(systemType, ST_DEFAULT_USERID))) {
            store.setDefault(key, System.getProperty("user.name"));
        }
        String result = store.getString(key);
        return result;
    }

    public static void setDefaultUserId(IRSESystemType systemType, String userId) {
        Preferences store = RSECorePlugin.getDefault().getPluginPreferences();
        String key = RSEPreferencesManager.getSystemTypePreferencesKey(systemType, ST_DEFAULT_USERID);
        store.setValue(key, userId);
        RSEPreferencesManager.savePreferences();
    }

    public static String getSystemTypeValues() {
        IRSESystemType[] systemTypes = RSECorePlugin.getTheCoreRegistry().getSystemTypes();
        StringBuffer buffer = new StringBuffer(100);
        int i = 0;
        while (i < systemTypes.length) {
            IRSESystemType systemType = systemTypes[i];
            buffer.append(systemType.getId());
            buffer.append('=');
            buffer.append(RSEPreferencesManager.getIsSystemTypeEnabled(systemType));
            buffer.append('+');
            buffer.append(RSEPreferencesManager.getDefaultUserId(systemType));
            buffer.append(';');
            ++i;
        }
        String result = buffer.toString();
        return result;
    }

    public static void setSystemTypeValues(String systemTypeValues) {
        IRSECoreRegistry registry = RSECorePlugin.getTheCoreRegistry();
        Hashtable table = RSEPreferencesManager.parseString(systemTypeValues);
        Enumeration e = table.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String compoundValue = (String)table.get(key);
            String[] values = compoundValue.split("\\+");
            String isEnabled = values[0];
            String defaultUserId = values[1];
            IRSESystemType systemType = registry.getSystemTypeById(key);
            RSEPreferencesManager.setIsSystemTypeEnabled(systemType, isEnabled.equals("true"));
            RSEPreferencesManager.setDefaultUserId(systemType, defaultUserId);
        }
    }

    public static void setIsSystemTypeEnabled(IRSESystemType systemType, boolean isEnabled) {
        String key;
        Preferences store = RSECorePlugin.getDefault().getPluginPreferences();
        if (!store.contains(key = RSEPreferencesManager.getSystemTypePreferencesKey(systemType, ST_ENABLED))) {
            store.setDefault(key, true);
        }
        store.setValue(key, isEnabled);
        RSEPreferencesManager.savePreferences();
    }

    public static boolean getIsSystemTypeEnabled(IRSESystemType systemType) {
        String key;
        Preferences store = RSECorePlugin.getDefault().getPluginPreferences();
        if (!store.contains(key = RSEPreferencesManager.getSystemTypePreferencesKey(systemType, ST_ENABLED))) {
            store.setDefault(key, true);
        }
        boolean result = store.getBoolean(key);
        return result;
    }

    private static String getSystemTypePreferencesKey(IRSESystemType systemType, String preference) {
        String key = String.valueOf(systemType.getId()) + "." + preference;
        return key;
    }

    public static String[] getActiveProfiles() {
        Preferences store = RSECorePlugin.getDefault().getPluginPreferences();
        String value = store.getString("activeuserprofiles");
        String[] result = RSEPreferencesManager.parseStrings(value);
        return result;
    }

    private static void setActiveProfiles(String[] newProfileNames) {
        Preferences store = RSECorePlugin.getDefault().getPluginPreferences();
        store.setValue("activeuserprofiles", RSEPreferencesManager.makeString(newProfileNames));
        RSEPreferencesManager.savePreferences();
    }

    public static void addActiveProfile(String newName) {
        TreeSet<String> names = new TreeSet<String>(Arrays.asList(RSEPreferencesManager.getActiveProfiles()));
        names.add(newName);
        String[] newNames = new String[names.size()];
        names.toArray(newNames);
        RSEPreferencesManager.setActiveProfiles(newNames);
        RSEPreferencesManager.savePreferences();
    }

    public static void deleteActiveProfile(String oldName) {
        String[] names = RSEPreferencesManager.getActiveProfiles();
        int matchPos = -1;
        int idx = 0;
        while (matchPos == -1 && idx < names.length) {
            if (names[idx].equalsIgnoreCase(oldName)) {
                matchPos = idx;
                names[idx] = null;
            }
            ++idx;
        }
        if (matchPos >= 0) {
            RSEPreferencesManager.setActiveProfiles(names);
            RSEPreferencesManager.savePreferences();
        }
    }

    public static int getActiveProfilePosition(String profileName) {
        String[] names = RSEPreferencesManager.getActiveProfiles();
        int matchPos = -1;
        int idx = 0;
        while (matchPos == -1 && idx < names.length) {
            if (names[idx].equalsIgnoreCase(profileName)) {
                matchPos = idx;
            }
            ++idx;
        }
        return matchPos;
    }

    public static void renameActiveProfile(String oldName, String newName) {
        String[] names = RSEPreferencesManager.getActiveProfiles();
        int matchPos = -1;
        int idx = 0;
        while (matchPos == -1 && idx < names.length) {
            if (names[idx].equalsIgnoreCase(oldName)) {
                matchPos = idx;
                names[idx] = newName;
            }
            ++idx;
        }
        if (matchPos >= 0) {
            RSEPreferencesManager.setActiveProfiles(names);
            RSEPreferencesManager.savePreferences();
        }
    }

    public static void initDefaults() {
        String defaultProfileNames = "Team";
        String userProfileName = RSEPreferencesManager.getDefaultPrivateSystemProfileName();
        defaultProfileNames = String.valueOf(defaultProfileNames) + ";" + userProfileName;
        Preferences store = RSECorePlugin.getDefault().getPluginPreferences();
        store.setDefault("activeuserprofiles", defaultProfileNames);
        store.setDefault("useDeferredQueries", true);
        RSEPreferencesManager.savePreferences();
    }

    private static void savePreferences() {
        RSECorePlugin.getDefault().savePluginPreferences();
    }

    public static String getDefaultPrivateSystemProfileName() {
        int i;
        String name = RSECorePlugin.getLocalMachineName();
        if (name != null && (i = name.indexOf(46)) > 0) {
            name = name.substring(0, i);
        }
        if (name == null) {
            name = System.getProperty("user.name");
        }
        return name;
    }

    public static String getDefaultTeamProfileName() {
        String name = "Team";
        return name;
    }

    private static String makeString(Hashtable table) {
        Enumeration keys = table.keys();
        StringBuffer sb = new StringBuffer(20 * table.size());
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = (String)table.get(key);
            if (value == null || value.length() <= 0) continue;
            sb.append(key);
            sb.append('=');
            sb.append(value);
            sb.append(';');
        }
        return sb.toString();
    }

    private static String makeString(String[] values) {
        StringBuffer allValues = new StringBuffer(20 * values.length);
        int idx = 0;
        while (idx < values.length) {
            if (values[idx] != null) {
                if (idx > 0) {
                    allValues = allValues.append(';');
                }
                allValues.append(values[idx]);
            }
            ++idx;
        }
        return allValues.toString();
    }

    private static String[] parseStrings(String allvalues) {
        if (allvalues == null) {
            return new String[0];
        }
        String[] tokens = allvalues.split(";");
        return tokens;
    }

    private static Hashtable parseString(String allValues) {
        Hashtable<String, String> keyValues = new Hashtable<String, String>(10);
        if (allValues != null) {
            StringTokenizer tokens = new StringTokenizer(allValues, "=;");
            int count = 0;
            String token1 = null;
            String token2 = null;
            while (tokens.hasMoreTokens()) {
                if (++count % 2 == 0) {
                    token2 = tokens.nextToken();
                    keyValues.put(token1, token2);
                    continue;
                }
                token1 = tokens.nextToken();
            }
        }
        return keyValues;
    }

    public static boolean getCreateLocalConnection() {
        Preferences prefs = RSECorePlugin.getDefault().getPluginPreferences();
        boolean result = prefs.getBoolean("CREATE_LOCAL_CONNECTION");
        return result;
    }

    public static int setDenyPasswordSave(IRSESystemType systemType, String hostAddress, boolean deny) {
        int result = 0;
        Preferences preferences = RSECorePlugin.getDefault().getPluginPreferences();
        String preferenceName = RSEPreferencesManager.getPasswordSavePreferenceName(systemType, hostAddress);
        preferences.setValue(preferenceName, deny);
        if (deny) {
            result = PasswordPersistenceManager.getInstance().remove(systemType, hostAddress);
            result += PasswordPersistenceManager.getInstance().remove(PasswordPersistenceManager.DEFAULT_SYSTEM_TYPE, hostAddress);
        }
        RSEPreferencesManager.savePreferences();
        return result;
    }

    public static boolean getDenyPasswordSave(IRSESystemType systemType, String hostAddress) {
        Preferences preferences = RSECorePlugin.getDefault().getPluginPreferences();
        String preferenceName = RSEPreferencesManager.getPasswordSavePreferenceName(systemType, hostAddress);
        boolean result = preferences.getBoolean(preferenceName);
        return result;
    }

    private static String getPasswordSavePreferenceName(IRSESystemType systemType, String hostAddress) {
        StringBuffer b = new StringBuffer(100);
        b.append(systemType.getId());
        b.append("___");
        b.append(hostAddress.toUpperCase(Locale.US));
        b.append("___DENY_PASSWORD_SAVE");
        String preferenceName = b.toString();
        return preferenceName;
    }

    private RSEPreferencesManager() {
    }
}

