/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.servlet;

import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.core.runtime.IPath;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.util.ProductPreferences;
import org.eclipse.help.internal.webapp.data.CssUtil;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.eclipse.help.internal.webapp.servlet.FilterHTMLHeadAndBodyOutputStream;
import org.eclipse.help.internal.webapp.servlet.FilterUtils;
import org.eclipse.help.webapp.IFilter;

public class InjectionFilter
implements IFilter {
    private static final String disabledBook3 = "\n<script type=\"text/javascript\" src=\"";
    private static final String disabledBook4 = "livehelp.js\"> </script>";
    private static final String TOPIC_CSS = "topic_css";
    private static final String NAV_CSS = "nav_css";
    private static final String NARROW_CSS = "narrow_css";
    private static final String DISABLED_CSS = "disabled_css";
    private static final String REMOTE_CSS = "remote_css";
    private boolean isRemote;

    public InjectionFilter(boolean isRemote) {
        this.isRemote = isRemote;
    }

    @Override
    public OutputStream filter(HttpServletRequest req, OutputStream out) {
        boolean enabled;
        boolean isUnfiltered = ProductPreferences.useEnablementFilters();
        boolean addNarrow = false;
        boolean addDisabled = false;
        boolean needsLiveHelp = false;
        String uri = req.getRequestURI();
        boolean isNav = "/nav".equals(req.getServletPath());
        if (uri == null || !uri.endsWith("html") && !uri.endsWith("htm") && !isNav) {
            return out;
        }
        if (UrlUtil.isBot(req)) {
            return out;
        }
        String pathInfo = req.getPathInfo();
        if (pathInfo == null) {
            return out;
        }
        ArrayList<String> cssIncludes = new ArrayList<String>();
        if (isNav) {
            CssUtil.addCssFiles(NAV_CSS, cssIncludes);
        } else {
            CssUtil.addCssFiles(TOPIC_CSS, cssIncludes);
        }
        if (this.isRemote) {
            CssUtil.addCssFiles(REMOTE_CSS, cssIncludes);
        }
        boolean bl = enabled = isUnfiltered || isNav || HelpBasePlugin.getActivitySupport().isRoleEnabled(pathInfo) || this.isRemote;
        if ("/ntopic".equals(req.getServletPath())) {
            addNarrow = true;
            CssUtil.addCssFiles(NARROW_CSS, cssIncludes);
        }
        if (!enabled) {
            addDisabled = true;
            CssUtil.addCssFiles(DISABLED_CSS, cssIncludes);
        }
        boolean bl2 = needsLiveHelp = !enabled && HelpBasePlugin.getActivitySupport().getDocumentMessageUsesLiveHelp(addNarrow);
        if (cssIncludes.isEmpty() && !addDisabled) {
            return out;
        }
        IPath path = IPath.fromOSString((String)pathInfo);
        int upLevels = path.segmentCount() - 1;
        String relativePath = FilterUtils.getRelativePathPrefix(req);
        StringBuilder script = new StringBuilder();
        StringBuilder disabledContent = new StringBuilder();
        script.append(CssUtil.createCssIncludes(cssIncludes, FilterUtils.getRelativePathPrefix(req)));
        if (addDisabled) {
            if (needsLiveHelp) {
                script.append(disabledBook3);
                script.append(relativePath);
                script.append("content/org.eclipse.help/");
                script.append(disabledBook4);
            }
            this.appendDisabled(disabledContent, upLevels, addNarrow, relativePath);
        }
        return new FilterHTMLHeadAndBodyOutputStream(out, script.toString().getBytes(StandardCharsets.US_ASCII), addDisabled ? disabledContent.toString() : null);
    }

    private void appendDisabled(StringBuilder buff, int nsteps, boolean narrow, String relativePath) {
        String message = HelpBasePlugin.getActivitySupport().getDocumentMessage(narrow);
        if (message == null) {
            return;
        }
        buff.append("<div id=\"help-disabledTopic\">");
        buff.append("<img src=\"");
        buff.append(relativePath);
        buff.append("content/org.eclipse.help.webapp/");
        buff.append("advanced/images/e_show_all.svg\" border=\"0\" align=\"bottom\">&nbsp;");
        buff.append(message);
        buff.append("<br><hr></div>");
    }
}

