/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.attributes;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.jgit.api.errors.FilterFailedException;
import org.eclipse.jgit.attributes.FilterCommand;
import org.eclipse.jgit.attributes.FilterCommandRegistry;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.RawParseUtils;
import org.eclipse.jgit.util.TemporaryBuffer;

public class Filtering {
    private static final int MAX_EXCEPTION_TEXT_SIZE = 10240;

    public static InputStream filter(Repository repository, String path, InputStream raw, String command) throws IOException {
        if (command == null || command.isEmpty()) {
            return raw;
        }
        if (FilterCommandRegistry.isRegistered((String)command)) {
            return Filtering.runInternalFilter(repository, raw, command);
        }
        return Filtering.runExternalFilter(repository, path, raw, command);
    }

    private static InputStream runExternalFilter(Repository repository, String path, InputStream raw, String command) throws IOException {
        int rc;
        FS.ExecutionResult result;
        FS fs = repository.getFS();
        ProcessBuilder filterProcessBuilder = fs.runInShell(command, new String[0]);
        filterProcessBuilder.directory(!repository.isBare() ? repository.getWorkTree() : repository.getDirectory());
        filterProcessBuilder.environment().put("GIT_DIR", repository.getDirectory().getAbsolutePath());
        try {
            result = fs.execute(filterProcessBuilder, raw);
            rc = result.getRc();
        }
        catch (IOException | InterruptedException e) {
            throw new IOException((Throwable)new FilterFailedException(e, command, path));
        }
        if (rc != 0) {
            throw new IOException((Throwable)new FilterFailedException(rc, command, path, result.getStdout().toByteArray(10240), RawParseUtils.decode((byte[])result.getStderr().toByteArray(10240))));
        }
        return result.getStdout().openInputStream();
    }

    private static InputStream runInternalFilter(Repository repository, InputStream raw, String command) throws IOException {
        TemporaryBuffer.LocalFile buffer = new TemporaryBuffer.LocalFile(null);
        FilterCommand filter = FilterCommandRegistry.createFilterCommand((String)command, (Repository)repository, (InputStream)raw, (OutputStream)buffer);
        while (filter.run() != -1) {
        }
        return buffer.openInputStream();
    }
}

