/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.internal;

import java.util.Properties;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.intro.IIntroSite;
import org.eclipse.ui.intro.config.IIntroAction;

public class LaunchUpdateIntroAction
implements IIntroAction {
    private static final String COMMAND_P2 = "org.eclipse.equinox.p2.ui.sdk.update";
    private static final String COMMAND_UPDATE_MANAGER = "org.eclipse.ui.update.findAndInstallUpdates";

    public void run(IIntroSite site, Properties params) {
        Shell currentShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        currentShell.getDisplay().asyncExec(() -> {
            if (!this.executeUpdateCommand(COMMAND_P2)) {
                this.executeUpdateCommand(COMMAND_UPDATE_MANAGER);
            }
        });
    }

    boolean executeUpdateCommand(String command) {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        Command cmd = commandService.getCommand(command);
        ExecutionEvent executionEvent = handlerService.createExecutionEvent(cmd, null);
        try {
            cmd.executeWithChecks(executionEvent);
        }
        catch (ExecutionException e) {
            ILog.of(LaunchUpdateIntroAction.class).error("Exception executing command: " + command, (Throwable)e);
        }
        catch (NotDefinedException notDefinedException) {
            return false;
        }
        catch (NotEnabledException notEnabledException) {
            return false;
        }
        catch (NotHandledException notHandledException) {
            return false;
        }
        return true;
    }
}

