/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.embedder.node;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.dump.UnsupportedCompressionAlgorithmException;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.io.IOUtils;

public class CompressUtils {
    public static void unarchive(URL archiveURL, File baseDir) throws IOException {
        if (archiveURL == null || baseDir == null) {
            return;
        }
        TarArchiveInputStream archive = null;
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream input = archiveURL.openStream();){
            if (archiveURL.getFile().endsWith(".tar.gz")) {
                GzipCompressorInputStream gz = new GzipCompressorInputStream(input);
                archive = new TarArchiveInputStream((InputStream)gz);
            } else if (archiveURL.getFile().endsWith(".tar.xz")) {
                XZCompressorInputStream xz = new XZCompressorInputStream(input);
                archive = new TarArchiveInputStream((InputStream)xz);
            } else if (archiveURL.getFile().endsWith(".zip")) {
                archive = new ZipArchiveInputStream(input);
            } else {
                throw new UnsupportedCompressionAlgorithmException("Unsupported archive file extension: " + String.valueOf(archive));
            }
            try {
                CompressUtils.extractArchive((ArchiveInputStream)archive, baseDir);
            }
            finally {
                IOUtils.closeQuietly((InputStream)archive);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void extractArchive(ArchiveInputStream in, File destination) throws IOException {
        entry = null;
        while ((entry = in.getNextEntry()) != null) {
            if (!in.canReadEntryData(entry)) continue;
            f = new File(destination, entry.getName());
            f.delete();
            var6_6 = entry;
            if (!(var6_6 instanceof TarArchiveEntry)) ** GOTO lbl-1000
            (TarArchiveEntry)var6_6;
            (TarArchiveEntry)var6_6;
            if (tarEntry.isSymbolicLink()) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = symlink = false;
            }
            if (entry.isDirectory()) {
                if (f.isDirectory() || f.mkdirs()) continue;
                throw new IOException("failed to create directory " + String.valueOf(f));
            }
            parent = f.getParentFile();
            if (!parent.isDirectory() && !parent.mkdirs()) {
                throw new IOException("failed to create directory " + String.valueOf(parent));
            }
            if (symlink) {
                linkName = ((TarArchiveEntry)entry).getLinkName();
                Files.createSymbolicLink(f.toPath(), Paths.get((String)linkName, new String[0]), new FileAttribute[0]);
            } else {
                linkName = null;
                var9_10 = null;
                try {
                    o = Files.newOutputStream(f.toPath(), new OpenOption[0]);
                    try {
                        IOUtils.copy((InputStream)in, (OutputStream)o);
                    }
                    finally {
                        if (o != null) {
                            o.close();
                        }
                    }
                }
                catch (Throwable var9_11) {
                    if (linkName == null) {
                        linkName = var9_11;
                    } else if (linkName != var9_11) {
                        linkName.addSuppressed(var9_11);
                    }
                    throw linkName;
                }
            }
            var9_10 = entry;
            if (!(var9_10 instanceof TarArchiveEntry)) continue;
            linkName = (TarArchiveEntry)var9_10;
            (TarArchiveEntry)var9_10;
            f.setExecutable((tarEntry.getMode() & 256) != 0);
        }
    }
}

