/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.nls.bundle.pure.activator;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.converter.StringConverter;
import org.eclipse.wb.internal.core.nls.bundle.AbstractBundleSource;
import org.eclipse.wb.internal.core.nls.bundle.pure.AbstractPureBundleSource;
import org.eclipse.wb.internal.core.nls.bundle.pure.activator.SourceParameters;
import org.eclipse.wb.internal.core.nls.edit.IEditableSource;
import org.eclipse.wb.internal.core.nls.model.AbstractSource;
import org.eclipse.wb.internal.core.nls.model.IKeyGeneratorStrategy;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.BodyDeclarationTarget;
import org.eclipse.wb.internal.core.utils.jdt.core.CodeUtils;

public final class ActivatorSource
extends AbstractPureBundleSource {
    private static final String BUNDLE_COMMENT = "Activator plugin ResourceBundle";

    @Override
    protected String getBundleComment() {
        return BUNDLE_COMMENT;
    }

    public static List<AbstractSource> getPossibleSources(JavaInfo root, IPackageFragment pkg) throws Exception {
        ArrayList sources = Lists.newArrayList();
        IJavaElement[] packageElements = pkg.getChildren();
        int i = 0;
        while (i < packageElements.length) {
            IMethod method_getString_0;
            IField field_bundleName;
            IType type;
            ICompilationUnit unit = (ICompilationUnit)packageElements[i];
            if (unit.getElementName().endsWith("Activator.java") && (type = unit.findPrimaryType()) != null && (field_bundleName = type.getField("pluginBundle")).exists() && (method_getString_0 = CodeUtils.findMethodSingleType(type, "getPluginBundle()")) != null && method_getString_0.getReturnType().equals("QResourceBundle;")) {
                try {
                    ActivatorSource source = new ActivatorSource(root, "plugin");
                    sources.add(source);
                }
                catch (Exception e) {
                    DesignerPlugin.log((Throwable)e);
                }
            }
            ++i;
        }
        return sources;
    }

    @Override
    public void attachPossible() throws Exception {
        ActivatorSource.addField(this.m_root, this.m_bundleName);
    }

    public static AbstractSource get(JavaInfo component, GenericProperty property, Expression expression, List<AbstractSource> sources) throws Exception {
        ExpressionInfo expressionInfo = ActivatorSource.getExpressionInfo(expression);
        if (expressionInfo != null) {
            String bundleName = expressionInfo.m_bundleName;
            ActivatorSource source = ActivatorSource.getNewOrExistingSource(component, bundleName, sources);
            if (source == null) {
                return null;
            }
            source.onKeyAdd(component, expressionInfo.m_key);
            return source;
        }
        return null;
    }

    private static ActivatorSource getNewOrExistingSource(JavaInfo component, String bundleName, List<AbstractSource> sources) throws Exception {
        for (AbstractSource abstractSource : sources) {
            if (!(abstractSource instanceof ActivatorSource)) continue;
            ActivatorSource source = (ActivatorSource)abstractSource;
            if (!source.m_bundleName.equals(bundleName)) continue;
            return source;
        }
        ActivatorSource result = null;
        try {
            result = new ActivatorSource(component.getRootJava(), bundleName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private static ExpressionInfo getExpressionInfo(Expression expression) {
        if (expression instanceof MethodInvocation) {
            boolean is_getString;
            String pluginName = "plugin";
            MethodInvocation getLocalString_invocation = (MethodInvocation)expression;
            MethodInvocation possible_Activator = null;
            String activator_bundleName = null;
            possible_Activator = (MethodInvocation)getLocalString_invocation.getExpression();
            Expression possible_Activator_invokation = possible_Activator.getExpression();
            if (!(possible_Activator_invokation instanceof Expression)) {
                return null;
            }
            String activator_Name = ((SimpleName)possible_Activator_invokation).getFullyQualifiedName();
            boolean is_Activator = activator_Name.endsWith("Activator");
            if (!is_Activator) {
                return null;
            }
            if (activator_Name.length() > "Activator".length()) {
                int pos = activator_Name.length() - "Activator".length();
                pluginName = activator_Name.substring(0, pos).toLowerCase();
            }
            ITypeBinding type = possible_Activator_invokation.resolveTypeBinding();
            IPackageBinding pkg = type.getPackage();
            activator_bundleName = pkg.getName();
            boolean is_getPluginBundle = possible_Activator.getName().getIdentifier().equals("getPluginBundle");
            if (!is_getPluginBundle) {
                return null;
            }
            boolean bl = is_getString = getLocalString_invocation.getName().getIdentifier().equals("getString") && getLocalString_invocation.arguments().size() == 1 && getLocalString_invocation.arguments().get(0) instanceof StringLiteral;
            if (!is_getString) {
                return null;
            }
            String varexp = AstNodeUtils.getFullyQualifiedName((Expression)possible_Activator, false);
            if (varexp == null || !varexp.equals("java.util.ResourceBundle")) {
                return null;
            }
            try {
                StringLiteral nlsStringLiteral = (StringLiteral)getLocalString_invocation.arguments().get(0);
                String nlsString = nlsStringLiteral.getLiteralValue();
                ExpressionInfo expressionInfo = new ExpressionInfo(expression, activator_bundleName, pluginName, nlsStringLiteral, nlsString);
                expression.setProperty("NLS_EXPRESSION_INFO", (Object)expressionInfo);
                return expressionInfo;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public ActivatorSource(JavaInfo root, String bundleName) throws Exception {
        super(root, bundleName);
    }

    @Override
    public String getTypeTitle() throws Exception {
        return "Activator Plugin usage";
    }

    @Override
    protected IKeyGeneratorStrategy getKeyGeneratorStrategy() {
        return KEY_GENERATOR;
    }

    @Override
    protected Expression apply_renameKey_replaceKeyExpression(AstEditor editor, Expression keyExpression, String newKey) throws Exception {
        String newSource = StringConverter.INSTANCE.toJavaSource(this.m_root, newKey);
        return editor.replaceExpression(keyExpression, newSource);
    }

    @Override
    protected AbstractBundleSource.BasicExpressionInfo apply_externalize_replaceExpression(GenericProperty property, String key) throws Exception {
        String code = "Activator.getPluginBundle().getString(" + StringConverter.INSTANCE.toJavaSource(this.m_root, key) + ")";
        Expression expression = property.getExpression();
        ExpressionInfo expressionInfo = (ExpressionInfo)this.replaceExpression_getInfo(expression, code);
        this.addNonNLSComment(expressionInfo.m_keyExpression);
        return expressionInfo;
    }

    @Override
    protected void apply_removeNonNLSComments(AbstractBundleSource.BasicExpressionInfo basicExpressionInfo) throws Exception {
        ExpressionInfo expressionInfo = (ExpressionInfo)basicExpressionInfo;
        this.removeNonNLSComment((StringLiteral)expressionInfo.m_keyExpression);
    }

    public static ActivatorSource apply_create(IEditableSource editable, JavaInfo root, Object o) throws Exception {
        SourceParameters parameters = (SourceParameters)o;
        ActivatorSource.createPropertyBundleFile(parameters.m_propertyPackage, parameters.m_propertyFileName, null);
        return new ActivatorSource(root, parameters.m_propertyBundleName);
    }

    private static void addField(JavaInfo root, String bundleName) throws Exception {
        String code = "import " + StringConverter.INSTANCE.toJavaSource(root, bundleName);
        TypeDeclaration typeDeclaration = JavaInfoUtils.getTypeDeclaration(root);
        root.getEditor().addInterfaceMethodDeclaration(code, new BodyDeclarationTarget(typeDeclaration, true));
    }

    protected static class ExpressionInfo
    extends AbstractBundleSource.BasicExpressionInfo {
        private final String m_bundleName;

        public ExpressionInfo(Expression expression, String packageName, String pluginName, StringLiteral keyExpression, String key) {
            super(expression, (Expression)keyExpression, key);
            this.m_bundleName = pluginName;
        }
    }
}

