/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.ui;

import java.io.InputStream;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wb.draw2d.IColorConstants;
import org.eclipse.wb.draw2d.geometry.Rectangle;

public class DrawUtils {
    private static final String DOTS = "...";

    public static final void drawStringCV(GC gc, String text, int x, int y, int width, int height) {
        org.eclipse.swt.graphics.Rectangle oldClipping = gc.getClipping();
        try {
            gc.setClipping(new org.eclipse.swt.graphics.Rectangle(x, y, width, height));
            int textStartY = y + (height - gc.getFontMetrics().getHeight()) / 2;
            gc.drawString(DrawUtils.clipString(gc, text, width), x, textStartY, true);
        }
        finally {
            gc.setClipping(oldClipping);
        }
    }

    public static final void drawStringCHCV(GC gc, String text, int x, int y, int width, int height) {
        int textStartY = y + (height - gc.getFontMetrics().getHeight()) / 2;
        Point textSize = gc.stringExtent(text);
        if (textSize.x > width) {
            gc.drawString(DrawUtils.clipString(gc, text, width), x, textStartY);
        } else {
            gc.drawString(text, x + (width - textSize.x) / 2, textStartY);
        }
    }

    public static final void drawImageCV(GC gc, Image image, int x, int y, int height) {
        if (image != null) {
            org.eclipse.swt.graphics.Rectangle imageBounds = image.getBounds();
            gc.drawImage(image, x, y + (height - imageBounds.height) / 2);
        }
    }

    public static final void drawImageCHCV(GC gc, Image image, int x, int y, int width, int height) {
        if (image != null) {
            org.eclipse.swt.graphics.Rectangle imageBounds = image.getBounds();
            int centerX = (width - imageBounds.width) / 2;
            int centerY = y + (height - imageBounds.height) / 2;
            gc.drawImage(image, x + centerX, centerY);
        }
    }

    public static void drawScaledImage(GC gc, Image image, org.eclipse.swt.graphics.Rectangle targetRectangle) {
        int newImageHeight;
        int newImageWidth;
        int imageWidth = image.getBounds().width;
        int imageHeight = image.getBounds().height;
        if (imageWidth <= targetRectangle.width && imageHeight <= targetRectangle.height) {
            newImageWidth = imageWidth;
            newImageHeight = imageHeight;
        } else {
            double k_w = (double)targetRectangle.width / (double)imageWidth;
            double k_h = (double)targetRectangle.height / (double)imageHeight;
            double k = Math.min(k_w, k_h);
            newImageWidth = (int)((double)imageWidth * k);
            newImageHeight = (int)((double)imageHeight * k);
        }
        int destX = targetRectangle.x + (targetRectangle.width - newImageWidth) / 2;
        int destY = targetRectangle.y + (targetRectangle.height - newImageHeight) / 2;
        gc.drawImage(image, 0, 0, imageWidth, imageHeight, destX, destY, newImageWidth, newImageHeight);
    }

    /*
     * Unable to fully structure code
     */
    public static String clipString(GC gc, String text, int width) {
        block4: {
            if (width <= 0) {
                return "";
            }
            if (gc.stringExtent((String)text).x <= width) {
                return text;
            }
            count = Math.min(width / gc.getFontMetrics().getAverageCharWidth(), text.length());
            if (gc.stringExtent((String)new StringBuilder((String)String.valueOf((Object)text.substring((int)0, (int)count))).append((String)"...").toString()).x <= width) ** GOTO lbl12
            while (count > 0 && gc.stringExtent((String)new StringBuilder((String)String.valueOf((Object)text.substring((int)0, (int)count))).append((String)"...").toString()).x > width) {
                --count;
            }
            break block4;
lbl-1000:
            // 1 sources

            {
                ++count;
lbl12:
                // 2 sources

                ** while (count < text.length() - 1 && gc.stringExtent((String)new StringBuilder((String)String.valueOf((Object)text.substring((int)0, (int)(count + 1)))).append((String)"...").toString()).x < width)
            }
        }
        return String.valueOf(text.substring(0, count)) + "...";
    }

    public static void drawTextWrap(GC gc, String text, int x, int y, int width, int height) {
        int y_ = y;
        int x_ = x;
        int lineHeight = 0;
        int i = 0;
        while (i < text.length()) {
            String c = text.substring(i, i + 1);
            Point extent = gc.stringExtent(c);
            if (x_ + extent.x > x + width) {
                if ((y_ += lineHeight) > y + height) {
                    return;
                }
                x_ = x;
            }
            gc.drawText(c, x_, y_);
            x_ += extent.x;
            lineHeight = Math.max(lineHeight, extent.y);
            ++i;
        }
    }

    public static void drawHighlightRectangle(GC gc, int x, int y, int width, int height) {
        int right = x + width - 1;
        int bottom = y + height - 1;
        Color oldForeground = gc.getForeground();
        try {
            gc.setForeground(IColorConstants.buttonLightest);
            gc.drawLine(x, y, right, y);
            gc.drawLine(x, y, x, bottom);
            gc.setForeground(IColorConstants.buttonDarker);
            gc.drawLine(right, y, right, bottom);
            gc.drawLine(x, bottom, right, bottom);
        }
        finally {
            gc.setForeground(oldForeground);
        }
    }

    public static Image loadImage(Class<?> clazz, String path) {
        block5: {
            Image image;
            URL resource = clazz.getResource(path);
            if (resource == null) break block5;
            InputStream stream = resource.openStream();
            try {
                image = new Image(null, stream);
            }
            catch (Throwable throwable) {
                try {
                    IOUtils.closeQuietly((InputStream)stream);
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
            }
            IOUtils.closeQuietly((InputStream)stream);
            return image;
        }
        return null;
    }

    public static Image getThubmnail(Image image, int minWidth, int minHeight, int maxWidth, int maxHeight) {
        org.eclipse.swt.graphics.Rectangle imageBounds = image.getBounds();
        int imageWidth = imageBounds.width;
        int imageHeight = imageBounds.height;
        if (imageWidth < minWidth && imageHeight < minHeight) {
            Image thumbnail = new Image(null, minWidth, minHeight);
            GC gc = new GC((Drawable)thumbnail);
            try {
                DrawUtils.drawImageCHCV(gc, image, 0, 0, minWidth, minHeight);
            }
            finally {
                gc.dispose();
            }
            try {
                ImageData thumbnailData = thumbnail.getImageData();
                thumbnailData.transparentPixel = thumbnailData.getPixel(0, 0);
                Image image2 = new Image(null, thumbnailData);
                return image2;
            }
            finally {
                thumbnail.dispose();
            }
        }
        if (imageWidth <= maxWidth && imageHeight <= maxHeight) {
            return new Image(null, image, 0);
        }
        double kX = (double)maxWidth / (double)imageWidth;
        double kY = (double)maxHeight / (double)imageHeight;
        double k = Math.max(kX, kY);
        int dWidth = (int)((double)imageWidth * k);
        int dHeight = (int)((double)imageHeight * k);
        ImageData scaledImageData = image.getImageData().scaledTo(dWidth, dHeight);
        return new Image(null, scaledImageData);
    }

    public static Image createTransparentPart(Image original, Rectangle bounds, int alpha) {
        Image image = new Image(null, bounds.width, bounds.height);
        GC gc = new GC((Drawable)image);
        try {
            try {
                gc.drawImage(original, bounds.x, bounds.y, bounds.width, bounds.height, 0, 0, bounds.width, bounds.height);
            }
            catch (Throwable e) {
                image.dispose();
                gc.dispose();
                return null;
            }
        }
        finally {
            gc.dispose();
        }
        ImageData imageData = image.getImageData();
        int y = 0;
        while (y < imageData.height) {
            int x = 0;
            while (x < imageData.width) {
                imageData.setAlpha(x, y, alpha);
                ++x;
            }
            ++y;
        }
        Image alphaImage = new Image(null, imageData);
        image.dispose();
        return alphaImage;
    }

    public static Image createRotatedImage(Image srcImage) {
        Display display = Display.getCurrent();
        if (display == null) {
            SWT.error((int)22);
        }
        ImageData srcData = srcImage.getImageData();
        ImageData destData = srcData.depth < 8 ? DrawUtils.rotatePixelByPixel(srcData) : DrawUtils.rotateOptimized(srcData);
        return new Image((Device)display, destData);
    }

    private static ImageData rotatePixelByPixel(ImageData srcData) {
        ImageData destData = new ImageData(srcData.height, srcData.width, srcData.depth, srcData.palette);
        int y = 0;
        while (y < srcData.height) {
            int x = 0;
            while (x < srcData.width) {
                destData.setPixel(y, srcData.width - x - 1, srcData.getPixel(x, y));
                ++x;
            }
            ++y;
        }
        return destData;
    }

    private static ImageData rotateOptimized(ImageData srcData) {
        int bytesPerPixel = Math.max(1, srcData.depth / 8);
        int destBytesPerLine = ((srcData.height * bytesPerPixel - 1) / srcData.scanlinePad + 1) * srcData.scanlinePad;
        byte[] newData = new byte[destBytesPerLine * srcData.width];
        int srcY = 0;
        while (srcY < srcData.height) {
            int srcX = 0;
            while (srcX < srcData.width) {
                int destX = srcY;
                int destY = srcData.width - srcX - 1;
                int destIndex = destY * destBytesPerLine + destX * bytesPerPixel;
                int srcIndex = srcY * srcData.bytesPerLine + srcX * bytesPerPixel;
                System.arraycopy(srcData.data, srcIndex, newData, destIndex, bytesPerPixel);
                ++srcX;
            }
            ++srcY;
        }
        return new ImageData(srcData.height, srcData.width, srcData.depth, srcData.palette, srcData.scanlinePad, newData);
    }

    public static Color getShiftedColor(Color color, int delta) {
        int r = Math.max(0, Math.min(color.getRed() + delta, 255));
        int g = Math.max(0, Math.min(color.getGreen() + delta, 255));
        int b = Math.max(0, Math.min(color.getBlue() + delta, 255));
        return new Color(color.getDevice(), r, g, b);
    }

    public static boolean isDarkColor(Color c) {
        int value = (int)Math.sqrt((double)(c.getRed() * c.getRed()) * 0.241 + (double)(c.getGreen() * c.getGreen()) * 0.691 + (double)(c.getBlue() * c.getBlue()) * 0.068);
        return value < 130;
    }

    public static Font getBoldFont(Font baseFont) {
        FontData[] boldData = DrawUtils.getModifiedFontData(baseFont, 1);
        return new Font((Device)Display.getCurrent(), boldData);
    }

    public static Font getBoldItalicFont(Font baseFont) {
        FontData[] boldData = DrawUtils.getModifiedFontData(baseFont, 3);
        return new Font((Device)Display.getCurrent(), boldData);
    }

    public static Font getItalicFont(Font baseFont) {
        FontData[] boldData = DrawUtils.getModifiedFontData(baseFont, 2);
        return new Font((Device)Display.getCurrent(), boldData);
    }

    private static FontData[] getModifiedFontData(Font baseFont, int style) {
        FontData[] baseData = baseFont.getFontData();
        FontData[] styleData = new FontData[baseData.length];
        int i = 0;
        while (i < styleData.length) {
            FontData base = baseData[i];
            styleData[i] = new FontData(base.getName(), base.getHeight(), base.getStyle() | style);
            ++i;
        }
        return styleData;
    }
}

