/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.gef.graphical;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.wb.draw2d.geometry.Dimension;
import org.eclipse.wb.internal.draw2d.IPreferredSizeProvider;
import org.eclipse.wb.internal.draw2d.scroll.ScrollModel;
import org.eclipse.wb.internal.gef.graphical.GraphicalViewer;

public class HeaderGraphicalViewer
extends GraphicalViewer {
    private GraphicalViewer m_mainViewer;
    private final boolean m_horizontal;

    public HeaderGraphicalViewer(Composite parent, boolean horizontal) {
        this(parent, 0, horizontal);
    }

    public HeaderGraphicalViewer(Composite parent, int style, boolean horizontal) {
        super(parent, HeaderGraphicalViewer.checkStyles(style));
        this.m_horizontal = horizontal;
    }

    private static final int checkStyles(int styles) {
        if ((styles & 0x100) != 0) {
            styles |= 0xFFFFFEFF;
        }
        if ((styles & 0x200) != 0) {
            styles |= 0xFFFFFDFF;
        }
        return styles;
    }

    public void setMainViewer(GraphicalViewer mainViewer) {
        this.m_mainViewer = mainViewer;
        this.setEditDomain(this.m_mainViewer.getEditDomain());
        if (this.m_horizontal) {
            this.setHorizontallHook();
        } else {
            this.setVerticalHook();
        }
    }

    private void setHorizontallHook() {
        this.getRootFigureInternal().setPreferredSizeProvider(new IPreferredSizeProvider(){

            @Override
            public Dimension getPreferredSize(Dimension originalPreferredSize) {
                return new Dimension(HeaderGraphicalViewer.this.m_mainViewer.getRootFigureInternal().getPreferredSize().width + HeaderGraphicalViewer.this.m_mainViewer.m_canvas.getVerticalBar().getSize().x, originalPreferredSize.height);
            }
        });
        this.m_mainViewer.m_canvas.getHorizontalScrollModel().addSelectionListener(new ScrollModel.ISelectionListener(){

            @Override
            public void setSelection(int newSelection) {
                HeaderGraphicalViewer.this.m_canvas.getHorizontalScrollModel().setSelection(newSelection);
                HeaderGraphicalViewer.this.getRootFigureInternal().repaint();
            }
        });
    }

    private void setVerticalHook() {
        this.getRootFigureInternal().setPreferredSizeProvider(new IPreferredSizeProvider(){

            @Override
            public Dimension getPreferredSize(Dimension originalPreferredSize) {
                return new Dimension(originalPreferredSize.width, HeaderGraphicalViewer.this.m_mainViewer.getRootFigureInternal().getPreferredSize().height + HeaderGraphicalViewer.this.m_mainViewer.m_canvas.getHorizontalBar().getSize().y);
            }
        });
        this.m_mainViewer.m_canvas.getVerticalScrollModel().addSelectionListener(new ScrollModel.ISelectionListener(){

            @Override
            public void setSelection(int newSelection) {
                HeaderGraphicalViewer.this.m_canvas.getVerticalScrollModel().setSelection(newSelection);
                HeaderGraphicalViewer.this.getRootFigureInternal().repaint();
            }
        });
    }
}

