/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.layout.form;

import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.JavaEventListener;
import org.eclipse.wb.internal.core.gef.policy.snapping.PlacementUtils;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.property.GenericPropertyImpl;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.NodeTarget;
import org.eclipse.wb.internal.core.utils.ast.StatementTarget;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.swt.model.layout.form.FormDataInfo;
import org.eclipse.wb.internal.swt.model.layout.form.FormLayoutUtils;
import org.eclipse.wb.internal.swt.model.layout.form.FormSide;
import org.eclipse.wb.internal.swt.model.layout.form.IFormAttachmentInfo;
import org.eclipse.wb.internal.swt.model.layout.form.VirtualFormAttachmentVariableSupport;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;

public final class FormAttachmentInfo
extends JavaInfo
implements IFormAttachmentInfo<ControlInfo> {
    private static final String PROPERTY_TITLE_ALIGNMENT = "alignment";
    private static final String PROPERTY_TITLE_CONTROL = "control";
    private static final String PROPERTY_TITLE_OFFSET = "offset";
    private static final String PROPERTY_TITLE_DENOMINATOR = "denominator";
    private static final String PROPERTY_TITLE_NUMERATOR = "numerator";
    private final FormAttachmentInfo m_this = this;
    private FormSide m_side;
    private int m_numerator;
    private int m_denominator = 100;
    private int m_offset;
    private ControlInfo m_control;
    private int m_alignment = -1;
    private boolean m_deleting;

    public FormAttachmentInfo(AstEditor editor, ComponentDescription description, CreationSupport creationSupport) throws Exception {
        super(editor, description, creationSupport);
    }

    protected void initialize() throws Exception {
        super.initialize();
        this.addBroadcastListener(new JavaEventListener(){

            public void setPropertyExpression(GenericPropertyImpl property, String[] source, Object[] value, boolean[] shouldSet) throws Exception {
                if (property.getJavaInfo() == FormAttachmentInfo.this.m_this) {
                    FormAttachmentInfo.this.materialize();
                    FormAttachmentInfo.this.setPropertyExpression(property, source, value);
                    shouldSet[0] = false;
                }
            }
        });
    }

    @Override
    public FormSide getSide() {
        return this.m_side;
    }

    public void setSide(FormSide side) {
        this.m_side = side;
    }

    private void setPropertyExpression(GenericPropertyImpl property, String[] source, Object[] value) throws Exception {
        String title = property.getTitle();
        if (PROPERTY_TITLE_NUMERATOR.equals(title)) {
            this.setNumerator((Integer)value[0]);
            this.setControl((ControlInfo)null);
        }
        if (PROPERTY_TITLE_OFFSET.equals(title)) {
            this.setOffset((Integer)value[0]);
        }
        if (PROPERTY_TITLE_DENOMINATOR.equals(title)) {
            this.setDenominator((Integer)value[0]);
            this.setControl((ControlInfo)null);
        }
        if (PROPERTY_TITLE_ALIGNMENT.equals(title)) {
            if (this.getControl() != null) {
                int alignment = (Integer)value[0];
                this.setAlignment(alignment);
            } else {
                return;
            }
        }
        if (PROPERTY_TITLE_CONTROL.equals(title)) {
            if (value[0] == Property.UNKNOWN_VALUE) {
                this.setControl((ControlInfo)null);
            } else {
                this.setControl((ControlInfo)value[0]);
                this.setAlignment(this.getSide().getOppositeSide().getFormSide());
                this.setOffset(0);
            }
        }
        this.write();
        if (!this.m_deleting) {
            ExecutionUtils.refresh((ObjectInfo)this);
        }
    }

    public void readPropertiesValue() throws Exception {
        this.m_numerator = (Integer)this.getPropertyByTitle(PROPERTY_TITLE_NUMERATOR).getValue();
        this.m_denominator = (Integer)this.getPropertyByTitle(PROPERTY_TITLE_DENOMINATOR).getValue();
        this.m_offset = (Integer)this.getPropertyByTitle(PROPERTY_TITLE_OFFSET).getValue();
        Object control = this.getPropertyByTitle(PROPERTY_TITLE_CONTROL).getValue();
        this.m_control = (ControlInfo)this.getRootJava().getChildByObject(control);
        this.m_alignment = (Integer)this.getPropertyByTitle(PROPERTY_TITLE_ALIGNMENT).getValue();
        if (this.m_alignment == 0 || this.m_alignment == -1) {
            this.m_alignment = this.m_side.getOppositeSide().getFormSide();
        }
    }

    public void delete() throws Exception {
        try {
            this.m_deleting = true;
            if (!this.isVirtual()) {
                this.setDefaults();
            }
            super.delete();
        }
        finally {
            this.m_deleting = false;
        }
    }

    private void setDefaults() throws Exception {
        this.getPropertyByTitle(PROPERTY_TITLE_NUMERATOR).setValue((Object)0);
        this.getPropertyByTitle(PROPERTY_TITLE_DENOMINATOR).setValue((Object)100);
        this.getPropertyByTitle(PROPERTY_TITLE_OFFSET).setValue((Object)0);
        this.getPropertyByTitle(PROPERTY_TITLE_ALIGNMENT).setValue((Object)-1);
        this.getPropertyByTitle(PROPERTY_TITLE_CONTROL).setValue(Property.UNKNOWN_VALUE);
    }

    @Override
    public final void setNumerator(int numerator) {
        this.m_numerator = numerator;
    }

    @Override
    public final int getNumerator() {
        return this.m_numerator;
    }

    @Override
    public final void setDenominator(int denominator) {
        this.m_denominator = denominator;
    }

    @Override
    public final int getDenominator() {
        return this.m_denominator;
    }

    @Override
    public final void setOffset(int offset) {
        this.m_offset = offset;
    }

    @Override
    public final int getOffset() {
        return this.m_offset;
    }

    @Override
    public final void setControl(ControlInfo control) {
        this.m_control = control;
    }

    @Override
    public final ControlInfo getControl() {
        return this.m_control;
    }

    @Override
    public final void setAlignment(int alignment) {
        if (alignment == 0 || alignment == -1) {
            alignment = this.m_side.getOppositeSide().getFormSide();
        }
        if (!this.isValidAlignment(alignment)) {
            return;
        }
        this.m_alignment = alignment;
    }

    @Override
    public final int getAlignment() {
        return this.m_alignment;
    }

    @Override
    public boolean isVirtual() {
        return this.getVariableSupport() instanceof VirtualFormAttachmentVariableSupport;
    }

    @Override
    public boolean isParentTrailing() {
        return !this.isVirtual() && this.getControl() == null && this.getDenominator() == this.getNumerator();
    }

    @Override
    public boolean isParentLeading() {
        return !this.isVirtual() && this.getControl() == null && this.getNumerator() == 0 && this.getDenominator() == 100;
    }

    @Override
    public boolean isPercentaged() {
        return this.getNumerator() > 0 && this.getNumerator() < 100;
    }

    @Override
    public void write() throws Exception {
        this.materialize();
        ControlInfo control = this.getControl();
        String source = "";
        if (control == null) {
            source = this.getDenominator() == 100 ? (this.getOffset() == 0 ? String.valueOf(source) + this.getNumerator() : String.valueOf(source) + this.getNumerator() + ", " + this.getOffset()) : String.valueOf(source) + this.getNumerator() + ", " + this.getDenominator() + ", " + this.getOffset();
        } else {
            String referenceExpression = this.getReferenceExpression_ensureFormDataVisible(control);
            source = this.getAlignment() == this.m_side.getOppositeSide().getFormSide() ? (this.getOffset() == 0 ? String.valueOf(source) + referenceExpression : String.valueOf(source) + referenceExpression + ", " + this.getOffset()) : String.valueOf(source) + referenceExpression + ", " + this.getOffset() + ", " + FormLayoutUtils.getAlignmentSource(this.getAlignment());
        }
        this.setConstructorArguments(source, control);
    }

    private String getReferenceExpression_ensureFormDataVisible(ControlInfo control) throws Exception {
        FormDataInfo layoutData = (FormDataInfo)this.getParent();
        StatementTarget statementTarget = JavaInfoUtils.getStatementTarget_whenAllCreated((List)ImmutableList.of((Object)layoutData, (Object)control));
        String referenceExpression = control.getVariableSupport().getReferenceExpression(new NodeTarget(statementTarget));
        this.moveStatement(this, statementTarget);
        return referenceExpression;
    }

    private void moveStatement(JavaInfo javaInfo, StatementTarget statementTarget) throws Exception {
        ConstructorCreationSupport creationSupport = (ConstructorCreationSupport)javaInfo.getCreationSupport();
        ClassInstanceCreation cic = creationSupport.getCreation();
        this.getEditor().moveStatement(AstNodeUtils.getEnclosingStatement((ASTNode)cic), statementTarget);
    }

    private void setConstructorArguments(String source, ControlInfo control) throws Exception {
        ConstructorCreationSupport creationSupport = (ConstructorCreationSupport)this.getCreationSupport();
        ClassInstanceCreation cic = creationSupport.getCreation();
        this.getEditor().replaceCreationArguments(cic, (List)ImmutableList.of((Object)source));
        if (control != null) {
            this.replaceFormDataQualifier(cic, control);
        }
        this.setCreationSupport((CreationSupport)new ConstructorCreationSupport(cic));
    }

    private void replaceFormDataQualifier(ClassInstanceCreation cic, ControlInfo control) throws Exception {
        Assignment formDataAssignment = (Assignment)cic.getParent();
        QualifiedName formDataAssignmentLeft = (QualifiedName)formDataAssignment.getLeftHandSide();
        FormDataInfo layoutData = (FormDataInfo)this.getParent();
        StatementTarget statementTarget = JavaInfoUtils.getStatementTarget_whenAllCreated((List)ImmutableList.of((Object)layoutData, (Object)control));
        String referenceExpression = layoutData.getVariableSupport().getReferenceExpression(new NodeTarget(statementTarget));
        this.getEditor().replaceExpression((Expression)formDataAssignmentLeft.getQualifier(), referenceExpression);
    }

    private void materialize() throws Exception {
        if (this.isVirtual()) {
            ((VirtualFormAttachmentVariableSupport)this.getVariableSupport()).materialize();
        }
    }

    public String toString() {
        final String[] result = new String[]{""};
        if (this.isVirtual()) {
            result[0] = String.valueOf(result[0]) + "(none)";
            return result[0];
        }
        ExecutionUtils.runIgnore((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                ControlInfo control = FormAttachmentInfo.this.getControl();
                int offset = FormAttachmentInfo.this.getOffset();
                if (control == null) {
                    result[0] = String.valueOf(result[0]) + "(" + FormAttachmentInfo.this.getNumerator();
                    int denominator = FormAttachmentInfo.this.getDenominator();
                    if (denominator != 100) {
                        result[0] = String.valueOf(result[0]) + ", " + denominator;
                    }
                    if (offset != 0 || denominator != 100) {
                        result[0] = String.valueOf(result[0]) + ", " + offset;
                    }
                    result[0] = String.valueOf(result[0]) + ")";
                } else {
                    result[0] = String.valueOf(result[0]) + "(" + control.getVariableSupport().getTitle() + ", " + offset + ")";
                }
            }
        });
        return result[0];
    }

    private boolean isValidAlignment(int alignment) {
        if (alignment != 0x1000000) {
            boolean b2;
            boolean b1 = PlacementUtils.isHorizontalSide((int)this.getSide().getEngineSide());
            return b1 == (b2 = PlacementUtils.isHorizontalSide((int)FormLayoutUtils.convertSwtAlignment(alignment)));
        }
        return true;
    }

    public void adjustAfterComponentMove() throws Exception {
        this.write();
    }

    public FormAttachmentClipboardInfo getClipboardInfo() {
        if (this.isVirtual()) {
            return null;
        }
        FormAttachmentClipboardInfo info = new FormAttachmentClipboardInfo();
        info.numerator = this.getNumerator();
        info.denominator = this.getDenominator();
        info.offset = this.getOffset();
        ControlInfo targetControl = this.getControl();
        if (targetControl != null) {
            CompositeInfo parent = (CompositeInfo)targetControl.getParent();
            info.controlID = parent.getChildrenControls().indexOf(targetControl);
        }
        info.alignment = this.getAlignment();
        return info;
    }

    public void applyClipboardInfo(ControlInfo thisControl, FormAttachmentClipboardInfo info) throws Exception {
        if (info == null) {
            return;
        }
        this.setNumerator(info.numerator);
        this.setDenominator(info.denominator);
        this.setOffset(info.offset);
        this.setAlignment(info.alignment);
        if (info.controlID != -1) {
            CompositeInfo parent = (CompositeInfo)thisControl.getParent();
            ControlInfo targetControl = parent.getChildrenControls().get(info.controlID);
            this.setControl(targetControl);
        }
        this.write();
    }

    static class FormAttachmentClipboardInfo
    implements Serializable {
        private static final long serialVersionUID = 0L;
        int numerator;
        int denominator;
        int offset;
        int controlID = -1;
        int alignment;

        FormAttachmentClipboardInfo() {
        }
    }
}

