/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.databinding.ui.contentproviders.el;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.wb.internal.core.databinding.model.IObserveInfo;
import org.eclipse.wb.internal.core.databinding.utils.CoreUtils;
import org.eclipse.wb.internal.swing.databinding.model.ObserveInfo;
import org.eclipse.wb.internal.swing.databinding.model.beans.BeanSupport;
import org.eclipse.wb.internal.swing.databinding.model.generic.ClassGenericType;
import org.eclipse.wb.internal.swing.databinding.ui.contentproviders.el.CompletionProposal;
import org.eclipse.wb.internal.swing.databinding.ui.contentproviders.el.ErrorCompletionProposal;
import org.eclipse.wb.internal.swing.databinding.ui.contentproviders.el.IBeanPropertiesSupport;

public final class ContentAssistProcessor
implements IContentAssistProcessor {
    private static final char[] TOP_LEVEL_AUTO_ACTIVATION_CHARACTERS = new char[]{'$', '#'};
    private static final char[] AUTO_ACTIVATION_CHARACTERS = new char[]{'.'};
    private final IBeanPropertiesSupport m_propertiesSupport;
    private final boolean m_topLevel;

    public ContentAssistProcessor(IBeanPropertiesSupport propertiesSupport, boolean topLevel) {
        this.m_propertiesSupport = propertiesSupport;
        this.m_topLevel = topLevel;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        block15: {
            if (this.m_propertiesSupport.getTopLevelBean() != null) break block15;
            return null;
        }
        try {
            IDocument document = viewer.getDocument();
            if (this.m_topLevel) {
                String begin = "${";
                if (offset > 0) {
                    switch (document.getChar(offset - 1)) {
                        case '#': 
                        case '$': {
                            begin = "{";
                            break;
                        }
                        case '{': {
                            switch (document.getChar(offset - 2)) {
                                case '#': 
                                case '$': {
                                    begin = "";
                                }
                            }
                        }
                    }
                }
                return ContentAssistProcessor.createProposals(this.createTopProperties(), offset, begin, "}");
            }
            if (document.getChar(offset - 1) == '.') {
                int endOffset = offset - 1;
                int startOffset = endOffset - 1;
                while (startOffset > 0) {
                    if (document.getChar(startOffset) == '{') {
                        int propertyOffset = startOffset + 1;
                        int length = endOffset - propertyOffset;
                        if (length == 0) break;
                        String property = document.get(propertyOffset, length).trim();
                        List<ObserveInfo> properties = this.resolveProperties(StringUtils.split((String)property, (char)'.'), this.createTopProperties(), 0);
                        return properties == null ? null : ContentAssistProcessor.createProposals(properties, offset, "", "");
                    }
                    --startOffset;
                }
            }
            return null;
        }
        catch (Throwable e) {
            return new ICompletionProposal[]{new ErrorCompletionProposal(e)};
        }
    }

    private List<ObserveInfo> createTopProperties() throws Exception {
        BeanSupport beanSupport = new BeanSupport();
        beanSupport.doAddELProperty(false);
        beanSupport.doAddSelfProperty(false);
        List<ObserveInfo> properties = beanSupport.createProperties(null, new ClassGenericType(this.m_propertiesSupport.getTopLevelBean(), null, null));
        return properties;
    }

    private List<ObserveInfo> resolveProperties(String[] properties, List<ObserveInfo> observes, int index) throws Exception {
        String property = properties[index++];
        for (ObserveInfo observe : observes) {
            if (!observe.getPresentation().getText().equals(property)) continue;
            List<ObserveInfo> children = CoreUtils.cast((List)observe.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable));
            return index == properties.length ? children : this.resolveProperties(properties, children, index);
        }
        return null;
    }

    private static ICompletionProposal[] createProposals(List<ObserveInfo> properties, int offset, String begin, String end) throws Exception {
        ICompletionProposal[] proposals = new ICompletionProposal[properties.size()];
        int i = 0;
        while (i < proposals.length) {
            ObserveInfo observe = properties.get(i);
            String propertyName = observe.getPresentation().getText();
            String data = String.valueOf(begin) + propertyName + end;
            proposals[i] = new CompletionProposal(propertyName, observe.getPresentation().getImage(), offset, data, offset + data.length());
            ++i;
        }
        return proposals;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.m_topLevel ? TOP_LEVEL_AUTO_ACTIVATION_CHARACTERS : AUTO_ACTIVATION_CHARACTERS;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }
}

