/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.xwt.model.widgets;

import com.google.common.collect.Maps;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.XmlObjectPresentation;
import org.eclipse.wb.internal.xwt.model.widgets.WidgetInfo;
import org.osgi.framework.Bundle;

public abstract class StylePresentation
extends XmlObjectPresentation {
    protected final WidgetInfo m_widget;
    private static final Map<Class<?>, Map<Integer, Image>> m_images = Maps.newHashMap();

    public StylePresentation(WidgetInfo widget) {
        super((XmlObjectInfo)widget);
        this.m_widget = widget;
    }

    public Image getIcon() throws Exception {
        int style = this.m_widget.getStyle();
        for (Map.Entry<Integer, Image> entry : this.getImages().entrySet()) {
            int keyStyle = entry.getKey();
            if ((style & keyStyle) != keyStyle) continue;
            return entry.getValue();
        }
        return super.getIcon();
    }

    protected abstract void initImages() throws Exception;

    private Map<Integer, Image> getImages() throws Exception {
        HashMap images = m_images.get(((Object)((Object)this)).getClass());
        if (images == null) {
            images = Maps.newHashMap();
            m_images.put(((Object)((Object)this)).getClass(), images);
            this.initImages();
        }
        return images;
    }

    protected final void addImage(int style, String imagePath) throws Exception {
        Bundle bundle = this.m_widget.getDescription().getToolkit().getBundle();
        URL imageURL = bundle.getEntry(imagePath);
        Assert.isNotNull((Object)imageURL, (String)("Can't find image: " + imagePath + " in " + bundle.getSymbolicName()));
        Image image = new Image((Device)Display.getDefault(), imageURL.openStream());
        this.getImages().put(style, image);
    }
}

