/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.property.editor.image.plugin;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.browse.AbstractBrowseImagePage;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.browse.model.IHasChildren;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.browse.model.IImageElement;
import org.eclipse.wb.internal.swt.model.property.editor.image.plugin.FileImageResource;
import org.eclipse.wb.internal.swt.model.property.editor.image.plugin.ImageContainer;

public class FileImageContainer
extends ImageContainer
implements IHasChildren {
    private final IContainer m_container;
    private final String m_symbolicName;
    private IImageElement[] m_resources;
    private boolean m_calculateHasChildren = true;
    private boolean m_hasChildren;

    public FileImageContainer(IContainer container, String symbolicName) {
        this.m_container = container;
        this.m_symbolicName = symbolicName;
    }

    private void ensureResources() {
        if (this.m_resources == null) {
            ArrayList resources = Lists.newArrayList();
            try {
                IResource[] iResourceArray = this.m_container.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String extension;
                    IResource resource = iResourceArray[n2];
                    if (resource instanceof IContainer) {
                        IContainer container = (IContainer)resource;
                        if (FileImageContainer.isContainsResources(container)) {
                            resources.add(new FileImageContainer(container, this.m_symbolicName));
                        }
                    } else if (resource instanceof IFile && AbstractBrowseImagePage.isImageExtension((String)(extension = resource.getLocation().getFileExtension()))) {
                        resources.add(new FileImageResource((IFile)resource, this.m_symbolicName));
                    }
                    ++n2;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.m_resources = resources.toArray(new IImageElement[resources.size()]);
        }
    }

    private static boolean isContainsResources(IContainer container) throws Exception {
        ArrayList<IContainer> subContainers = new ArrayList<IContainer>();
        IResource[] iResourceArray = container.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            String extension;
            IResource resource = iResourceArray[n2];
            if (resource instanceof IContainer) {
                subContainers.add((IContainer)resource);
            } else if (resource instanceof IFile && AbstractBrowseImagePage.isImageExtension((String)(extension = resource.getLocation().getFileExtension()))) {
                return true;
            }
            ++n2;
        }
        for (IContainer subContainer : subContainers) {
            if (!FileImageContainer.isContainsResources(subContainer)) continue;
            return true;
        }
        return false;
    }

    public boolean hasChildren() {
        try {
            if (this.m_calculateHasChildren) {
                this.m_calculateHasChildren = false;
                this.m_hasChildren = FileImageContainer.isContainsResources(this.m_container);
            }
            return this.m_hasChildren;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public final IImageElement[] elements() {
        this.ensureResources();
        return this.m_resources;
    }

    @Override
    protected IImageElement[] directElements() {
        return this.m_resources;
    }

    public Image getImage() {
        return DesignerPlugin.getImage((String)"folder_open.gif");
    }

    public final String getName() {
        return this.m_container.getName();
    }

    protected final boolean findResource(List<Object> paths, String imagePath) {
        paths.add(this);
        IImageElement[] iImageElementArray = this.elements();
        int n = iImageElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IImageElement element = iImageElementArray[n2];
            if (element instanceof FileImageContainer) {
                FileImageContainer container = (FileImageContainer)element;
                if (container.findResource(paths, imagePath)) {
                    return true;
                }
            } else {
                FileImageResource resource = (FileImageResource)element;
                if (resource.getPath().equals(imagePath)) {
                    paths.add(resource);
                    return true;
                }
            }
            ++n2;
        }
        paths.remove(this);
        return false;
    }

    @Override
    public Object[] findResource(String symbolicName, String imagePath) {
        return null;
    }
}

