/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.xwt.model.widgets;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.core.model.broadcast.ObjectInfoTreeComplete;
import org.eclipse.wb.draw2d.geometry.Insets;
import org.eclipse.wb.internal.core.model.description.LayoutDescription;
import org.eclipse.wb.internal.core.model.description.ToolkitDescription;
import org.eclipse.wb.internal.core.model.description.helpers.LayoutDescriptionHelper;
import org.eclipse.wb.internal.core.model.util.ObjectInfoAction;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.ui.ImageImageDescriptor;
import org.eclipse.wb.internal.core.xml.model.EditorContext;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.association.Association;
import org.eclipse.wb.internal.core.xml.model.association.Associations;
import org.eclipse.wb.internal.core.xml.model.broadcast.XmlObjectClipboardCopy;
import org.eclipse.wb.internal.core.xml.model.clipboard.ClipboardCommand;
import org.eclipse.wb.internal.core.xml.model.clipboard.XmlObjectMemento;
import org.eclipse.wb.internal.core.xml.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.xml.model.creation.ElementCreationSupport;
import org.eclipse.wb.internal.core.xml.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.xml.model.description.ComponentDescriptionHelper;
import org.eclipse.wb.internal.core.xml.model.utils.XmlObjectUtils;
import org.eclipse.wb.internal.rcp.RcpToolkitDescription;
import org.eclipse.wb.internal.swt.Activator;
import org.eclipse.wb.internal.swt.model.widgets.ICompositeInfo;
import org.eclipse.wb.internal.xwt.model.layout.AbsoluteLayoutInfo;
import org.eclipse.wb.internal.xwt.model.layout.CompositeClipboardCommand;
import org.eclipse.wb.internal.xwt.model.layout.ImplicitLayoutCreationSupport;
import org.eclipse.wb.internal.xwt.model.layout.LayoutInfo;
import org.eclipse.wb.internal.xwt.model.widgets.ControlInfo;
import org.eclipse.wb.internal.xwt.model.widgets.ScrollableInfo;
import org.eclipse.wb.internal.xwt.support.ControlSupport;
import org.eclipse.wb.internal.xwt.support.CoordinateUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeInfo
extends ScrollableInfo
implements ICompositeInfo {
    private Insets m_clientAreaInsets2;
    private static final String KEY_LAYOUT_HAS = "layout.has";
    public static final String KEY_LAYOUT_REPLACING = "We replace Layout, don't set implicit now.";

    public CompositeInfo(EditorContext context, ComponentDescription description, CreationSupport creationSupport) throws Exception {
        super(context, description, creationSupport);
        this.contributeToContextMenu();
        this.contributeToClipboardCopy();
        this.createExplicitAbsoluteLayout();
    }

    protected void createExposedChildren() throws Exception {
        super.createExposedChildren();
        this.createImplicitLayout();
    }

    private void contributeToContextMenu() {
        this.addBroadcastListener(new ObjectEventListener(){

            public void addContextMenu(List<? extends ObjectInfo> objects, ObjectInfo object, IMenuManager manager) throws Exception {
                if (object == CompositeInfo.this) {
                    CompositeInfo.this.fillContextMenu(manager);
                }
            }
        });
    }

    private void fillContextMenu(IMenuManager manager) throws Exception {
        if (this.hasLayout()) {
            MenuManager layoutsManager = new MenuManager("Set layout");
            manager.appendToGroup("org.eclipse.wb.popup.group.layout", (IContributionItem)layoutsManager);
            this.fillLayoutsManager((IMenuManager)layoutsManager);
        }
    }

    public void fillLayoutsManager(IMenuManager layoutsManager) throws Exception {
        final EditorContext context = this.getContext();
        ObjectInfoAction action = new ObjectInfoAction((ObjectInfo)this){

            protected void runEx() throws Exception {
                AbsoluteLayoutInfo layout = AbsoluteLayoutInfo.createExplicitModel(context);
                CompositeInfo.this.setLayout(layout);
            }
        };
        action.setText("Absolute layout");
        action.setImageDescriptor(Activator.getImageDescriptor((String)"info/layout/absolute/layout.gif"));
        layoutsManager.add((IAction)action);
        List descriptions = LayoutDescriptionHelper.get((ToolkitDescription)RcpToolkitDescription.INSTANCE);
        for (final LayoutDescription description : descriptions) {
            String className = description.getLayoutClassName();
            final String creationId = description.getCreationId();
            final ComponentDescription layoutComponentDescription = ComponentDescriptionHelper.getDescription((EditorContext)context, (String)className);
            if (className.equals("org.eclipse.wb.swt.layout.grouplayout.GroupLayout")) continue;
            ObjectInfoAction action2 = new ObjectInfoAction((ObjectInfo)this){

                protected void runEx() throws Exception {
                    description.ensureLibraries(context.getJavaProject());
                    LayoutInfo layout = (LayoutInfo)XmlObjectUtils.createObject((EditorContext)context, (ComponentDescription)layoutComponentDescription, (CreationSupport)new ElementCreationSupport(creationId));
                    CompositeInfo.this.setLayout(layout);
                }
            };
            action2.setText(description.getName());
            action2.setImageDescriptor((ImageDescriptor)new ImageImageDescriptor(layoutComponentDescription.getIcon()));
            layoutsManager.add((IAction)action2);
        }
    }

    public final List<ControlInfo> getChildrenControls() {
        return this.getChildren(ControlInfo.class);
    }

    public Insets getClientAreaInsets2() {
        return this.m_clientAreaInsets2;
    }

    public final Composite getComposite() {
        return (Composite)this.getObject();
    }

    @Override
    protected void refresh_fetch() throws Exception {
        this.m_clientAreaInsets2 = CoordinateUtils.getClientAreaInsets2(this.getComposite());
        super.refresh_fetch();
    }

    public final boolean hasLayout() {
        return XmlObjectUtils.hasTrueParameter((XmlObjectInfo)this, (String)KEY_LAYOUT_HAS);
    }

    public final LayoutInfo getLayout() {
        Assert.isTrueException((boolean)this.hasLayout(), (int)3502, (Object[])new Object[]{this});
        for (ObjectInfo child : this.getChildren()) {
            if (!(child instanceof LayoutInfo)) continue;
            return (LayoutInfo)child;
        }
        throw new IllegalStateException("Composite should always have layout");
    }

    private void createImplicitLayout() throws Exception {
        LayoutInfo implicitLayout;
        if (!this.hasLayout()) {
            return;
        }
        ImplicitLayoutCreationSupport creationSupport = new ImplicitLayoutCreationSupport(this);
        Layout layout = ((Composite)this.getObject()).getLayout();
        if (layout == null) {
            implicitLayout = new AbsoluteLayoutInfo(this.getContext(), creationSupport);
        } else {
            Class<?> layoutClass = layout.getClass();
            implicitLayout = (LayoutInfo)XmlObjectUtils.createObject((EditorContext)this.getContext(), layoutClass, (CreationSupport)creationSupport);
        }
        this.addChildFirst((ObjectInfo)implicitLayout);
    }

    private void createExplicitAbsoluteLayout() {
        this.addBroadcastListener(new ObjectInfoTreeComplete(){

            public void invoke() throws Exception {
                if (CompositeInfo.this.getCreationSupport() instanceof ElementCreationSupport && CompositeInfo.this.getComposite().getLayout() == null && CompositeInfo.this.getAttribute("layout") != null) {
                    AbsoluteLayoutInfo layout = AbsoluteLayoutInfo.createExplicitModel(CompositeInfo.this.getContext());
                    CompositeInfo.this.addChildFirst((ObjectInfo)layout);
                }
            }
        });
    }

    public void setLayout(final LayoutInfo newLayout) throws Exception {
        ExecutionUtils.run((ObjectInfo)this, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                CompositeInfo.this.setLayoutEx(newLayout);
            }
        });
    }

    private void setLayoutEx(LayoutInfo newLayout) throws Exception {
        LayoutInfo oldLayout = this.getLayout();
        oldLayout.delete();
        if (newLayout instanceof AbsoluteLayoutInfo) {
            this.addChildFirst((ObjectInfo)newLayout);
            newLayout.getCreationSupport().addElement(this.getElement(), 0);
        } else {
            XmlObjectUtils.addFirst((XmlObjectInfo)newLayout, (Association)Associations.property((String)"layout"), (XmlObjectInfo)this);
        }
        newLayout.onSet();
    }

    public boolean shouldDrawDotsBorder() throws Exception {
        Composite composite = this.getComposite();
        if (ControlSupport.hasStyle((Widget)composite, 2048)) {
            return false;
        }
        String script = XmlObjectUtils.getParameter((XmlObjectInfo)this, (String)"shouldDrawBorder");
        if (StringUtils.isEmpty((String)script)) {
            return false;
        }
        return (Boolean)XmlObjectUtils.executeScript((XmlObjectInfo)this, (String)script);
    }

    private void contributeToClipboardCopy() {
        this.addBroadcastListener(new XmlObjectClipboardCopy(){

            public void invoke(XmlObjectInfo object, List<ClipboardCommand> commands) throws Exception {
                if (object == CompositeInfo.this) {
                    CompositeInfo.this.clipboardCopy_addCommands(commands);
                }
            }
        });
    }

    protected void clipboardCopy_addCommands(List<ClipboardCommand> commands) throws Exception {
        LayoutInfo layout;
        if (this.hasLayout() && !XmlObjectUtils.isImplicit((XmlObjectInfo)(layout = this.getLayout()))) {
            final XmlObjectMemento layoutMemento = XmlObjectMemento.createMemento((XmlObjectInfo)layout);
            commands.add(new CompositeClipboardCommand(){
                private static final long serialVersionUID = 0L;

                public void execute(CompositeInfo composite) throws Exception {
                    LayoutInfo newLayout = (LayoutInfo)layoutMemento.create((XmlObjectInfo)composite);
                    composite.setLayout(newLayout);
                    layoutMemento.apply();
                }
            });
        }
    }
}

