// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package acl

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetACLFCGIAppOKCode is the HTTP code returned for type GetACLFCGIAppOK
const GetACLFCGIAppOKCode int = 200

/*
GetACLFCGIAppOK Successful operation

swagger:response getAclFcgiAppOK
*/
type GetACLFCGIAppOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.ACL `json:"body,omitempty"`
}

// NewGetACLFCGIAppOK creates GetACLFCGIAppOK with default headers values
func NewGetACLFCGIAppOK() *GetACLFCGIAppOK {

	return &GetACLFCGIAppOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get Acl Fcgi app o k response
func (o *GetACLFCGIAppOK) WithConfigurationVersion(configurationVersion string) *GetACLFCGIAppOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get Acl Fcgi app o k response
func (o *GetACLFCGIAppOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get Acl Fcgi app o k response
func (o *GetACLFCGIAppOK) WithPayload(payload *models.ACL) *GetACLFCGIAppOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get Acl Fcgi app o k response
func (o *GetACLFCGIAppOK) SetPayload(payload *models.ACL) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetACLFCGIAppOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetACLFCGIAppNotFoundCode is the HTTP code returned for type GetACLFCGIAppNotFound
const GetACLFCGIAppNotFoundCode int = 404

/*
GetACLFCGIAppNotFound The specified resource was not found

swagger:response getAclFcgiAppNotFound
*/
type GetACLFCGIAppNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetACLFCGIAppNotFound creates GetACLFCGIAppNotFound with default headers values
func NewGetACLFCGIAppNotFound() *GetACLFCGIAppNotFound {

	return &GetACLFCGIAppNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the get Acl Fcgi app not found response
func (o *GetACLFCGIAppNotFound) WithConfigurationVersion(configurationVersion string) *GetACLFCGIAppNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get Acl Fcgi app not found response
func (o *GetACLFCGIAppNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get Acl Fcgi app not found response
func (o *GetACLFCGIAppNotFound) WithPayload(payload *models.Error) *GetACLFCGIAppNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get Acl Fcgi app not found response
func (o *GetACLFCGIAppNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetACLFCGIAppNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
GetACLFCGIAppDefault General Error

swagger:response getAclFcgiAppDefault
*/
type GetACLFCGIAppDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetACLFCGIAppDefault creates GetACLFCGIAppDefault with default headers values
func NewGetACLFCGIAppDefault(code int) *GetACLFCGIAppDefault {
	if code <= 0 {
		code = 500
	}

	return &GetACLFCGIAppDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get Acl FCGI app default response
func (o *GetACLFCGIAppDefault) WithStatusCode(code int) *GetACLFCGIAppDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get Acl FCGI app default response
func (o *GetACLFCGIAppDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get Acl FCGI app default response
func (o *GetACLFCGIAppDefault) WithConfigurationVersion(configurationVersion string) *GetACLFCGIAppDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get Acl FCGI app default response
func (o *GetACLFCGIAppDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get Acl FCGI app default response
func (o *GetACLFCGIAppDefault) WithPayload(payload *models.Error) *GetACLFCGIAppDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get Acl FCGI app default response
func (o *GetACLFCGIAppDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetACLFCGIAppDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
