// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package specification

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetSpecificationOKCode is the HTTP code returned for type GetSpecificationOK
const GetSpecificationOKCode int = 200

/*
GetSpecificationOK Success

swagger:response getSpecificationOK
*/
type GetSpecificationOK struct {

	/*
	  In: Body
	*/
	Payload interface{} `json:"body,omitempty"`
}

// NewGetSpecificationOK creates GetSpecificationOK with default headers values
func NewGetSpecificationOK() *GetSpecificationOK {

	return &GetSpecificationOK{}
}

// WithPayload adds the payload to the get specification o k response
func (o *GetSpecificationOK) WithPayload(payload interface{}) *GetSpecificationOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get specification o k response
func (o *GetSpecificationOK) SetPayload(payload interface{}) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetSpecificationOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	payload := o.Payload
	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

/*
GetSpecificationDefault General Error

swagger:response getSpecificationDefault
*/
type GetSpecificationDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetSpecificationDefault creates GetSpecificationDefault with default headers values
func NewGetSpecificationDefault(code int) *GetSpecificationDefault {
	if code <= 0 {
		code = 500
	}

	return &GetSpecificationDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get specification default response
func (o *GetSpecificationDefault) WithStatusCode(code int) *GetSpecificationDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get specification default response
func (o *GetSpecificationDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get specification default response
func (o *GetSpecificationDefault) WithConfigurationVersion(configurationVersion string) *GetSpecificationDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get specification default response
func (o *GetSpecificationDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get specification default response
func (o *GetSpecificationDefault) WithPayload(payload *models.Error) *GetSpecificationDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get specification default response
func (o *GetSpecificationDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetSpecificationDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
