// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"io"
	"mime/multipart"
	"net/http"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/runtime/middleware"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// ReplaceStorageGeneralFileMaxParseMemory sets the maximum size in bytes for
// the multipart form parser for this operation.
//
// The default value is 32 MB.
// The multipart parser stores up to this + 10MB.
var ReplaceStorageGeneralFileMaxParseMemory int64 = 32 << 20

// NewReplaceStorageGeneralFileParams creates a new ReplaceStorageGeneralFileParams object
// with the default values initialized.
func NewReplaceStorageGeneralFileParams() ReplaceStorageGeneralFileParams {

	var (
		// initialize parameters with default values

		forceReloadDefault = bool(false)

		skipReloadDefault = bool(false)
	)

	return ReplaceStorageGeneralFileParams{
		ForceReload: &forceReloadDefault,

		SkipReload: &skipReloadDefault,
	}
}

// ReplaceStorageGeneralFileParams contains all the bound params for the replace storage general file operation
// typically these are obtained from a http.Request
//
// swagger:parameters replaceStorageGeneralFile
type ReplaceStorageGeneralFileParams struct {

	// HTTP Request Object
	HTTPRequest *http.Request `json:"-"`

	/*General use file content
	  In: formData
	*/
	FileUpload io.ReadCloser
	/*If set, do a force reload, do not wait for the configured reload-delay. Cannot be used when transaction is specified, as changes in transaction are not applied directly to configuration.
	  In: query
	  Default: false
	*/
	ForceReload *bool
	/*General use file storage_name
	  Required: true
	  In: path
	*/
	Name string
	/*If set, no reload will be initiated after update
	  In: query
	  Default: false
	*/
	SkipReload *bool
}

// BindRequest both binds and validates a request, it assumes that complex things implement a Validatable(strfmt.Registry) error interface
// for simple values it will use straight method calls.
//
// To ensure default values, the struct must have been initialized with NewReplaceStorageGeneralFileParams() beforehand.
func (o *ReplaceStorageGeneralFileParams) BindRequest(r *http.Request, route *middleware.MatchedRoute) error {
	var res []error

	o.HTTPRequest = r

	qs := runtime.Values(r.URL.Query())

	if err := r.ParseMultipartForm(ReplaceStorageGeneralFileMaxParseMemory); err != nil {
		if err != http.ErrNotMultipart {
			return errors.New(400, "%v", err)
		} else if err := r.ParseForm(); err != nil {
			return errors.New(400, "%v", err)
		}
	}

	fileUpload, fileUploadHeader, err := r.FormFile("file_upload")
	if err != nil && err != http.ErrMissingFile {
		res = append(res, errors.New(400, "reading file %q failed: %v", "fileUpload", err))
	} else if err == http.ErrMissingFile {
		// no-op for missing but optional file parameter
	} else if err := o.bindFileUpload(fileUpload, fileUploadHeader); err != nil {
		res = append(res, err)
	} else {
		o.FileUpload = &runtime.File{Data: fileUpload, Header: fileUploadHeader}
	}

	qForceReload, qhkForceReload, _ := qs.GetOK("force_reload")
	if err := o.bindForceReload(qForceReload, qhkForceReload, route.Formats); err != nil {
		res = append(res, err)
	}

	rName, rhkName, _ := route.Params.GetOK("name")
	if err := o.bindName(rName, rhkName, route.Formats); err != nil {
		res = append(res, err)
	}

	qSkipReload, qhkSkipReload, _ := qs.GetOK("skip_reload")
	if err := o.bindSkipReload(qSkipReload, qhkSkipReload, route.Formats); err != nil {
		res = append(res, err)
	}
	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindFileUpload binds file parameter FileUpload.
//
// The only supported validations on files are MinLength and MaxLength
func (o *ReplaceStorageGeneralFileParams) bindFileUpload(file multipart.File, header *multipart.FileHeader) error {
	return nil
}

// bindForceReload binds and validates parameter ForceReload from query.
func (o *ReplaceStorageGeneralFileParams) bindForceReload(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: false
	// AllowEmptyValue: false

	if raw == "" { // empty values pass all other validations
		// Default values have been previously initialized by NewReplaceStorageGeneralFileParams()
		return nil
	}

	value, err := swag.ConvertBool(raw)
	if err != nil {
		return errors.InvalidType("force_reload", "query", "bool", raw)
	}
	o.ForceReload = &value

	return nil
}

// bindName binds and validates parameter Name from path.
func (o *ReplaceStorageGeneralFileParams) bindName(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: true
	// Parameter is provided by construction from the route
	o.Name = raw

	return nil
}

// bindSkipReload binds and validates parameter SkipReload from query.
func (o *ReplaceStorageGeneralFileParams) bindSkipReload(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: false
	// AllowEmptyValue: false

	if raw == "" { // empty values pass all other validations
		// Default values have been previously initialized by NewReplaceStorageGeneralFileParams()
		return nil
	}

	value, err := swag.ConvertBool(raw)
	if err != nil {
		return errors.InvalidType("skip_reload", "query", "bool", raw)
	}
	o.SkipReload = &value

	return nil
}
