// Copyright (c) 2012 Ecma International.  All rights reserved.
// Ecma International makes this code available under the terms and conditions set
// forth on http://hg.ecmascript.org/tests/test262/raw-file/tip/LICENSE (the
// "Use Terms").   Any redistribution of this code must retain the above
// copyright and this notice and otherwise comply with the Use Terms.

/*---
es5id: 15.2.3.14-5-16
description: >
    Object.keys - own enumerable indexed accessor property of String
    object 'O' is defined in returned array
includes: [runTestCase.js]
---*/

function testcase() {
        var obj = new String("xyz");
        obj[-20] = -20;
        obj[20] = 20;

        Object.defineProperty(obj, "prop1", {
            get: function () { },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(obj, "prop2", {
            get: function () { },
            enumerable: false,
            configurable: true
        });

        var arr = Object.keys(obj);

        for (var i = 0; i < arr.length; i++) {
            if (!obj.hasOwnProperty(arr[i])) {
                return false;
            }
        }

        return true;
    }
runTestCase(testcase);
