// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/v2/dataset.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERYCONTROL_V2_INTERNAL_DATASET_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERYCONTROL_V2_INTERNAL_DATASET_TRACING_CONNECTION_H

#include "google/cloud/bigquerycontrol/v2/dataset_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace bigquerycontrol_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class DatasetServiceTracingConnection
    : public bigquerycontrol_v2::DatasetServiceConnection {
 public:
  ~DatasetServiceTracingConnection() override = default;

  explicit DatasetServiceTracingConnection(
      std::shared_ptr<bigquerycontrol_v2::DatasetServiceConnection> child);

  Options options() override { return child_->options(); }

  StatusOr<google::cloud::bigquery::v2::Dataset> GetDataset(
      google::cloud::bigquery::v2::GetDatasetRequest const& request) override;

  StatusOr<google::cloud::bigquery::v2::Dataset> InsertDataset(
      google::cloud::bigquery::v2::InsertDatasetRequest const& request)
      override;

  StatusOr<google::cloud::bigquery::v2::Dataset> PatchDataset(
      google::cloud::bigquery::v2::UpdateOrPatchDatasetRequest const& request)
      override;

  StatusOr<google::cloud::bigquery::v2::Dataset> UpdateDataset(
      google::cloud::bigquery::v2::UpdateOrPatchDatasetRequest const& request)
      override;

  Status DeleteDataset(google::cloud::bigquery::v2::DeleteDatasetRequest const&
                           request) override;

  StreamRange<google::cloud::bigquery::v2::ListFormatDataset> ListDatasets(
      google::cloud::bigquery::v2::ListDatasetsRequest request) override;

  StatusOr<google::cloud::bigquery::v2::Dataset> UndeleteDataset(
      google::cloud::bigquery::v2::UndeleteDatasetRequest const& request)
      override;

 private:
  std::shared_ptr<bigquerycontrol_v2::DatasetServiceConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<bigquerycontrol_v2::DatasetServiceConnection>
MakeDatasetServiceTracingConnection(
    std::shared_ptr<bigquerycontrol_v2::DatasetServiceConnection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquerycontrol_v2_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERYCONTROL_V2_INTERNAL_DATASET_TRACING_CONNECTION_H
