// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/cloudcontrolspartner/v1/core.proto

#include "google/cloud/cloudcontrolspartner/v1/internal/cloud_controls_partner_core_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace cloudcontrolspartner_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

CloudControlsPartnerCoreTracingStub::CloudControlsPartnerCoreTracingStub(
    std::shared_ptr<CloudControlsPartnerCoreStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::cloud::cloudcontrolspartner::v1::Workload>
CloudControlsPartnerCoreTracingStub::GetWorkload(
    grpc::ClientContext& context, Options const& options,
    google::cloud::cloudcontrolspartner::v1::GetWorkloadRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.cloudcontrolspartner.v1.CloudControlsPartnerCore",
      "GetWorkload");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetWorkload(context, options, request));
}

StatusOr<google::cloud::cloudcontrolspartner::v1::ListWorkloadsResponse>
CloudControlsPartnerCoreTracingStub::ListWorkloads(
    grpc::ClientContext& context, Options const& options,
    google::cloud::cloudcontrolspartner::v1::ListWorkloadsRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.cloudcontrolspartner.v1.CloudControlsPartnerCore",
      "ListWorkloads");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListWorkloads(context, options, request));
}

StatusOr<google::cloud::cloudcontrolspartner::v1::Customer>
CloudControlsPartnerCoreTracingStub::GetCustomer(
    grpc::ClientContext& context, Options const& options,
    google::cloud::cloudcontrolspartner::v1::GetCustomerRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.cloudcontrolspartner.v1.CloudControlsPartnerCore",
      "GetCustomer");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetCustomer(context, options, request));
}

StatusOr<google::cloud::cloudcontrolspartner::v1::ListCustomersResponse>
CloudControlsPartnerCoreTracingStub::ListCustomers(
    grpc::ClientContext& context, Options const& options,
    google::cloud::cloudcontrolspartner::v1::ListCustomersRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.cloudcontrolspartner.v1.CloudControlsPartnerCore",
      "ListCustomers");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListCustomers(context, options, request));
}

StatusOr<google::cloud::cloudcontrolspartner::v1::EkmConnections>
CloudControlsPartnerCoreTracingStub::GetEkmConnections(
    grpc::ClientContext& context, Options const& options,
    google::cloud::cloudcontrolspartner::v1::GetEkmConnectionsRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.cloudcontrolspartner.v1.CloudControlsPartnerCore",
      "GetEkmConnections");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->GetEkmConnections(context, options, request));
}

StatusOr<google::cloud::cloudcontrolspartner::v1::PartnerPermissions>
CloudControlsPartnerCoreTracingStub::GetPartnerPermissions(
    grpc::ClientContext& context, Options const& options,
    google::cloud::cloudcontrolspartner::v1::GetPartnerPermissionsRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.cloudcontrolspartner.v1.CloudControlsPartnerCore",
      "GetPartnerPermissions");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->GetPartnerPermissions(context, options, request));
}

StatusOr<
    google::cloud::cloudcontrolspartner::v1::ListAccessApprovalRequestsResponse>
CloudControlsPartnerCoreTracingStub::ListAccessApprovalRequests(
    grpc::ClientContext& context, Options const& options,
    google::cloud::cloudcontrolspartner::v1::
        ListAccessApprovalRequestsRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.cloudcontrolspartner.v1.CloudControlsPartnerCore",
      "ListAccessApprovalRequests");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->ListAccessApprovalRequests(context, options, request));
}

StatusOr<google::cloud::cloudcontrolspartner::v1::Partner>
CloudControlsPartnerCoreTracingStub::GetPartner(
    grpc::ClientContext& context, Options const& options,
    google::cloud::cloudcontrolspartner::v1::GetPartnerRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.cloudcontrolspartner.v1.CloudControlsPartnerCore",
      "GetPartner");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetPartner(context, options, request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<CloudControlsPartnerCoreStub>
MakeCloudControlsPartnerCoreTracingStub(
    std::shared_ptr<CloudControlsPartnerCoreStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<CloudControlsPartnerCoreTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace cloudcontrolspartner_v1_internal
}  // namespace cloud
}  // namespace google
