// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/instance_settings/v1/instance_settings.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_INSTANCE_SETTINGS_V1_INSTANCE_SETTINGS_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_INSTANCE_SETTINGS_V1_INSTANCE_SETTINGS_CLIENT_H

#include "google/cloud/compute/instance_settings/v1/instance_settings_rest_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace compute_instance_settings_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Service for the instanceSettings resource.
/// https://cloud.google.com/compute/docs/reference/rest/v1/instanceSettings
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class InstanceSettingsClient {
 public:
  explicit InstanceSettingsClient(
      std::shared_ptr<InstanceSettingsConnection> connection,
      Options opts = {});
  ~InstanceSettingsClient();

  ///@{
  /// @name Copy and move support
  InstanceSettingsClient(InstanceSettingsClient const&) = default;
  InstanceSettingsClient& operator=(InstanceSettingsClient const&) = default;
  InstanceSettingsClient(InstanceSettingsClient&&) = default;
  InstanceSettingsClient& operator=(InstanceSettingsClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(InstanceSettingsClient const& a,
                         InstanceSettingsClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(InstanceSettingsClient const& a,
                         InstanceSettingsClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Get Instance settings.
  /// https://cloud.google.com/compute/docs/reference/rest/v1/instanceSettings/get
  ///
  /// @param project  Project ID for this request.
  /// @param zone  Name of the zone for this request.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.cpp.compute.v1.InstanceSettings])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.cpp.compute.instance_settings.v1.GetInstanceSettingsRequest]: @cloud_cpp_reference_link{google/cloud/compute/instance_settings/v1/instance_settings.proto#L65}
  /// [google.cloud.cpp.compute.v1.InstanceSettings]: @cloud_cpp_reference_link{google/cloud/compute/v1/internal/common_064.proto#L27}
  ///
  // clang-format on
  StatusOr<google::cloud::cpp::compute::v1::InstanceSettings>
  GetInstanceSettings(std::string const& project, std::string const& zone,
                      Options opts = {});

  // clang-format off
  ///
  /// Get Instance settings.
  /// https://cloud.google.com/compute/docs/reference/rest/v1/instanceSettings/get
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.cpp.compute.instance_settings.v1.GetInstanceSettingsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.cpp.compute.v1.InstanceSettings])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.cpp.compute.instance_settings.v1.GetInstanceSettingsRequest]: @cloud_cpp_reference_link{google/cloud/compute/instance_settings/v1/instance_settings.proto#L65}
  /// [google.cloud.cpp.compute.v1.InstanceSettings]: @cloud_cpp_reference_link{google/cloud/compute/v1/internal/common_064.proto#L27}
  ///
  // clang-format on
  StatusOr<google::cloud::cpp::compute::v1::InstanceSettings>
  GetInstanceSettings(google::cloud::cpp::compute::instance_settings::v1::
                          GetInstanceSettingsRequest const& request,
                      Options opts = {});

  // clang-format off
  ///
  /// Patch Instance settings
  /// https://cloud.google.com/compute/docs/reference/rest/v1/instanceSettings/patch
  ///
  /// @param project  Project ID for this request.
  /// @param zone  The zone scoping this request. It should conform to RFC1035.
  /// @param update_mask  update_mask indicates fields to be updated as part of this request.
  /// @param instance_settings_resource  The InstanceSettings for this request.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.cpp.compute.v1.Operation] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: http://cloud/compute/docs/api/how-tos/api-requests-responses#handling_api_responses
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.cpp.compute.instance_settings.v1.PatchInstanceSettingsRequest]: @cloud_cpp_reference_link{google/cloud/compute/instance_settings/v1/instance_settings.proto#L75}
  ///
  // clang-format on
  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  PatchInstanceSettings(std::string const& project, std::string const& zone,
                        std::string const& update_mask,
                        google::cloud::cpp::compute::v1::InstanceSettings const&
                            instance_settings_resource,
                        Options opts = {});

  // clang-format off
  ///
  /// @copybrief PatchInstanceSettings
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::cloud::cpp::compute::v1::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::cloud::cpp::compute::v1::Operation> PatchInstanceSettings(
      NoAwaitTag, std::string const& project, std::string const& zone,
      std::string const& update_mask,
      google::cloud::cpp::compute::v1::InstanceSettings const&
          instance_settings_resource,
      Options opts = {});

  // clang-format off
  ///
  /// Patch Instance settings
  /// https://cloud.google.com/compute/docs/reference/rest/v1/instanceSettings/patch
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.cpp.compute.instance_settings.v1.PatchInstanceSettingsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.cpp.compute.v1.Operation] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: http://cloud/compute/docs/api/how-tos/api-requests-responses#handling_api_responses
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.cpp.compute.instance_settings.v1.PatchInstanceSettingsRequest]: @cloud_cpp_reference_link{google/cloud/compute/instance_settings/v1/instance_settings.proto#L75}
  ///
  // clang-format on
  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  PatchInstanceSettings(google::cloud::cpp::compute::instance_settings::v1::
                            PatchInstanceSettingsRequest const& request,
                        Options opts = {});

  // clang-format off
  ///
  /// @copybrief PatchInstanceSettings
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::cloud::cpp::compute::v1::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::cloud::cpp::compute::v1::Operation> PatchInstanceSettings(
      NoAwaitTag,
      google::cloud::cpp::compute::instance_settings::v1::
          PatchInstanceSettingsRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief PatchInstanceSettings
  ///
  /// This method accepts a `google::cloud::cpp::compute::v1::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  PatchInstanceSettings(
      google::cloud::cpp::compute::v1::Operation const& operation,
      Options opts = {});

 private:
  std::shared_ptr<InstanceSettingsConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_instance_settings_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_INSTANCE_SETTINGS_V1_INSTANCE_SETTINGS_CLIENT_H
