// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/instant_snapshots/v1/instant_snapshots.proto

#include "google/cloud/compute/instant_snapshots/v1/instant_snapshots_connection.h"
#include "google/cloud/compute/instant_snapshots/v1/instant_snapshots_options.h"
#include "google/cloud/compute/instant_snapshots/v1/internal/instant_snapshots_option_defaults.h"
#include "google/cloud/compute/instant_snapshots/v1/internal/instant_snapshots_tracing_connection.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace compute_instant_snapshots_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

InstantSnapshotsConnection::~InstantSnapshotsConnection() = default;

StreamRange<std::pair<
    std::string, google::cloud::cpp::compute::v1::InstantSnapshotsScopedList>>
InstantSnapshotsConnection::AggregatedListInstantSnapshots(
    google::cloud::cpp::compute::instant_snapshots::v1::
        AggregatedListInstantSnapshotsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<std::pair<std::string, google::cloud::cpp::compute::v1::
                                             InstantSnapshotsScopedList>>>();
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstantSnapshotsConnection::DeleteInstantSnapshot(
    google::cloud::cpp::compute::instant_snapshots::v1::
        DeleteInstantSnapshotRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::cpp::compute::v1::Operation>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
InstantSnapshotsConnection::DeleteInstantSnapshot(
    NoAwaitTag, google::cloud::cpp::compute::instant_snapshots::v1::
                    DeleteInstantSnapshotRequest const&) {
  return StatusOr<google::cloud::cpp::compute::v1::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstantSnapshotsConnection::DeleteInstantSnapshot(
    google::cloud::cpp::compute::v1::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::cpp::compute::v1::Operation>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::cpp::compute::v1::InstantSnapshot>
InstantSnapshotsConnection::GetInstantSnapshot(
    google::cloud::cpp::compute::instant_snapshots::v1::
        GetInstantSnapshotRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::cpp::compute::v1::Policy>
InstantSnapshotsConnection::GetIamPolicy(
    google::cloud::cpp::compute::instant_snapshots::v1::
        GetIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstantSnapshotsConnection::InsertInstantSnapshot(
    google::cloud::cpp::compute::instant_snapshots::v1::
        InsertInstantSnapshotRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::cpp::compute::v1::Operation>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
InstantSnapshotsConnection::InsertInstantSnapshot(
    NoAwaitTag, google::cloud::cpp::compute::instant_snapshots::v1::
                    InsertInstantSnapshotRequest const&) {
  return StatusOr<google::cloud::cpp::compute::v1::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstantSnapshotsConnection::InsertInstantSnapshot(
    google::cloud::cpp::compute::v1::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::cpp::compute::v1::Operation>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::cpp::compute::v1::InstantSnapshot>
InstantSnapshotsConnection::ListInstantSnapshots(
    google::cloud::cpp::compute::instant_snapshots::v1::
        ListInstantSnapshotsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::cpp::compute::v1::InstantSnapshot>>();
}

StatusOr<google::cloud::cpp::compute::v1::Policy>
InstantSnapshotsConnection::SetIamPolicy(
    google::cloud::cpp::compute::instant_snapshots::v1::
        SetIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstantSnapshotsConnection::SetLabels(
    google::cloud::cpp::compute::instant_snapshots::v1::
        SetLabelsRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::cpp::compute::v1::Operation>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
InstantSnapshotsConnection::SetLabels(
    NoAwaitTag, google::cloud::cpp::compute::instant_snapshots::v1::
                    SetLabelsRequest const&) {
  return StatusOr<google::cloud::cpp::compute::v1::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstantSnapshotsConnection::SetLabels(
    google::cloud::cpp::compute::v1::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::cpp::compute::v1::Operation>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::cpp::compute::v1::TestPermissionsResponse>
InstantSnapshotsConnection::TestIamPermissions(
    google::cloud::cpp::compute::instant_snapshots::v1::
        TestIamPermissionsRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_instant_snapshots_v1
}  // namespace cloud
}  // namespace google
