// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/node_groups/v1/node_groups.proto

#include "google/cloud/compute/node_groups/v1/internal/node_groups_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace compute_node_groups_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

NodeGroupsTracingConnection::NodeGroupsTracingConnection(
    std::shared_ptr<compute_node_groups_v1::NodeGroupsConnection> child)
    : child_(std::move(child)) {}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NodeGroupsTracingConnection::AddNodes(
    google::cloud::cpp::compute::node_groups::v1::AddNodesRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_node_groups_v1::NodeGroupsConnection::AddNodes");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->AddNodes(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
NodeGroupsTracingConnection::AddNodes(
    NoAwaitTag,
    google::cloud::cpp::compute::node_groups::v1::AddNodesRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_node_groups_v1::NodeGroupsConnection::AddNodes");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->AddNodes(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NodeGroupsTracingConnection::AddNodes(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_node_groups_v1::NodeGroupsConnection::AddNodes");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->AddNodes(operation));
}

StreamRange<std::pair<std::string,
                      google::cloud::cpp::compute::v1::NodeGroupsScopedList>>
NodeGroupsTracingConnection::AggregatedListNodeGroups(
    google::cloud::cpp::compute::node_groups::v1::
        AggregatedListNodeGroupsRequest request) {
  auto span = internal::MakeSpan(
      "compute_node_groups_v1::NodeGroupsConnection::AggregatedListNodeGroups");
  internal::OTelScope scope(span);
  auto sr = child_->AggregatedListNodeGroups(std::move(request));
  return internal::MakeTracedStreamRange<std::pair<
      std::string, google::cloud::cpp::compute::v1::NodeGroupsScopedList>>(
      std::move(span), std::move(sr));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NodeGroupsTracingConnection::DeleteNodeGroup(
    google::cloud::cpp::compute::node_groups::v1::DeleteNodeGroupRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_node_groups_v1::NodeGroupsConnection::DeleteNodeGroup");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteNodeGroup(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
NodeGroupsTracingConnection::DeleteNodeGroup(
    NoAwaitTag,
    google::cloud::cpp::compute::node_groups::v1::DeleteNodeGroupRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_node_groups_v1::NodeGroupsConnection::DeleteNodeGroup");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->DeleteNodeGroup(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NodeGroupsTracingConnection::DeleteNodeGroup(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_node_groups_v1::NodeGroupsConnection::DeleteNodeGroup");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteNodeGroup(operation));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NodeGroupsTracingConnection::DeleteNodes(
    google::cloud::cpp::compute::node_groups::v1::DeleteNodesRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_node_groups_v1::NodeGroupsConnection::DeleteNodes");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteNodes(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
NodeGroupsTracingConnection::DeleteNodes(
    NoAwaitTag,
    google::cloud::cpp::compute::node_groups::v1::DeleteNodesRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_node_groups_v1::NodeGroupsConnection::DeleteNodes");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->DeleteNodes(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NodeGroupsTracingConnection::DeleteNodes(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_node_groups_v1::NodeGroupsConnection::DeleteNodes");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteNodes(operation));
}

StatusOr<google::cloud::cpp::compute::v1::NodeGroup>
NodeGroupsTracingConnection::GetNodeGroup(
    google::cloud::cpp::compute::node_groups::v1::GetNodeGroupRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_node_groups_v1::NodeGroupsConnection::GetNodeGroup");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetNodeGroup(request));
}

StatusOr<google::cloud::cpp::compute::v1::Policy>
NodeGroupsTracingConnection::GetIamPolicy(
    google::cloud::cpp::compute::node_groups::v1::GetIamPolicyRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_node_groups_v1::NodeGroupsConnection::GetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetIamPolicy(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NodeGroupsTracingConnection::InsertNodeGroup(
    google::cloud::cpp::compute::node_groups::v1::InsertNodeGroupRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_node_groups_v1::NodeGroupsConnection::InsertNodeGroup");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->InsertNodeGroup(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
NodeGroupsTracingConnection::InsertNodeGroup(
    NoAwaitTag,
    google::cloud::cpp::compute::node_groups::v1::InsertNodeGroupRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_node_groups_v1::NodeGroupsConnection::InsertNodeGroup");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->InsertNodeGroup(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NodeGroupsTracingConnection::InsertNodeGroup(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_node_groups_v1::NodeGroupsConnection::InsertNodeGroup");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->InsertNodeGroup(operation));
}

StreamRange<google::cloud::cpp::compute::v1::NodeGroup>
NodeGroupsTracingConnection::ListNodeGroups(
    google::cloud::cpp::compute::node_groups::v1::ListNodeGroupsRequest
        request) {
  auto span = internal::MakeSpan(
      "compute_node_groups_v1::NodeGroupsConnection::ListNodeGroups");
  internal::OTelScope scope(span);
  auto sr = child_->ListNodeGroups(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::cpp::compute::v1::NodeGroup>(std::move(span),
                                                  std::move(sr));
}

StreamRange<google::cloud::cpp::compute::v1::NodeGroupNode>
NodeGroupsTracingConnection::ListNodes(
    google::cloud::cpp::compute::node_groups::v1::ListNodesRequest request) {
  auto span = internal::MakeSpan(
      "compute_node_groups_v1::NodeGroupsConnection::ListNodes");
  internal::OTelScope scope(span);
  auto sr = child_->ListNodes(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::cpp::compute::v1::NodeGroupNode>(std::move(span),
                                                      std::move(sr));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NodeGroupsTracingConnection::PatchNodeGroup(
    google::cloud::cpp::compute::node_groups::v1::PatchNodeGroupRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_node_groups_v1::NodeGroupsConnection::PatchNodeGroup");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->PatchNodeGroup(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
NodeGroupsTracingConnection::PatchNodeGroup(
    NoAwaitTag,
    google::cloud::cpp::compute::node_groups::v1::PatchNodeGroupRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_node_groups_v1::NodeGroupsConnection::PatchNodeGroup");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->PatchNodeGroup(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NodeGroupsTracingConnection::PatchNodeGroup(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_node_groups_v1::NodeGroupsConnection::PatchNodeGroup");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->PatchNodeGroup(operation));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NodeGroupsTracingConnection::PerformMaintenance(
    google::cloud::cpp::compute::node_groups::v1::
        PerformMaintenanceRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_node_groups_v1::NodeGroupsConnection::PerformMaintenance");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->PerformMaintenance(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
NodeGroupsTracingConnection::PerformMaintenance(
    NoAwaitTag, google::cloud::cpp::compute::node_groups::v1::
                    PerformMaintenanceRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_node_groups_v1::NodeGroupsConnection::PerformMaintenance");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->PerformMaintenance(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NodeGroupsTracingConnection::PerformMaintenance(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_node_groups_v1::NodeGroupsConnection::PerformMaintenance");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->PerformMaintenance(operation));
}

StatusOr<google::cloud::cpp::compute::v1::Policy>
NodeGroupsTracingConnection::SetIamPolicy(
    google::cloud::cpp::compute::node_groups::v1::SetIamPolicyRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_node_groups_v1::NodeGroupsConnection::SetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->SetIamPolicy(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NodeGroupsTracingConnection::SetNodeTemplate(
    google::cloud::cpp::compute::node_groups::v1::SetNodeTemplateRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_node_groups_v1::NodeGroupsConnection::SetNodeTemplate");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->SetNodeTemplate(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
NodeGroupsTracingConnection::SetNodeTemplate(
    NoAwaitTag,
    google::cloud::cpp::compute::node_groups::v1::SetNodeTemplateRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_node_groups_v1::NodeGroupsConnection::SetNodeTemplate");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->SetNodeTemplate(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NodeGroupsTracingConnection::SetNodeTemplate(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_node_groups_v1::NodeGroupsConnection::SetNodeTemplate");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->SetNodeTemplate(operation));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NodeGroupsTracingConnection::SimulateMaintenanceEvent(
    google::cloud::cpp::compute::node_groups::v1::
        SimulateMaintenanceEventRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_node_groups_v1::NodeGroupsConnection::SimulateMaintenanceEvent");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->SimulateMaintenanceEvent(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
NodeGroupsTracingConnection::SimulateMaintenanceEvent(
    NoAwaitTag, google::cloud::cpp::compute::node_groups::v1::
                    SimulateMaintenanceEventRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_node_groups_v1::NodeGroupsConnection::SimulateMaintenanceEvent");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->SimulateMaintenanceEvent(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NodeGroupsTracingConnection::SimulateMaintenanceEvent(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_node_groups_v1::NodeGroupsConnection::SimulateMaintenanceEvent");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->SimulateMaintenanceEvent(operation));
}

StatusOr<google::cloud::cpp::compute::v1::TestPermissionsResponse>
NodeGroupsTracingConnection::TestIamPermissions(
    google::cloud::cpp::compute::node_groups::v1::
        TestIamPermissionsRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_node_groups_v1::NodeGroupsConnection::TestIamPermissions");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->TestIamPermissions(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<compute_node_groups_v1::NodeGroupsConnection>
MakeNodeGroupsTracingConnection(
    std::shared_ptr<compute_node_groups_v1::NodeGroupsConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<NodeGroupsTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_node_groups_v1_internal
}  // namespace cloud
}  // namespace google
