// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source:
// google/cloud/compute/target_https_proxies/v1/target_https_proxies.proto

#include "google/cloud/compute/target_https_proxies/v1/internal/target_https_proxies_rest_metadata_decorator.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/internal/rest_set_metadata.h"
#include "google/cloud/status_or.h"
#include "absl/strings/str_format.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace compute_target_https_proxies_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

TargetHttpsProxiesRestMetadata::TargetHttpsProxiesRestMetadata(
    std::shared_ptr<TargetHttpsProxiesRestStub> child,
    std::string api_client_header)
    : child_(std::move(child)),
      api_client_header_(
          api_client_header.empty()
              ? google::cloud::internal::GeneratedLibClientHeader()
              : std::move(api_client_header)) {}

StatusOr<google::cloud::cpp::compute::v1::TargetHttpsProxyAggregatedList>
TargetHttpsProxiesRestMetadata::AggregatedListTargetHttpsProxies(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::target_https_proxies::v1::
        AggregatedListTargetHttpsProxiesRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->AggregatedListTargetHttpsProxies(rest_context, options,
                                                  request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
TargetHttpsProxiesRestMetadata::AsyncDeleteTargetHttpsProxy(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::target_https_proxies::v1::
        DeleteTargetHttpsProxyRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncDeleteTargetHttpsProxy(cq, std::move(rest_context),
                                             std::move(options), request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
TargetHttpsProxiesRestMetadata::DeleteTargetHttpsProxy(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::target_https_proxies::v1::
        DeleteTargetHttpsProxyRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->DeleteTargetHttpsProxy(rest_context, options, request);
}

StatusOr<google::cloud::cpp::compute::v1::TargetHttpsProxy>
TargetHttpsProxiesRestMetadata::GetTargetHttpsProxy(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::target_https_proxies::v1::
        GetTargetHttpsProxyRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->GetTargetHttpsProxy(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
TargetHttpsProxiesRestMetadata::AsyncInsertTargetHttpsProxy(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::target_https_proxies::v1::
        InsertTargetHttpsProxyRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncInsertTargetHttpsProxy(cq, std::move(rest_context),
                                             std::move(options), request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
TargetHttpsProxiesRestMetadata::InsertTargetHttpsProxy(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::target_https_proxies::v1::
        InsertTargetHttpsProxyRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->InsertTargetHttpsProxy(rest_context, options, request);
}

StatusOr<google::cloud::cpp::compute::v1::TargetHttpsProxyList>
TargetHttpsProxiesRestMetadata::ListTargetHttpsProxies(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::target_https_proxies::v1::
        ListTargetHttpsProxiesRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->ListTargetHttpsProxies(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
TargetHttpsProxiesRestMetadata::AsyncPatchTargetHttpsProxy(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::target_https_proxies::v1::
        PatchTargetHttpsProxyRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncPatchTargetHttpsProxy(cq, std::move(rest_context),
                                            std::move(options), request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
TargetHttpsProxiesRestMetadata::PatchTargetHttpsProxy(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::target_https_proxies::v1::
        PatchTargetHttpsProxyRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->PatchTargetHttpsProxy(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
TargetHttpsProxiesRestMetadata::AsyncSetCertificateMap(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::target_https_proxies::v1::
        SetCertificateMapRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncSetCertificateMap(cq, std::move(rest_context),
                                        std::move(options), request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
TargetHttpsProxiesRestMetadata::SetCertificateMap(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::target_https_proxies::v1::
        SetCertificateMapRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->SetCertificateMap(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
TargetHttpsProxiesRestMetadata::AsyncSetQuicOverride(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::target_https_proxies::v1::
        SetQuicOverrideRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncSetQuicOverride(cq, std::move(rest_context),
                                      std::move(options), request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
TargetHttpsProxiesRestMetadata::SetQuicOverride(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::target_https_proxies::v1::
        SetQuicOverrideRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->SetQuicOverride(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
TargetHttpsProxiesRestMetadata::AsyncSetSslCertificates(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::target_https_proxies::v1::
        SetSslCertificatesRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncSetSslCertificates(cq, std::move(rest_context),
                                         std::move(options), request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
TargetHttpsProxiesRestMetadata::SetSslCertificates(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::target_https_proxies::v1::
        SetSslCertificatesRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->SetSslCertificates(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
TargetHttpsProxiesRestMetadata::AsyncSetSslPolicy(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::target_https_proxies::v1::
        SetSslPolicyRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncSetSslPolicy(cq, std::move(rest_context),
                                   std::move(options), request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
TargetHttpsProxiesRestMetadata::SetSslPolicy(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::target_https_proxies::v1::
        SetSslPolicyRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->SetSslPolicy(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
TargetHttpsProxiesRestMetadata::AsyncSetUrlMap(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::target_https_proxies::v1::
        SetUrlMapRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncSetUrlMap(cq, std::move(rest_context), std::move(options),
                                request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
TargetHttpsProxiesRestMetadata::SetUrlMap(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::target_https_proxies::v1::
        SetUrlMapRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->SetUrlMap(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
TargetHttpsProxiesRestMetadata::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::global_operations::v1::
        GetOperationRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncGetOperation(cq, std::move(rest_context),
                                   std::move(options), request);
}

future<Status> TargetHttpsProxiesRestMetadata::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::global_operations::v1::
        DeleteOperationRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncCancelOperation(cq, std::move(rest_context),
                                      std::move(options), request);
}

void TargetHttpsProxiesRestMetadata::SetMetadata(
    rest_internal::RestContext& rest_context, Options const& options,
    std::vector<std::string> const& params) {
  google::cloud::rest_internal::SetMetadata(rest_context, options, params,
                                            api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_target_https_proxies_v1_internal
}  // namespace cloud
}  // namespace google
