// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dataplex/v1/metadata.proto

#include "google/cloud/dataplex/v1/internal/metadata_stub.h"
#include "google/cloud/grpc_error_delegate.h"
#include "google/cloud/status_or.h"
#include <google/cloud/dataplex/v1/metadata.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace dataplex_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

MetadataServiceStub::~MetadataServiceStub() = default;

StatusOr<google::cloud::dataplex::v1::Entity>
DefaultMetadataServiceStub::CreateEntity(
    grpc::ClientContext& context, Options const&,
    google::cloud::dataplex::v1::CreateEntityRequest const& request) {
  google::cloud::dataplex::v1::Entity response;
  auto status = grpc_stub_->CreateEntity(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::dataplex::v1::Entity>
DefaultMetadataServiceStub::UpdateEntity(
    grpc::ClientContext& context, Options const&,
    google::cloud::dataplex::v1::UpdateEntityRequest const& request) {
  google::cloud::dataplex::v1::Entity response;
  auto status = grpc_stub_->UpdateEntity(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

Status DefaultMetadataServiceStub::DeleteEntity(
    grpc::ClientContext& context, Options const&,
    google::cloud::dataplex::v1::DeleteEntityRequest const& request) {
  google::protobuf::Empty response;
  auto status = grpc_stub_->DeleteEntity(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return google::cloud::Status();
}

StatusOr<google::cloud::dataplex::v1::Entity>
DefaultMetadataServiceStub::GetEntity(
    grpc::ClientContext& context, Options const&,
    google::cloud::dataplex::v1::GetEntityRequest const& request) {
  google::cloud::dataplex::v1::Entity response;
  auto status = grpc_stub_->GetEntity(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::dataplex::v1::ListEntitiesResponse>
DefaultMetadataServiceStub::ListEntities(
    grpc::ClientContext& context, Options const&,
    google::cloud::dataplex::v1::ListEntitiesRequest const& request) {
  google::cloud::dataplex::v1::ListEntitiesResponse response;
  auto status = grpc_stub_->ListEntities(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::dataplex::v1::Partition>
DefaultMetadataServiceStub::CreatePartition(
    grpc::ClientContext& context, Options const&,
    google::cloud::dataplex::v1::CreatePartitionRequest const& request) {
  google::cloud::dataplex::v1::Partition response;
  auto status = grpc_stub_->CreatePartition(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

Status DefaultMetadataServiceStub::DeletePartition(
    grpc::ClientContext& context, Options const&,
    google::cloud::dataplex::v1::DeletePartitionRequest const& request) {
  google::protobuf::Empty response;
  auto status = grpc_stub_->DeletePartition(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return google::cloud::Status();
}

StatusOr<google::cloud::dataplex::v1::Partition>
DefaultMetadataServiceStub::GetPartition(
    grpc::ClientContext& context, Options const&,
    google::cloud::dataplex::v1::GetPartitionRequest const& request) {
  google::cloud::dataplex::v1::Partition response;
  auto status = grpc_stub_->GetPartition(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::dataplex::v1::ListPartitionsResponse>
DefaultMetadataServiceStub::ListPartitions(
    grpc::ClientContext& context, Options const&,
    google::cloud::dataplex::v1::ListPartitionsRequest const& request) {
  google::cloud::dataplex::v1::ListPartitionsResponse response;
  auto status = grpc_stub_->ListPartitions(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dataplex_v1_internal
}  // namespace cloud
}  // namespace google
